/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.draw.shapes;

import de.neemann.digital.draw.elements.IOState;
import de.neemann.digital.draw.elements.Pins;
import de.neemann.digital.draw.graphics.Graphic;
import de.neemann.digital.draw.graphics.Orientation;
import de.neemann.digital.draw.graphics.Style;
import de.neemann.digital.draw.graphics.Vector;
import de.neemann.digital.draw.shapes.Interactor;
import de.neemann.digital.draw.shapes.Shape;
import de.neemann.digital.lang.Lang;

public class MissingShape
implements Shape {
    private final Pins pins = new Pins();
    private final Exception cause;
    private final String message;

    public MissingShape(String elementName, Exception cause) {
        this.message = Lang.get("msg_missingShape_N", elementName);
        this.cause = cause;
    }

    @Override
    public Pins getPins() {
        return this.pins;
    }

    @Override
    public Interactor applyStateMonitor(IOState ioState) {
        return null;
    }

    @Override
    public void drawTo(Graphic graphic, Style highLight) {
        Style style = Style.NORMAL_TEXT;
        graphic.drawText(new Vector(4, 4), this.message, Orientation.LEFTTOP, style);
        Throwable c = this.cause;
        int y = 4;
        while (c != null) {
            String message = c.getMessage();
            if (message != null && message.length() > 0) {
                if (message.length() > 100) {
                    message = String.valueOf(message.substring(0, 100)) + "...";
                }
                graphic.drawText(new Vector(4, y += style.getFontSize()), message, Orientation.LEFTTOP, style);
            }
            c = c.getCause();
        }
    }
}

