/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.draw.shapes;

import de.neemann.digital.core.Value;
import de.neemann.digital.core.ValueFormatter;
import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.Keys;
import de.neemann.digital.core.element.PinDescription;
import de.neemann.digital.core.element.PinDescriptions;
import de.neemann.digital.draw.elements.IOState;
import de.neemann.digital.draw.elements.Pin;
import de.neemann.digital.draw.elements.Pins;
import de.neemann.digital.draw.graphics.Graphic;
import de.neemann.digital.draw.graphics.Orientation;
import de.neemann.digital.draw.graphics.Style;
import de.neemann.digital.draw.graphics.Vector;
import de.neemann.digital.draw.shapes.Interactor;
import de.neemann.digital.draw.shapes.Shape;

public class OutputShape
implements Shape {
    public static final int OUT_SIZE = 15;
    static final Vector LATEX_RAD = new Vector(4, 4);
    private final String label;
    private final PinDescriptions inputs;
    private final ValueFormatter formatter;
    private final boolean small;
    private IOState ioState;
    private Value value;

    public static int getOutSize(boolean small) {
        if (small) {
            return 10;
        }
        return 15;
    }

    public static Style getOutStyle(boolean small) {
        if (small) {
            return Style.THIN;
        }
        return Style.NORMAL;
    }

    public static Vector getOutRad(boolean small) {
        int s = OutputShape.getOutSize(small);
        return new Vector(s - 6, s - 6);
    }

    public OutputShape(ElementAttributes attr, PinDescriptions inputs, PinDescriptions outputs) {
        this.inputs = inputs;
        String pinNumber = attr.get(Keys.PINNUMBER);
        this.label = pinNumber.length() == 0 ? attr.getLabel() : String.valueOf(attr.getLabel()) + " (" + pinNumber + ")";
        this.formatter = attr.getValueFormatter();
        this.small = attr.get(Keys.IN_OUT_SMALL);
    }

    @Override
    public Pins getPins() {
        return new Pins().add(new Pin(new Vector(0, 0), (PinDescription)this.inputs.get(0)));
    }

    @Override
    public Interactor applyStateMonitor(IOState ioState) {
        this.ioState = ioState;
        return null;
    }

    @Override
    public void readObservableValues() {
        if (this.ioState != null) {
            this.value = this.ioState.getInput(0).getCopy();
        }
    }

    @Override
    public void drawTo(Graphic graphic, Style highLight) {
        if (graphic.isFlagSet(Graphic.Flag.smallIO)) {
            Vector center = new Vector(OutputShape.LATEX_RAD.x, 0);
            graphic.drawCircle(center.sub(LATEX_RAD), center.add(LATEX_RAD), Style.NORMAL);
            Vector textPos = new Vector(10 + OutputShape.LATEX_RAD.x, 0);
            graphic.drawText(textPos, this.label, Orientation.LEFTCENTER, Style.INOUT);
        } else {
            int outSize = OutputShape.getOutSize(this.small);
            Style style = OutputShape.getOutStyle(this.small);
            if (this.value != null) {
                style = Style.getWireStyle(this.value);
                if (this.value.getBits() > 1) {
                    Vector textPos = new Vector(1 + outSize, -4 - outSize);
                    graphic.drawText(textPos, this.formatter.formatToView(this.value), Orientation.CENTERBOTTOM, Style.NORMAL);
                }
            }
            Vector radl = new Vector(outSize, outSize);
            Vector rad = OutputShape.getOutRad(this.small);
            Vector center = new Vector(1 + outSize, 0);
            graphic.drawCircle(center.sub(rad), center.add(rad), style);
            graphic.drawCircle(center.sub(radl), center.add(radl), Style.NORMAL);
            Vector textPos = new Vector(outSize * 3, 0);
            graphic.drawText(textPos, this.label, Orientation.LEFTCENTER, Style.INOUT);
        }
    }
}

