/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.draw.shapes;

import de.neemann.digital.core.ObservableValue;
import de.neemann.digital.core.Value;
import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.Keys;
import de.neemann.digital.core.element.PinDescription;
import de.neemann.digital.core.element.PinDescriptions;
import de.neemann.digital.draw.elements.IOState;
import de.neemann.digital.draw.elements.Pin;
import de.neemann.digital.draw.elements.Pins;
import de.neemann.digital.draw.graphics.Graphic;
import de.neemann.digital.draw.graphics.Orientation;
import de.neemann.digital.draw.graphics.Polygon;
import de.neemann.digital.draw.graphics.Style;
import de.neemann.digital.draw.graphics.Vector;
import de.neemann.digital.draw.shapes.InteractorInterface;
import de.neemann.digital.draw.shapes.Shape;

public class PolarityAwareLEDShape
implements Shape {
    private static final int RAD = 15;
    private final PinDescriptions inputs;
    private final Style style;
    private final String label;
    private ObservableValue aValue;
    private ObservableValue cValue;
    private Value a;
    private Value c;

    public PolarityAwareLEDShape(ElementAttributes attr, PinDescriptions inputs, PinDescriptions outputs) {
        this.inputs = inputs;
        this.style = Style.NORMAL.deriveFillStyle(attr.get(Keys.COLOR));
        String l = attr.getLabel();
        this.label = l == null || l.trim().length() == 0 ? null : l;
    }

    @Override
    public Pins getPins() {
        return new Pins().add(new Pin(new Vector(0, 0), (PinDescription)this.inputs.get(0))).add(new Pin(new Vector(0, 80), (PinDescription)this.inputs.get(1)));
    }

    @Override
    public InteractorInterface applyStateMonitor(IOState ioState) {
        this.aValue = ioState.getInput(0);
        this.cValue = ioState.getInput(1);
        return null;
    }

    @Override
    public void readObservableValues() {
        if (this.aValue != null && this.cValue != null) {
            this.a = this.aValue.getCopy();
            this.c = this.cValue.getCopy();
        }
    }

    @Override
    public void drawTo(Graphic graphic, Style highLight) {
        graphic.drawPolygon(new Polygon(true).add(-7, 69).add(-7, 44).add(7, 44).add(7, 69), Style.NORMAL);
        graphic.drawLine(new Vector(0, 70), new Vector(0, 80), Style.NORMAL);
        if (this.label != null) {
            Vector textPos = new Vector(30, 20);
            graphic.drawText(textPos, this.label, Orientation.LEFTCENTER, Style.NORMAL);
        }
        if (this.a == null || this.c == null) {
            graphic.drawPolygon(new Polygon(true).add(-10, 11).add(10, 11).add(0, 29), Style.NORMAL);
            graphic.drawLine(new Vector(-10, 29), new Vector(10, 29), Style.NORMAL);
            graphic.drawLine(new Vector(0, 29), new Vector(0, 44), Style.NORMAL);
            graphic.drawLine(new Vector(0, 0), new Vector(0, 9), Style.NORMAL);
            graphic.drawLine(new Vector(20, 12), new Vector(11, 21), Style.THIN);
            graphic.drawLine(new Vector(18, 11), new Vector(21, 11), Style.THIN);
            graphic.drawLine(new Vector(21, 14), new Vector(21, 11), Style.THIN);
            graphic.drawLine(new Vector(26, 18), new Vector(17, 27), Style.THIN);
            graphic.drawLine(new Vector(24, 17), new Vector(27, 17), Style.THIN);
            graphic.drawLine(new Vector(27, 20), new Vector(27, 17), Style.THIN);
        } else {
            boolean cActive;
            Vector center = new Vector(0, 20);
            Vector rad = new Vector(15, 15);
            graphic.drawLine(new Vector(0, 44), new Vector(0, 0), Style.NORMAL);
            graphic.drawCircle(center.sub(rad), center.add(rad), Style.FILLED);
            boolean aActive = this.a.getBool() && !this.a.isHighZ();
            boolean bl = cActive = !this.c.getBool() && !this.c.isHighZ();
            if (aActive && cActive) {
                Vector radL = new Vector(13, 13);
                graphic.drawCircle(center.sub(radL), center.add(radL), this.style);
            }
        }
    }
}

