/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.draw.shapes;

import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.Keys;
import de.neemann.digital.core.element.PinDescriptions;
import de.neemann.digital.draw.elements.IOState;
import de.neemann.digital.draw.elements.Pins;
import de.neemann.digital.draw.graphics.Graphic;
import de.neemann.digital.draw.graphics.Orientation;
import de.neemann.digital.draw.graphics.Polygon;
import de.neemann.digital.draw.graphics.Style;
import de.neemann.digital.draw.graphics.Vector;
import de.neemann.digital.draw.shapes.Interactor;
import de.neemann.digital.draw.shapes.ShapeSpecificMatch;
import de.neemann.digital.lang.Lang;

public class RectShape
implements ShapeSpecificMatch {
    private final String label;
    private final int width;
    private final int height;
    private final boolean inside;
    private final boolean bottom;
    private final boolean right;
    private final int fontSize;

    public RectShape(ElementAttributes attr, PinDescriptions inputs, PinDescriptions outputs) {
        String l = attr.get(Keys.LABEL);
        this.label = l.isEmpty() ? Lang.get("elem_Text", new Object[0]) : (l.equals("-") ? "" : Lang.evalMultilingualContent(l));
        this.width = attr.get(Keys.RECT_WIDTH);
        this.height = attr.get(Keys.RECT_HEIGHT);
        this.inside = attr.get(Keys.RECT_INSIDE);
        this.bottom = attr.get(Keys.RECT_BOTTOM);
        this.right = attr.get(Keys.RECT_RIGHT);
        this.fontSize = attr.get(Keys.FONT_SIZE);
    }

    @Override
    public Pins getPins() {
        return new Pins();
    }

    @Override
    public Interactor applyStateMonitor(IOState ioState) {
        return null;
    }

    @Override
    public void drawTo(Graphic graphic, Style highLight) {
        Orientation orientation;
        int ofs = -3;
        Orientation orientation2 = orientation = this.right ? Orientation.RIGHTBOTTOM : Orientation.LEFTBOTTOM;
        if (this.inside ^ this.bottom) {
            ofs = -ofs;
            orientation = this.right ? Orientation.RIGHTTOP : Orientation.LEFTTOP;
        }
        Vector pos = new Vector(2, ofs);
        if (this.right) {
            pos = pos.add(this.width * 20 - 4, 0);
        }
        if (this.bottom) {
            pos = pos.add(0, this.height * 20);
        }
        Style style = Style.NORMAL.deriveFontStyle(this.fontSize, true);
        if (!this.label.isEmpty()) {
            graphic.drawText(pos, this.label, orientation, style);
        }
        graphic.drawPolygon(new Polygon(true).add(0, 0).add(this.width * 20, 0).add(this.width * 20, this.height * 20).add(0, this.height * 20), Style.DASH);
    }

    @Override
    public boolean matches(Vector pos) {
        return pos.x > -10 && pos.x < 10 && pos.y > -10 && pos.y < this.height * 20 + 10 || pos.x > this.width * 20 - 10 && pos.x < this.width * 20 + 10 && pos.y > -10 && pos.y < this.height * 20 + 10 || pos.y > -10 && pos.y < 10 && pos.x > -10 && pos.x < this.width * 20 + 10 || pos.y > this.height * 20 - 10 && pos.y < this.height * 20 + 10 && pos.x > -10 && pos.x < this.width * 20 + 10;
    }
}

