/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.draw.shapes;

import de.neemann.digital.core.SyncAccess;
import de.neemann.digital.core.element.Element;
import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.PinDescription;
import de.neemann.digital.core.element.PinDescriptions;
import de.neemann.digital.draw.elements.IOState;
import de.neemann.digital.draw.elements.Pin;
import de.neemann.digital.draw.elements.Pins;
import de.neemann.digital.draw.graphics.Graphic;
import de.neemann.digital.draw.graphics.Orientation;
import de.neemann.digital.draw.graphics.Polygon;
import de.neemann.digital.draw.graphics.Style;
import de.neemann.digital.draw.graphics.Transform;
import de.neemann.digital.draw.graphics.Vector;
import de.neemann.digital.draw.shapes.InteractorInterface;
import de.neemann.digital.draw.shapes.Shape;
import de.neemann.digital.gui.components.CircuitComponent;
import java.awt.Color;
import java.awt.Point;

public class RotEncoderShape
implements Shape {
    private static final Style KNOB = Style.NORMAL.deriveStyle(4, true, Color.DARK_GRAY);
    private static final Style MARKER = Style.NORMAL.deriveStyle(4, false, Color.LIGHT_GRAY);
    private static final Vector CENTER = new Vector(-30, 10);
    private final String label;
    private final PinDescriptions outputs;
    private int state;

    public RotEncoderShape(ElementAttributes attr, PinDescriptions inputs, PinDescriptions outputs) {
        this.outputs = outputs;
        this.label = attr.getLabel();
    }

    @Override
    public Pins getPins() {
        return new Pins().add(new Pin(new Vector(0, 0), (PinDescription)this.outputs.get(0))).add(new Pin(new Vector(0, 20), (PinDescription)this.outputs.get(1)));
    }

    @Override
    public InteractorInterface applyStateMonitor(IOState ioState) {
        return new InteractorInterface(){
            private int initialState;
            private boolean initial;

            @Override
            public void clicked(CircuitComponent cc, Point pos, IOState ioState, Element element, SyncAccess modelSync) {
            }

            @Override
            public void pressed(CircuitComponent cc, Point pos, IOState ioState, Element element, SyncAccess modelSync) {
                this.initial = true;
            }

            @Override
            public void released(CircuitComponent cc, Point pos, IOState ioState, Element element, SyncAccess modelSync) {
            }

            @Override
            public void dragged(CircuitComponent cc, Point posOnScreen, Vector pos, Transform trans, IOState ioState, Element element, SyncAccess modelSync) {
                if (ioState != null) {
                    Vector p = pos.sub(trans.transform(CENTER));
                    int dist = p.x * p.x + p.y * p.y;
                    if (dist > 100 && dist < 900) {
                        int s = (int)(Math.atan2(p.y, p.x) / Math.PI * 16.0);
                        if (this.initial) {
                            this.initialState = s;
                            this.initial = false;
                        } else if (s != this.initialState) {
                            RotEncoderShape rotEncoderShape = RotEncoderShape.this;
                            rotEncoderShape.state = rotEncoderShape.state + (s - this.initialState);
                            this.initialState = s;
                            modelSync.modify(() -> {
                                boolean a = (RotEncoderShape.this.state & 2) != 0;
                                boolean b = (RotEncoderShape.this.state + 1 & 2) != 0;
                                ioState.getOutput(0).setBool(a);
                                ioState.getOutput(1).setBool(b);
                            });
                        }
                    } else {
                        this.initial = true;
                    }
                }
            }
        };
    }

    @Override
    public void drawTo(Graphic graphic, Style heighLight) {
        graphic.drawPolygon(new Polygon(true).add(0, -20).add(0, 40).add(-60, 40).add(-60, -20), Style.NORMAL);
        int r = 20;
        graphic.drawCircle(CENTER.add(-20, -20), CENTER.add(20, 20), KNOB);
        double alpha = (double)this.state / 16.0 * Math.PI;
        int x = (int)Math.round(20.0 * Math.cos(alpha));
        int y = (int)Math.round(20.0 * Math.sin(alpha));
        graphic.drawLine(CENTER, CENTER.add(x, y), MARKER);
        Vector textPos = CENTER.add(0, 34);
        graphic.drawText(textPos, this.label, Orientation.CENTERTOP, Style.NORMAL);
    }
}

