/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.draw.shapes;

import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.PinDescription;
import de.neemann.digital.core.element.PinDescriptions;
import de.neemann.digital.draw.elements.IOState;
import de.neemann.digital.draw.elements.Pin;
import de.neemann.digital.draw.elements.Pins;
import de.neemann.digital.draw.graphics.ColorKey;
import de.neemann.digital.draw.graphics.Graphic;
import de.neemann.digital.draw.graphics.Polygon;
import de.neemann.digital.draw.graphics.Style;
import de.neemann.digital.draw.graphics.Vector;
import de.neemann.digital.draw.shapes.InteractorInterface;
import de.neemann.digital.draw.shapes.Shape;

public class ScopeShape
implements Shape {
    private static final Style TRACE_STYLE = Style.THIN.deriveColor(ColorKey.WIRE_LOW);
    private static final int BORDER = 6;
    private static final Polygon OUTER = new Polygon().add(2, 10).add(2, -40).add(80, -40).add(80, 10);
    private static final Polygon INNER = new Polygon().add(8, 4).add(8, -34).add(54, -34).add(54, 4).roundEdges(12);
    private static final Polygon TRACE = new Polygon(false).add(9, -6).add(26, -6).add(26, -26).add(46, -26).add(46, -6).add(53, -6);
    private final PinDescription clock;

    public ScopeShape(ElementAttributes attr, PinDescriptions inputs, PinDescriptions outputs) {
        this.clock = (PinDescription)inputs.get(0);
    }

    @Override
    public Pins getPins() {
        return new Pins().add(new Pin(new Vector(0, 0), this.clock));
    }

    @Override
    public InteractorInterface applyStateMonitor(IOState ioState) {
        return null;
    }

    @Override
    public void drawTo(Graphic graphic, Style highLight) {
        graphic.drawPolygon(OUTER, Style.NORMAL);
        graphic.drawPolygon(TRACE, TRACE_STYLE);
        graphic.drawPolygon(INNER, Style.THIN);
    }
}

