/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.draw.shapes;

import de.neemann.digital.core.NodeException;
import de.neemann.digital.core.ObservableValue;
import de.neemann.digital.core.basic.And;
import de.neemann.digital.core.basic.NAnd;
import de.neemann.digital.core.basic.NOr;
import de.neemann.digital.core.basic.Not;
import de.neemann.digital.core.basic.Or;
import de.neemann.digital.core.basic.XNOr;
import de.neemann.digital.core.basic.XOr;
import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.ElementTypeDescription;
import de.neemann.digital.core.element.Keys;
import de.neemann.digital.core.element.PinDescriptions;
import de.neemann.digital.core.extern.External;
import de.neemann.digital.core.extern.ExternalFile;
import de.neemann.digital.core.io.Button;
import de.neemann.digital.core.io.ButtonLED;
import de.neemann.digital.core.io.Const;
import de.neemann.digital.core.io.DipSwitch;
import de.neemann.digital.core.io.Ground;
import de.neemann.digital.core.io.In;
import de.neemann.digital.core.io.LightBulb;
import de.neemann.digital.core.io.NotConnected;
import de.neemann.digital.core.io.Out;
import de.neemann.digital.core.io.PinControl;
import de.neemann.digital.core.io.Probe;
import de.neemann.digital.core.io.RGBLED;
import de.neemann.digital.core.io.RotEncoder;
import de.neemann.digital.core.io.StepperMotorBipolar;
import de.neemann.digital.core.io.StepperMotorUnipolar;
import de.neemann.digital.core.io.VDD;
import de.neemann.digital.core.memory.BlockRAMDualPort;
import de.neemann.digital.core.memory.EEPROM;
import de.neemann.digital.core.memory.EEPROMDualPort;
import de.neemann.digital.core.memory.RAMAsync;
import de.neemann.digital.core.memory.RAMDualAccess;
import de.neemann.digital.core.memory.RAMDualPort;
import de.neemann.digital.core.memory.RAMSinglePort;
import de.neemann.digital.core.memory.RAMSinglePortSel;
import de.neemann.digital.core.memory.RegisterFile;
import de.neemann.digital.core.pld.Diode;
import de.neemann.digital.core.pld.DiodeBackward;
import de.neemann.digital.core.pld.DiodeForward;
import de.neemann.digital.core.pld.PullDown;
import de.neemann.digital.core.pld.PullUp;
import de.neemann.digital.core.switching.FGNFET;
import de.neemann.digital.core.switching.FGPFET;
import de.neemann.digital.core.switching.Fuse;
import de.neemann.digital.core.switching.NFET;
import de.neemann.digital.core.switching.PFET;
import de.neemann.digital.core.switching.Relay;
import de.neemann.digital.core.switching.RelayDT;
import de.neemann.digital.core.switching.Switch;
import de.neemann.digital.core.switching.SwitchDT;
import de.neemann.digital.core.switching.TransGate;
import de.neemann.digital.core.wiring.AsyncSeq;
import de.neemann.digital.core.wiring.BitSelector;
import de.neemann.digital.core.wiring.Break;
import de.neemann.digital.core.wiring.BusSplitter;
import de.neemann.digital.core.wiring.Clock;
import de.neemann.digital.core.wiring.Decoder;
import de.neemann.digital.core.wiring.Delay;
import de.neemann.digital.core.wiring.Demultiplexer;
import de.neemann.digital.core.wiring.Driver;
import de.neemann.digital.core.wiring.DriverInvSel;
import de.neemann.digital.core.wiring.Multiplexer;
import de.neemann.digital.core.wiring.PriorityEncoder;
import de.neemann.digital.core.wiring.Reset;
import de.neemann.digital.core.wiring.Splitter;
import de.neemann.digital.draw.elements.PinException;
import de.neemann.digital.draw.elements.Tunnel;
import de.neemann.digital.draw.library.ElementLibrary;
import de.neemann.digital.draw.library.ElementTypeDescriptionCustom;
import de.neemann.digital.draw.library.GenericCode;
import de.neemann.digital.draw.library.GenericInitCode;
import de.neemann.digital.draw.library.JarComponentManager;
import de.neemann.digital.draw.shapes.AsyncClockShape;
import de.neemann.digital.draw.shapes.BitSelShape;
import de.neemann.digital.draw.shapes.BreakShape;
import de.neemann.digital.draw.shapes.BusSplitterShape;
import de.neemann.digital.draw.shapes.ButtonLEDShape;
import de.neemann.digital.draw.shapes.ButtonShape;
import de.neemann.digital.draw.shapes.ClockShape;
import de.neemann.digital.draw.shapes.ConstShape;
import de.neemann.digital.draw.shapes.CustomCircuitShapeType;
import de.neemann.digital.draw.shapes.DILShape;
import de.neemann.digital.draw.shapes.DataShape;
import de.neemann.digital.draw.shapes.DelayShape;
import de.neemann.digital.draw.shapes.DemuxerShape;
import de.neemann.digital.draw.shapes.DiodeBackwardShape;
import de.neemann.digital.draw.shapes.DiodeForewardShape;
import de.neemann.digital.draw.shapes.DiodeShape;
import de.neemann.digital.draw.shapes.DipSwitchShape;
import de.neemann.digital.draw.shapes.DriverShape;
import de.neemann.digital.draw.shapes.FETShapeN;
import de.neemann.digital.draw.shapes.FETShapeP;
import de.neemann.digital.draw.shapes.FGFETShapeN;
import de.neemann.digital.draw.shapes.FGFETShapeP;
import de.neemann.digital.draw.shapes.FuseShape;
import de.neemann.digital.draw.shapes.GenericCodeShape;
import de.neemann.digital.draw.shapes.GenericInitCodeShape;
import de.neemann.digital.draw.shapes.GenericShape;
import de.neemann.digital.draw.shapes.GroundShape;
import de.neemann.digital.draw.shapes.InputShape;
import de.neemann.digital.draw.shapes.LEDShape;
import de.neemann.digital.draw.shapes.LayoutShape;
import de.neemann.digital.draw.shapes.LightBulbShape;
import de.neemann.digital.draw.shapes.MinimizedShape;
import de.neemann.digital.draw.shapes.MissingShape;
import de.neemann.digital.draw.shapes.MuxerShape;
import de.neemann.digital.draw.shapes.NotConnectedShape;
import de.neemann.digital.draw.shapes.OutputShape;
import de.neemann.digital.draw.shapes.PinControlShape;
import de.neemann.digital.draw.shapes.PolarityAwareLEDShape;
import de.neemann.digital.draw.shapes.ProbeShape;
import de.neemann.digital.draw.shapes.PullDownShape;
import de.neemann.digital.draw.shapes.PullUpShape;
import de.neemann.digital.draw.shapes.RAMShape;
import de.neemann.digital.draw.shapes.RGBLEDShape;
import de.neemann.digital.draw.shapes.RectShape;
import de.neemann.digital.draw.shapes.RelayDTShape;
import de.neemann.digital.draw.shapes.RelayShape;
import de.neemann.digital.draw.shapes.ResetShape;
import de.neemann.digital.draw.shapes.RotEncoderShape;
import de.neemann.digital.draw.shapes.ScopeShape;
import de.neemann.digital.draw.shapes.SevenSegHexShape;
import de.neemann.digital.draw.shapes.SevenSegShape;
import de.neemann.digital.draw.shapes.Shape;
import de.neemann.digital.draw.shapes.SixteenShape;
import de.neemann.digital.draw.shapes.SplitterShape;
import de.neemann.digital.draw.shapes.StepperMotorShape;
import de.neemann.digital.draw.shapes.SwitchDTShape;
import de.neemann.digital.draw.shapes.SwitchShape;
import de.neemann.digital.draw.shapes.TestCaseShape;
import de.neemann.digital.draw.shapes.TextShape;
import de.neemann.digital.draw.shapes.TransGateShape;
import de.neemann.digital.draw.shapes.TunnelShape;
import de.neemann.digital.draw.shapes.VDDShape;
import de.neemann.digital.draw.shapes.custom.CustomShape;
import de.neemann.digital.draw.shapes.custom.CustomShapeDescription;
import de.neemann.digital.draw.shapes.ieee.IEEEAndShape;
import de.neemann.digital.draw.shapes.ieee.IEEENotShape;
import de.neemann.digital.draw.shapes.ieee.IEEEOrShape;
import de.neemann.digital.draw.shapes.ieee.IEEEXOrShape;
import de.neemann.digital.gui.components.data.DummyElement;
import de.neemann.digital.gui.components.data.ScopeTrigger;
import de.neemann.digital.lang.Lang;
import de.neemann.digital.testing.TestCaseElement;
import java.util.HashMap;

public final class ShapeFactory {
    private final HashMap<String, Creator> map = new HashMap();
    private final ElementLibrary library;

    public ShapeFactory(ElementLibrary library) {
        this(library, false);
    }

    public ShapeFactory(ElementLibrary library, boolean ieee) {
        this.library = library;
        library.setShapeFactory(this);
        if (ieee) {
            this.map.put(And.DESCRIPTION.getName(), (attributes, inputs, outputs) -> new IEEEAndShape(inputs, outputs, false, attributes));
            this.map.put(NAnd.DESCRIPTION.getName(), (attributes, inputs, outputs) -> new IEEEAndShape(inputs, outputs, true, attributes));
            this.map.put(Or.DESCRIPTION.getName(), (attributes, inputs, outputs) -> new IEEEOrShape(inputs, outputs, false, attributes));
            this.map.put(NOr.DESCRIPTION.getName(), (attributes, inputs, outputs) -> new IEEEOrShape(inputs, outputs, true, attributes));
            this.map.put(XOr.DESCRIPTION.getName(), (attributes, inputs, outputs) -> new IEEEXOrShape(inputs, outputs, false, attributes));
            this.map.put(XNOr.DESCRIPTION.getName(), (attributes, inputs, outputs) -> new IEEEXOrShape(inputs, outputs, true, attributes));
            this.map.put(Not.DESCRIPTION.getName(), (attributes, inputs, outputs) -> new IEEENotShape(inputs, outputs, attributes));
        } else {
            this.map.put(And.DESCRIPTION.getName(), new CreatorSimple("&", false));
            this.map.put(Or.DESCRIPTION.getName(), new CreatorSimple("\u22651", false));
            this.map.put(NAnd.DESCRIPTION.getName(), new CreatorSimple("&", true));
            this.map.put(NOr.DESCRIPTION.getName(), new CreatorSimple("\u22651", true));
            this.map.put(XOr.DESCRIPTION.getName(), new CreatorSimple("=1", false));
            this.map.put(XNOr.DESCRIPTION.getName(), new CreatorSimple("=1", true));
            this.map.put(Not.DESCRIPTION.getName(), (attributes, inputs, outputs) -> {
                boolean ws = attributes.get(Keys.WIDE_SHAPE);
                return new GenericShape(ws ? "1" : "", inputs, outputs).setTopBottomBorder(ws ? 20 : 10).invert(true).setWide(ws);
            });
        }
        this.map.put(RAMDualPort.DESCRIPTION.getName(), (attr, inputs, outputs) -> new RAMShape(attr, RAMDualPort.DESCRIPTION));
        this.map.put(RAMSinglePort.DESCRIPTION.getName(), (attr, inputs, outputs) -> new RAMShape(attr, RAMSinglePort.DESCRIPTION));
        this.map.put(RAMSinglePortSel.DESCRIPTION.getName(), (attr, inputs, outputs) -> new RAMShape(attr, RAMSinglePortSel.DESCRIPTION));
        this.map.put(EEPROM.DESCRIPTION.getName(), (attr, inputs, outputs) -> new RAMShape(attr, EEPROM.DESCRIPTION));
        this.map.put(EEPROMDualPort.DESCRIPTION.getName(), (attr, inputs, outputs) -> new RAMShape(attr, EEPROMDualPort.DESCRIPTION));
        this.map.put(RAMDualAccess.DESCRIPTION.getName(), (attr, inputs, outputs) -> new RAMShape(attr, RAMDualAccess.DESCRIPTION));
        this.map.put(RegisterFile.DESCRIPTION.getName(), (attr, inputs, outputs) -> new RAMShape(attr, RegisterFile.DESCRIPTION, 4));
        this.map.put(BlockRAMDualPort.DESCRIPTION.getName(), (attr, inputs, outputs) -> new RAMShape(attr, BlockRAMDualPort.DESCRIPTION));
        this.map.put(RAMAsync.DESCRIPTION.getName(), (attr, inputs, outputs) -> new RAMShape(attr, RAMAsync.DESCRIPTION));
        this.map.put(In.DESCRIPTION.getName(), InputShape::new);
        this.map.put(Reset.DESCRIPTION.getName(), ResetShape::new);
        this.map.put(Const.DESCRIPTION.getName(), ConstShape::new);
        this.map.put(Ground.DESCRIPTION.getName(), GroundShape::new);
        this.map.put(VDD.DESCRIPTION.getName(), VDDShape::new);
        this.map.put(NotConnected.DESCRIPTION.getName(), NotConnectedShape::new);
        this.map.put(Out.DESCRIPTION.getName(), OutputShape::new);
        this.map.put(Out.LEDDESCRIPTION.getName(), LEDShape::new);
        this.map.put(LightBulb.DESCRIPTION.getName(), LightBulbShape::new);
        this.map.put(RGBLED.DESCRIPTION.getName(), RGBLEDShape::new);
        this.map.put(Out.POLARITYAWARELEDDESCRIPTION.getName(), PolarityAwareLEDShape::new);
        this.map.put(Button.DESCRIPTION.getName(), ButtonShape::new);
        this.map.put(ButtonLED.DESCRIPTION.getName(), ButtonLEDShape::new);
        this.map.put(Probe.DESCRIPTION.getName(), ProbeShape::new);
        this.map.put(Clock.DESCRIPTION.getName(), ClockShape::new);
        this.map.put(Out.SEVENDESCRIPTION.getName(), SevenSegShape::new);
        this.map.put(Out.SEVENHEXDESCRIPTION.getName(), SevenSegHexShape::new);
        this.map.put(Out.SIXTEENDESCRIPTION.getName(), SixteenShape::new);
        this.map.put(DummyElement.DATADESCRIPTION.getName(), DataShape::new);
        this.map.put(ScopeTrigger.DESCRIPTION.getName(), ScopeShape::new);
        this.map.put(RotEncoder.DESCRIPTION.getName(), RotEncoderShape::new);
        this.map.put(StepperMotorUnipolar.DESCRIPTION.getName(), StepperMotorShape::new);
        this.map.put(StepperMotorBipolar.DESCRIPTION.getName(), StepperMotorShape::new);
        this.map.put(DipSwitch.DESCRIPTION.getName(), DipSwitchShape::new);
        this.map.put(Switch.DESCRIPTION.getName(), SwitchShape::new);
        this.map.put(SwitchDT.DESCRIPTION.getName(), SwitchDTShape::new);
        this.map.put(Fuse.DESCRIPTION.getName(), FuseShape::new);
        this.map.put(Relay.DESCRIPTION.getName(), RelayShape::new);
        this.map.put(RelayDT.DESCRIPTION.getName(), RelayDTShape::new);
        this.map.put(NFET.DESCRIPTION.getName(), FETShapeN::new);
        this.map.put(FGNFET.DESCRIPTION.getName(), FGFETShapeN::new);
        this.map.put(FGPFET.DESCRIPTION.getName(), FGFETShapeP::new);
        this.map.put(PFET.DESCRIPTION.getName(), FETShapeP::new);
        this.map.put(TransGate.DESCRIPTION.getName(), TransGateShape::new);
        this.map.put(Break.DESCRIPTION.getName(), BreakShape::new);
        this.map.put(Delay.DESCRIPTION.getName(), (attributes, inputs, outputs) -> new DelayShape());
        this.map.put(Multiplexer.DESCRIPTION.getName(), MuxerShape::new);
        this.map.put(Demultiplexer.DESCRIPTION.getName(), DemuxerShape::new);
        this.map.put(Decoder.DESCRIPTION.getName(), DemuxerShape::new);
        this.map.put(BitSelector.DESCRIPTION.getName(), BitSelShape::new);
        this.map.put(PriorityEncoder.DESCRIPTION.getName(), (attributes, inputs, outputs) -> new GenericShape(PriorityEncoder.DESCRIPTION.getShortName(), inputs, outputs, attributes.getLabel(), true, 4));
        this.map.put(Splitter.DESCRIPTION.getName(), SplitterShape::new);
        this.map.put(Driver.DESCRIPTION.getName(), DriverShape::new);
        this.map.put(DriverInvSel.DESCRIPTION.getName(), (attributes, inputs, outputs) -> new DriverShape(attributes, inputs, outputs, true));
        this.map.put(BusSplitter.DESCRIPTION.getName(), BusSplitterShape::new);
        this.map.put(Tunnel.DESCRIPTION.getName(), TunnelShape::new);
        this.map.put(DummyElement.TEXTDESCRIPTION.getName(), TextShape::new);
        this.map.put(DummyElement.RECTDESCRIPTION.getName(), RectShape::new);
        this.map.put(TestCaseElement.DESCRIPTION.getName(), TestCaseShape::new);
        this.map.put(GenericInitCode.DESCRIPTION.getName(), GenericInitCodeShape::new);
        this.map.put(GenericCode.DESCRIPTION.getName(), GenericCodeShape::new);
        this.map.put(AsyncSeq.DESCRIPTION.getName(), AsyncClockShape::new);
        this.map.put(Diode.DESCRIPTION.getName(), DiodeShape::new);
        this.map.put(DiodeForward.DESCRIPTION.getName(), DiodeForewardShape::new);
        this.map.put(DiodeBackward.DESCRIPTION.getName(), DiodeBackwardShape::new);
        this.map.put(PullUp.DESCRIPTION.getName(), PullUpShape::new);
        this.map.put(PullDown.DESCRIPTION.getName(), PullDownShape::new);
        this.map.put(PinControl.DESCRIPTION.getName(), PinControlShape::new);
        this.map.put(External.DESCRIPTION.getName(), new ExternCreator(External.DESCRIPTION));
        this.map.put(ExternalFile.DESCRIPTION.getName(), new ExternCreator(ExternalFile.DESCRIPTION));
        JarComponentManager jcm = library.getJarComponentManager();
        if (jcm != null) {
            for (JarComponentManager.AdditionalShape c : jcm) {
                this.map.put(c.getDescription().getName(), c.getShape());
            }
        }
    }

    public Shape getShape(String elementName, ElementAttributes elementAttributes) {
        Creator cr = this.map.get(elementName);
        try {
            if (cr == null) {
                if (this.library == null) {
                    throw new NodeException(Lang.get("err_noShapeFoundFor_N", elementName), new ObservableValue[0]);
                }
                ElementTypeDescription pt = this.library.getElementType(elementName);
                if (pt instanceof ElementTypeDescriptionCustom) {
                    ElementTypeDescriptionCustom customDescr = (ElementTypeDescriptionCustom)pt;
                    CustomCircuitShapeType shapeType = customDescr.getAttributes().get(Keys.SHAPE_TYPE);
                    CustomCircuitShapeType localShapeType = elementAttributes.get(Keys.SHAPE_TYPE);
                    if (!localShapeType.equals((Object)CustomCircuitShapeType.DEFAULT)) {
                        shapeType = localShapeType;
                    }
                    switch (shapeType) {
                        case DIL: {
                            return new DILShape(pt.getShortName(), pt.getInputDescription(elementAttributes), pt.getOutputDescriptions(elementAttributes), elementAttributes.getLabel(), customDescr.getAttributes());
                        }
                        case LAYOUT: {
                            return new LayoutShape(customDescr, elementAttributes);
                        }
                        case MINIMIZED: {
                            return new MinimizedShape(customDescr, elementAttributes);
                        }
                        case CUSTOM: {
                            CustomShapeDescription customShapeDescription = customDescr.getAttributes().get(Keys.CUSTOM_SHAPE);
                            if (customShapeDescription.isEmpty()) break;
                            return new CustomShape(customShapeDescription, elementAttributes.getLabel(), pt.getInputDescription(elementAttributes), pt.getOutputDescriptions(elementAttributes));
                        }
                    }
                    return new GenericShape(pt.getShortName(), pt.getInputDescription(elementAttributes), pt.getOutputDescriptions(elementAttributes), elementAttributes.getLabel(), true, customDescr.getAttributes().get(Keys.WIDTH)).setTopBottomBorder(14).setColor(customDescr.getAttributes().get(Keys.BACKGROUND_COLOR));
                }
                return new GenericShape(pt.getShortName(), pt.getInputDescription(elementAttributes), pt.getOutputDescriptions(elementAttributes), elementAttributes.getLabel(), true, elementAttributes.get(Keys.WIDTH)).setInverterConfig(elementAttributes.get(Keys.INVERTER_CONFIG));
            }
            ElementTypeDescription pt = this.library.getElementType(elementName);
            return cr.create(elementAttributes, pt.getInputDescription(elementAttributes), pt.getOutputDescriptions(elementAttributes));
        }
        catch (Exception e) {
            return new MissingShape(elementName, e);
        }
    }

    public static interface Creator {
        public Shape create(ElementAttributes var1, PinDescriptions var2, PinDescriptions var3) throws NodeException, PinException;
    }

    private static final class CreatorSimple
    implements Creator {
        private final String name;
        private final boolean invers;

        private CreatorSimple(String name, boolean invers) {
            this.name = name;
            this.invers = invers;
        }

        @Override
        public Shape create(ElementAttributes attributes, PinDescriptions inputs, PinDescriptions outputs) {
            return new GenericShape(this.name, inputs, outputs).invert(this.invers).setWide(attributes.get(Keys.WIDE_SHAPE)).setInverterConfig(attributes.get(Keys.INVERTER_CONFIG));
        }
    }

    private static final class ExternCreator
    implements Creator {
        private final ElementTypeDescription description;

        private ExternCreator(ElementTypeDescription description) {
            this.description = description;
        }

        @Override
        public Shape create(ElementAttributes attributes, PinDescriptions inputs, PinDescriptions outputs) throws NodeException, PinException {
            return new GenericShape(this.description.getShortName(), inputs, outputs, attributes.getLabel(), true, attributes.get(Keys.WIDTH)){

                @Override
                public String format(String s) {
                    return s.replace("_", "\\_");
                }
            };
        }
    }
}

