/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.draw.shapes;

import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.Keys;
import de.neemann.digital.core.element.PinDescriptions;
import de.neemann.digital.draw.elements.IOState;
import de.neemann.digital.draw.elements.Pins;
import de.neemann.digital.draw.graphics.Graphic;
import de.neemann.digital.draw.graphics.Orientation;
import de.neemann.digital.draw.graphics.Style;
import de.neemann.digital.draw.graphics.Vector;
import de.neemann.digital.draw.shapes.Interactor;
import de.neemann.digital.draw.shapes.Shape;
import de.neemann.digital.lang.Lang;

public class TextShape
implements Shape {
    private final String text;
    private final int fontSize;
    private final Orientation orientation;

    public TextShape(ElementAttributes attr, PinDescriptions inputs, PinDescriptions outputs) {
        String text = Lang.evalMultilingualContent(attr.get(Keys.DESCRIPTION));
        if (text.isEmpty()) {
            text = Lang.get("elem_Text", new Object[0]);
        }
        this.text = text;
        this.fontSize = attr.get(Keys.FONT_SIZE);
        this.orientation = attr.get(Keys.TEXT_ORIENTATION);
    }

    @Override
    public Pins getPins() {
        return new Pins();
    }

    @Override
    public Interactor applyStateMonitor(IOState ioState) {
        return null;
    }

    @Override
    public void drawTo(Graphic graphic, Style highLight) {
        StringBuilder sb = new StringBuilder();
        Style style = Style.NORMAL.deriveFontStyle(this.fontSize, true);
        Vector pos = new Vector(0, 0);
        int dy = style.getFontSize() * 20 / 16;
        int i = 0;
        while (i < this.text.length()) {
            char c = this.text.charAt(i);
            if (c == '\n') {
                if (sb.length() > 0) {
                    graphic.drawText(pos, sb.toString(), this.orientation, style);
                    sb.setLength(0);
                }
                pos = pos.add(0, dy);
            } else {
                sb.append(c);
            }
            ++i;
        }
        if (sb.length() > 0) {
            graphic.drawText(pos, sb.toString(), this.orientation, style);
        }
    }
}

