/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.draw.shapes.ieee;

import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.Keys;
import de.neemann.digital.core.element.PinDescription;
import de.neemann.digital.core.element.PinDescriptions;
import de.neemann.digital.draw.elements.IOState;
import de.neemann.digital.draw.elements.Pin;
import de.neemann.digital.draw.elements.Pins;
import de.neemann.digital.draw.graphics.Graphic;
import de.neemann.digital.draw.graphics.Polygon;
import de.neemann.digital.draw.graphics.Style;
import de.neemann.digital.draw.graphics.Vector;
import de.neemann.digital.draw.shapes.Interactor;
import de.neemann.digital.draw.shapes.Shape;

public class IEEENotShape
implements Shape {
    private final PinDescriptions inputs;
    private final PinDescriptions outputs;
    private final boolean wideShape;
    private Pins pins;

    public IEEENotShape(PinDescriptions inputs, PinDescriptions outputs, ElementAttributes attributes) {
        this.inputs = inputs;
        this.outputs = outputs;
        this.wideShape = attributes.get(Keys.WIDE_SHAPE);
    }

    @Override
    public Pins getPins() {
        if (this.pins == null) {
            this.pins = new Pins();
            this.pins.add(new Pin(new Vector(0, 0), (PinDescription)this.inputs.get(0)));
            int width = 40;
            if (this.wideShape) {
                width += 20;
            }
            this.pins.add(new Pin(new Vector(width, 0), (PinDescription)this.outputs.get(0)));
        }
        return this.pins;
    }

    @Override
    public Interactor applyStateMonitor(IOState ioState) {
        return null;
    }

    @Override
    public void drawTo(Graphic graphic, Style highLight) {
        if (this.wideShape) {
            graphic.drawPolygon(new Polygon(true).add(1, -22).add(39, 0).add(1, 22), Style.NORMAL);
            graphic.drawCircle(new Vector(41, -9), new Vector(59, 9), Style.NORMAL);
        } else {
            graphic.drawPolygon(new Polygon(true).add(1, -12).add(19, 0).add(1, 12), Style.NORMAL);
            graphic.drawCircle(new Vector(21, -9), new Vector(39, 9), Style.NORMAL);
        }
    }
}

