/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.fsm;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.xml.PrettyPrintWriter;
import de.neemann.digital.XStreamValid;
import de.neemann.digital.analyse.TruthTable;
import de.neemann.digital.analyse.expression.ExpressionException;
import de.neemann.digital.draw.graphics.Graphic;
import de.neemann.digital.draw.graphics.Vector;
import de.neemann.digital.draw.graphics.VectorFloat;
import de.neemann.digital.fsm.CircuitRepresentation;
import de.neemann.digital.fsm.FiniteStateMachineException;
import de.neemann.digital.fsm.MouseMovable;
import de.neemann.digital.fsm.Movable;
import de.neemann.digital.fsm.State;
import de.neemann.digital.fsm.Transition;
import de.neemann.digital.fsm.TransitionTableCreator;
import de.neemann.digital.lang.Lang;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

public class FSM {
    private ArrayList<State> states;
    private ArrayList<Transition> transitions;
    private transient boolean modified;
    private transient ModifiedListener modifiedListener;
    private transient int activeStateTransition = -1;
    private transient File file;
    private transient MovingState state = MovingState.STOP;
    private transient CircuitRepresentation circuitRepresentation;

    public static XStream getxStream() {
        XStreamValid xStream = new XStreamValid();
        xStream.alias("fsm", FSM.class);
        xStream.alias("state", State.class);
        xStream.alias("transition", Transition.class);
        xStream.alias("vector", Vector.class);
        xStream.aliasAttribute(Vector.class, "x", "x");
        xStream.aliasAttribute(Vector.class, "y", "y");
        xStream.alias("vectorf", VectorFloat.class);
        xStream.aliasAttribute(VectorFloat.class, "x", "x");
        xStream.aliasAttribute(VectorFloat.class, "y", "y");
        return xStream;
    }

    public static FSM loadFSM(File filename) throws IOException {
        FSM fsm = FSM.loadFSM(new FileInputStream(filename));
        fsm.file = filename;
        return fsm;
    }

    public static FSM loadFSM(InputStream in) throws IOException {
        try {
            XStream xStream = FSM.getxStream();
            FSM fsm = (FSM)xStream.fromXML(in);
            for (Transition t : fsm.transitions) {
                t.setFSM(fsm);
            }
            for (State s : fsm.states) {
                s.setFSM(fsm);
            }
            fsm.modified = false;
            fsm.activeStateTransition = -1;
            FSM fSM = fsm;
            return fSM;
        }
        catch (RuntimeException e) {
            throw new IOException(Lang.get("err_invalidFileFormat", new Object[0]), e);
        }
        finally {
            in.close();
        }
    }

    public void save(File filename) throws IOException {
        this.save(new FileOutputStream(filename));
        this.file = filename;
    }

    public void save(OutputStream out) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (OutputStreamWriter w = new OutputStreamWriter(out, StandardCharsets.UTF_8);){
            XStream xStream = FSM.getxStream();
            w.write("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n");
            xStream.marshal(this, new PrettyPrintWriter(w));
            this.modified = false;
            if (this.modifiedListener != null) {
                this.modifiedListener.modifiedChanged(this.modified);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public FSM(State ... state) {
        this.states = new ArrayList();
        this.transitions = new ArrayList();
        State[] stateArray = state;
        int n = state.length;
        int n2 = 0;
        while (n2 < n) {
            State s = stateArray[n2];
            this.add(s);
            ++n2;
        }
    }

    public FSM(FSM other) {
        this.states = new ArrayList();
        this.transitions = new ArrayList();
        for (State s : other.getStates()) {
            this.add(new State(s));
        }
        for (Transition t : other.getTransitions()) {
            this.add(new Transition(t, this.states, other.getStates()));
        }
    }

    public void setMovingState(MovingState state) {
        if (this.state != state) {
            this.state = state;
            if (state != MovingState.BOTH) {
                for (State s : this.states) {
                    s.toRaster();
                }
            }
        }
    }

    public MovingState getMovingState() {
        if (this.state == null) {
            this.state = MovingState.STOP;
        }
        return this.state;
    }

    public FSM add(State state) {
        if (state.getNumber() < 0) {
            state.setNumber(this.states.size());
        }
        if (this.states.isEmpty()) {
            state.setInitial(true);
        }
        state.setFSM(this);
        this.states.add(state);
        this.wasModified(state, Movable.Property.ADDED);
        return this;
    }

    public FSM add(Transition transition) {
        this.transitions.add(transition);
        transition.setFSM(this);
        this.wasModified(transition, Movable.Property.ADDED);
        return this;
    }

    public FSM transition(String from, String to, String condition) throws FiniteStateMachineException {
        return this.transition(this.findState(from), this.findState(to), condition);
    }

    public FSM transition(int from, int to, String condition) throws FiniteStateMachineException {
        return this.transition(this.findState(from), this.findState(to), condition);
    }

    public FSM transition(State from, State to, String condition) {
        if (!this.states.contains(from)) {
            this.add(from);
        }
        if (!this.states.contains(to)) {
            this.add(to);
        }
        return this.add(new Transition(from, to, condition));
    }

    private State findState(String name) throws FiniteStateMachineException {
        for (State s : this.states) {
            if (!s.getName().equals(name)) continue;
            return s;
        }
        throw new FiniteStateMachineException(Lang.get("err_fsmState_N_notFound", name));
    }

    private State findState(int number) throws FiniteStateMachineException {
        for (State s : this.states) {
            if (s.getNumber() != number) continue;
            return s;
        }
        throw new FiniteStateMachineException(Lang.get("err_fsmState_N_notFound", number));
    }

    public File getFile() {
        return this.file;
    }

    private void calculateForces() {
        for (State s : this.states) {
            s.calcExpansionForce(this.states);
        }
        for (Transition t : this.transitions) {
            t.calcForce(this.states, this.transitions);
        }
    }

    public List<State> getStates() {
        return this.states;
    }

    public void drawTo(Graphic gr) {
        for (State s : this.states) {
            s.drawTo(gr);
        }
        for (Transition t : this.transitions) {
            t.drawTo(gr);
        }
    }

    public void move(int dt, MouseMovable except) {
        if (this.state != MovingState.STOP) {
            this.calculateForces();
            if (this.state == MovingState.BOTH) {
                for (State s : this.states) {
                    if (s == except) continue;
                    s.move(dt);
                }
            }
            for (Transition t : this.transitions) {
                if (t == except) continue;
                t.move(dt);
            }
        }
    }

    public FSM circle() {
        double delta = Math.PI * 2 / (double)this.states.size();
        double circumference = 0.0;
        for (State s : this.states) {
            circumference += (double)(s.getVisualRadius() * 2);
        }
        double rad = (circumference += (double)(this.states.size() * 70 * 2)) / Math.PI / 2.0;
        double phi = 0.0;
        for (State s : this.states) {
            s.setPosition(new VectorFloat((float)(Math.sin(phi) * rad), (float)(-Math.cos(phi) * rad)));
            phi += delta;
        }
        for (Transition t : this.transitions) {
            t.initPos();
        }
        return this;
    }

    public TruthTable createTruthTable(String stateSignalName) throws ExpressionException, FiniteStateMachineException {
        return new TransitionTableCreator(this, stateSignalName).create();
    }

    public int getInitState() throws FiniteStateMachineException {
        for (State s : this.states) {
            if (!s.isInitial()) continue;
            return s.getNumber();
        }
        throw new FiniteStateMachineException(Lang.get("err_fsmNoInitialState", new Object[0]));
    }

    public void clearInitial() {
        for (State s : this.states) {
            s.setInitial(false);
        }
    }

    public MouseMovable getMovable(Vector pos) {
        float d;
        for (State s : this.states) {
            if (!s.matchesInitial(pos)) continue;
            return s.getInitialMarkerMovable();
        }
        Movable found = null;
        float dist = Float.MAX_VALUE;
        for (Transition t : this.transitions) {
            if (!t.matches(pos) || !((d = pos.sub(t.getPos()).len()) < dist)) continue;
            dist = d;
            found = t;
        }
        if (found != null) {
            return found;
        }
        dist = Float.MAX_VALUE;
        for (State s : this.states) {
            if (!s.matches(pos) || !((d = pos.sub(s.getPos()).len()) < dist)) continue;
            dist = d;
            found = s;
        }
        return found;
    }

    public List<Transition> getTransitions() {
        return this.transitions;
    }

    public void remove(Transition transition) {
        this.transitions.remove(transition);
        this.wasModified(transition, Movable.Property.REMOVED);
    }

    public void remove(State state) {
        this.states.remove(state);
        this.transitions.removeIf(t -> t.getStartState() == state || t.getTargetState() == state);
        this.wasModified(state, Movable.Property.REMOVED);
    }

    void wasModified(Movable<?> movable, Movable.Property prop) {
        this.modified = true;
        if (movable instanceof State) {
            State st = (State)movable;
            if (prop == Movable.Property.POS && this.getMovingState() != MovingState.BOTH) {
                st.toRaster();
            }
            if ((prop == Movable.Property.POS || prop == Movable.Property.MOUSEPOS) && this.getMovingState() == MovingState.STOP) {
                for (Transition t : this.transitions) {
                    if (t.getTargetState() != st && t.getStartState() != st) continue;
                    t.setPos(t.getPos());
                }
            }
        }
        if (this.modifiedListener != null) {
            this.modifiedListener.modifiedChanged(this.modified);
        }
    }

    public void setModifiedListener(ModifiedListener modifiedListener) {
        this.modifiedListener = modifiedListener;
    }

    public boolean isModified() {
        return this.modified;
    }

    public FSM setModified(boolean modified) {
        if (this.modifiedListener != null) {
            throw new RuntimeException("call not allowed");
        }
        this.modified = modified;
        return this;
    }

    public void setCircuitRepresentation(CircuitRepresentation circuitRepresentation) {
        this.circuitRepresentation = circuitRepresentation;
    }

    public boolean setActiveStateTransition(int value) {
        if (this.activeStateTransition != value) {
            this.activeStateTransition = value;
            return true;
        }
        return false;
    }

    State getActiveState() {
        if (this.circuitRepresentation != null) {
            return this.circuitRepresentation.getActiveState(this.activeStateTransition);
        }
        return null;
    }

    Transition getActiveTransition() {
        if (this.circuitRepresentation != null) {
            return this.circuitRepresentation.getActiveTransition(this.activeStateTransition);
        }
        return null;
    }

    public static interface ModifiedListener {
        public void modifiedChanged(boolean var1);
    }

    public static enum MovingState {
        STOP,
        TRANSITIONS,
        BOTH;

    }
}

