/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.fsm;

import de.neemann.digital.analyse.MinimizerQuineMcCluskey;
import de.neemann.digital.analyse.TruthTable;
import de.neemann.digital.analyse.expression.Expression;
import de.neemann.digital.analyse.expression.ExpressionException;
import de.neemann.digital.analyse.expression.ExpressionVisitor;
import de.neemann.digital.analyse.expression.Operation;
import de.neemann.digital.analyse.expression.format.FormatterException;
import de.neemann.digital.core.Bits;
import de.neemann.digital.fsm.FSM;
import de.neemann.digital.fsm.FiniteStateMachineException;
import de.neemann.digital.fsm.Permute;
import de.neemann.digital.fsm.State;
import de.neemann.digital.fsm.WaitGroup;
import de.neemann.digital.gui.components.table.ExpressionListener;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Optimizer {
    private static final Logger LOGGER = LoggerFactory.getLogger(Optimizer.class);
    private static final long[] FAC_TABLE = new long[]{1L, 1L, 2L, 6L, 24L, 120L, 720L, 5040L, 40320L, 362880L, 3628800L, 39916800L, 479001600L, 6227020800L, 87178291200L, 1307674368000L, 20922789888000L, 355687428096000L, 6402373705728000L, 121645100408832000L, 2432902008176640000L};
    private final FSM fsm;
    private final int initialComplexity;
    private int bestComplexity;
    private int[] best;
    private Permute.PermPull pp;

    public static long fac(int n) {
        if (n > 20) {
            return Long.MAX_VALUE;
        }
        return FAC_TABLE[n];
    }

    public Optimizer(FSM fsm) throws FiniteStateMachineException, FormatterException, ExpressionException {
        this.fsm = fsm;
        this.bestComplexity = this.initialComplexity = Optimizer.calcComplexity(fsm, false);
    }

    public Optimizer optimizeFSM() throws FiniteStateMachineException, FormatterException, ExpressionException, Permute.PermListenerException {
        LOGGER.info("optimizing time complexity: " + Optimizer.getTimeComplexity(this.fsm));
        this.bestComplexity = Optimizer.calcComplexity(this.fsm, false);
        LOGGER.info("start complexity " + this.bestComplexity);
        List<State> states = this.fsm.getStates();
        int size = states.size();
        int sizeInclDC = 1 << Bits.binLn2(size - 1);
        Permute.permute(size, sizeInclDC, perm -> {
            int c;
            int i = 0;
            while (i < states.size()) {
                ((State)states.get(i)).setNumber(perm[i]);
                ++i;
            }
            try {
                c = Optimizer.calcComplexity(this.fsm, false);
            }
            catch (ExpressionException | FormatterException | FiniteStateMachineException e) {
                throw new Permute.PermListenerException(e);
            }
            if (c < this.bestComplexity) {
                this.bestComplexity = c;
                this.best = Arrays.copyOf(perm, size);
            }
        });
        return this;
    }

    public static long getTimeComplexity(FSM fsm) {
        List<State> states = fsm.getStates();
        int size = states.size();
        int sizeInclDC = 1 << Bits.binLn2(size - 1);
        if (sizeInclDC > 20) {
            return Long.MAX_VALUE;
        }
        return Optimizer.fac(sizeInclDC) / Optimizer.fac(sizeInclDC - size);
    }

    public Optimizer optimizeFSMParallel(EventListener el) throws FiniteStateMachineException, FormatterException, ExpressionException {
        LOGGER.info("optimizing time complexity: " + Optimizer.getTimeComplexity(this.fsm));
        this.bestComplexity = Optimizer.calcComplexity(this.fsm, false);
        LOGGER.info("start complexity " + this.bestComplexity);
        List<State> states = this.fsm.getStates();
        int size = states.size();
        int sizeInclDC = 1 << Bits.binLn2(size - 1);
        this.pp = new Permute.PermPull(size, sizeInclDC);
        Object lock = new Object();
        BestListener l = (b, bcplx) -> {
            Object object2 = lock;
            synchronized (object2) {
                if (bcplx < this.bestComplexity) {
                    this.bestComplexity = bcplx;
                    this.best = b;
                    if (el != null) {
                        el.bestSoFar(this.best, this.bestComplexity);
                    }
                }
            }
        };
        WaitGroup wg = new WaitGroup(() -> {
            if (el != null) {
                el.finished();
            }
        });
        int i = 0;
        while (i < Runtime.getRuntime().availableProcessors()) {
            wg.add();
            new ThreadRunner(wg, new FSM(this.fsm), this.pp, l).start();
            ++i;
        }
        return this;
    }

    public Optimizer waitFor() {
        if (this.pp != null) {
            this.pp.waitFor();
        }
        return this;
    }

    public void stop() {
        if (this.pp != null) {
            this.pp.stop();
        }
    }

    public Optimizer applyBest() {
        if (this.best != null) {
            List<State> states = this.fsm.getStates();
            int i = 0;
            while (i < states.size()) {
                states.get(i).setNumber(this.best[i]);
                ++i;
            }
        }
        return this;
    }

    public int getBestComplexity() {
        return this.bestComplexity;
    }

    static int calcComplexity(FSM fsm, boolean out) throws ExpressionException, FiniteStateMachineException, FormatterException {
        TruthTable tt = fsm.createTruthTable(null);
        MinimizerQuineMcCluskey mi = new MinimizerQuineMcCluskey();
        ComplexityListener listener = new ComplexityListener(out);
        int i = 0;
        while (i < tt.getResultCount()) {
            mi.minimize(tt.getVars(), tt.getResult(i), tt.getResultName(i), listener);
            ++i;
        }
        return listener.complexity;
    }

    public int getInitialComplexity() {
        return this.initialComplexity;
    }

    private static interface BestListener {
        public void bestSoFar(int[] var1, int var2);
    }

    private static final class ComplexityListener
    implements ExpressionListener {
        private final boolean out;
        private int complexity;

        private ComplexityListener(boolean out) {
            this.out = out;
        }

        @Override
        public void resultFound(String name, Expression expression) {
            int complexity = expression.traverse(new ComplexityVisitorL()).getComplexity();
            if (this.out) {
                System.out.println("   " + name + "=" + expression + "; " + complexity);
            }
            this.complexity += complexity;
        }

        @Override
        public void close() {
        }

        private static class ComplexityVisitorL
        implements ExpressionVisitor {
            private int complexity;

            private ComplexityVisitorL() {
            }

            @Override
            public boolean visit(Expression expression) {
                if (expression instanceof Operation) {
                    this.complexity += ((Operation)expression).getExpressions().size();
                }
                return true;
            }

            public int getComplexity() {
                return this.complexity;
            }
        }
    }

    public static interface EventListener
    extends BestListener {
        public void finished();
    }

    private static final class ThreadRunner
    extends Thread {
        private final WaitGroup wg;
        private final FSM fsm;
        private final Permute.PermPull pp;
        private final BestListener l;

        private ThreadRunner(WaitGroup wg, FSM fsm, Permute.PermPull pp, BestListener l) {
            this.wg = wg;
            this.fsm = fsm;
            this.pp = pp;
            this.l = l;
        }

        @Override
        public void run() {
            try {
                int[] p;
                int bestComplexity = Integer.MAX_VALUE;
                List<State> states = this.fsm.getStates();
                int size = states.size();
                while ((p = this.pp.next()) != null) {
                    int i = 0;
                    while (i < size) {
                        states.get(i).setNumber(p[i]);
                        ++i;
                    }
                    try {
                        int c = Optimizer.calcComplexity(this.fsm, false);
                        if (c >= bestComplexity) continue;
                        bestComplexity = c;
                        this.l.bestSoFar(Arrays.copyOf(p, size), bestComplexity);
                    }
                    catch (ExpressionException | FormatterException | FiniteStateMachineException exception) {
                        // empty catch block
                    }
                }
            }
            finally {
                this.wg.done();
            }
        }
    }
}

