/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.fsm.gui;

import de.neemann.digital.analyse.expression.ExpressionException;
import de.neemann.digital.analyse.expression.format.FormatterException;
import de.neemann.digital.fsm.FiniteStateMachineException;
import de.neemann.digital.fsm.Optimizer;
import de.neemann.digital.fsm.gui.FSMFrame;
import de.neemann.digital.lang.Lang;
import de.neemann.gui.ToolTipAction;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class OptimizerDialog
extends JDialog {
    private final Optimizer optimizer;
    private final JLabel bestLabel;

    public OptimizerDialog(FSMFrame owner) throws FiniteStateMachineException, FormatterException, ExpressionException {
        super(owner, Lang.get("msg_fsm_optimizer", new Object[0]), true);
        this.setDefaultCloseOperation(0);
        this.optimizer = new Optimizer(owner.getFSM()).optimizeFSMParallel(new SwingListener());
        GridLayout layout = new GridLayout(2, 2);
        JPanel panel = new JPanel(layout);
        panel.add(this.addBorder(new JLabel(Lang.get("msg_fsm_optimizer_initial", new Object[0]))));
        panel.add(this.addBorder(new JLabel(Integer.toString(this.optimizer.getInitialComplexity()))));
        panel.add(this.addBorder(new JLabel(Lang.get("msg_fsm_optimizer_best", new Object[0]))));
        this.bestLabel = new JLabel(Integer.toString(this.optimizer.getInitialComplexity()));
        panel.add(this.addBorder(this.bestLabel));
        this.getContentPane().add((Component)panel, "Center");
        JPanel buttons = new JPanel();
        buttons.add((Component)new ToolTipAction(Lang.get("cancel", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OptimizerDialog.this.optimizer.stop();
                this.setEnabled(false);
            }
        }.createJButton(), "South");
        this.getContentPane().add(this.addBorder(buttons), "South");
        this.pack();
        this.setLocationRelativeTo(owner);
    }

    private Component addBorder(JComponent component) {
        component.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        return component;
    }

    private final class SwingListener
    implements Optimizer.EventListener {
        private SwingListener() {
        }

        @Override
        public void bestSoFar(int[] best, int bestComplexity) {
            SwingUtilities.invokeLater(() -> OptimizerDialog.this.bestLabel.setText(Integer.toString(bestComplexity)));
        }

        @Override
        public void finished() {
            SwingUtilities.invokeLater(() -> {
                OptimizerDialog.this.optimizer.applyBest();
                OptimizerDialog.this.dispose();
            });
        }
    }
}

