/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.gui;

import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.ElementTypeDescription;
import de.neemann.digital.core.element.Key;
import de.neemann.digital.core.element.Keys;
import de.neemann.digital.draw.elements.Circuit;
import de.neemann.digital.draw.elements.VisualElement;
import de.neemann.digital.draw.library.ElementLibrary;
import de.neemann.digital.draw.library.ElementNotFoundException;
import de.neemann.digital.draw.library.ElementTypeDescriptionCustom;
import de.neemann.digital.gui.Main;
import de.neemann.digital.gui.SaveAsHelper;
import de.neemann.digital.lang.Lang;
import de.neemann.gui.ToolTipAction;
import java.awt.event.ActionEvent;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileNameExtensionFilter;

public class ExportZipAction
extends ToolTipAction {
    private final Main main;
    private final ArrayList<Key<File>> fileKeyList;
    private ElementLibrary lib;
    private HashSet<String> elementSet;
    private HashSet<File> addedFiles;
    private File origin;

    public ExportZipAction(Main main) {
        super(Lang.get("menu_exportZIP", new Object[0]));
        this.main = main;
        this.setToolTip(Lang.get("menu_exportZIP_tt", new Object[0]));
        this.fileKeyList = new ArrayList();
        for (Key k : Keys.getKeys()) {
            if (!(k instanceof Key.KeyFile)) continue;
            this.fileKeyList.add((Key.KeyFile)k);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JFileChooser fc = new JFileChooser(this.main.getBaseFileName());
        fc.setFileFilter(new FileNameExtensionFilter("ZIP", "zip"));
        new SaveAsHelper(this.main, fc, "zip").checkOverwrite(file -> {
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (ZipOutputStream zip = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(file)));){
                    Circuit circuit = this.main.getCircuitComponent().getCircuit();
                    this.lib = this.main.getCircuitComponent().getLibrary();
                    this.origin = circuit.getOrigin();
                    this.elementSet = new HashSet();
                    this.addedFiles = new HashSet();
                    this.addCircuitFile(zip, this.origin, circuit);
                    this.addFilesInAttributes(zip, circuit.getAttributes());
                    if (this.origin != null) {
                        this.addToZip(zip, "MANIFEST.TXT", "Main-Circuit: " + this.origin.getName() + "\n");
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (ElementNotFoundException e1) {
                throw new IOException(Lang.get("err_errorExportingZip", new Object[0]), e1);
            }
        });
    }

    private void addCircuitFile(ZipOutputStream zip, File file, Circuit circuit) throws ElementNotFoundException, IOException {
        this.addToZip(zip, file);
        for (VisualElement ve : circuit.getElements()) {
            String name = ve.getElementName();
            if (this.elementSet.contains(name)) continue;
            this.elementSet.add(name);
            ElementTypeDescription desc = this.lib.getElementType(name);
            if (desc instanceof ElementTypeDescriptionCustom) {
                ElementTypeDescriptionCustom custom = (ElementTypeDescriptionCustom)desc;
                this.addCircuitFile(zip, custom.getFile(), custom.getCircuit());
            }
            this.addFilesInAttributes(zip, ve.getElementAttributes());
        }
    }

    private void addFilesInAttributes(ZipOutputStream zip, ElementAttributes attr) throws IOException {
        for (Key<File> k : this.fileKeyList) {
            if (!attr.contains(k)) continue;
            File f = attr.getFile(k, this.origin);
            this.addToZip(zip, f);
        }
    }

    private void addToZip(ZipOutputStream zip, File file) throws IOException {
        if (file != null && !this.addedFiles.contains(file)) {
            zip.putNextEntry(new ZipEntry(file.getName()));
            Throwable throwable = null;
            Object var4_5 = null;
            try (FileInputStream in = new FileInputStream(file);){
                int len;
                byte[] buffer = new byte[4096];
                while ((len = ((InputStream)in).read(buffer)) > 0) {
                    zip.write(buffer, 0, len);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            this.addedFiles.add(file);
        }
    }

    private void addToZip(ZipOutputStream zip, String name, String content) throws IOException {
        zip.putNextEntry(new ZipEntry(name));
        zip.write(content.getBytes(StandardCharsets.UTF_8));
    }
}

