/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.gui;

import de.neemann.digital.draw.library.ElementLibrary;
import de.neemann.digital.draw.library.LibraryListener;
import de.neemann.digital.draw.library.LibraryNode;
import de.neemann.digital.gui.InsertAction;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JToolBar;

public class InsertHistory
implements LibraryListener {
    private static final int MAX_ICONS = 6;
    private final JToolBar bar;
    private final ElementLibrary library;
    private final ArrayList<WrapperAction> wrappers;
    private int mainTime;
    private InsertAction lastInsertAction;

    public InsertHistory(JToolBar bar, ElementLibrary library) {
        this.bar = bar;
        this.library = library;
        this.wrappers = new ArrayList();
    }

    public void add(InsertAction action) {
        this.lastInsertAction = action;
        if (!this.contains(action)) {
            WrapperAction wrapper = new WrapperAction(action, this.bar.getComponentCount());
            this.wrappers.add(wrapper);
            this.bar.add(wrapper).setToolTipText(action.getNode().getToolTipText());
            if (this.wrappers.size() > 6) {
                int oldest = this.findOldestIndex();
                this.removeWrapperFromToolBar(this.wrappers.get(oldest));
                this.wrappers.remove(oldest);
            }
        }
    }

    private void removeWrapperFromToolBar(WrapperAction wrapper) {
        int position = wrapper.componentPosition;
        this.bar.remove(position);
        for (WrapperAction w : this.wrappers) {
            if (w.componentPosition <= position) continue;
            WrapperAction wrapperAction = w;
            wrapperAction.componentPosition = wrapperAction.componentPosition - 1;
        }
    }

    private int findOldestIndex() {
        int found = -1;
        int oldestTime = this.mainTime;
        int i = 0;
        while (i < this.wrappers.size()) {
            WrapperAction wrapper = this.wrappers.get(i);
            if (wrapper.time < oldestTime) {
                found = i;
                oldestTime = wrapper.time;
            }
            ++i;
        }
        return found;
    }

    private boolean contains(InsertAction action) {
        for (WrapperAction wrapper : this.wrappers) {
            if (!wrapper.action.getName().equals(action.getName())) continue;
            return true;
        }
        return false;
    }

    public InsertAction getLastInsertAction() {
        return this.lastInsertAction;
    }

    @Override
    public void libraryChanged(LibraryNode node) {
        this.updateCustomComponents();
    }

    private void updateCustomComponents() {
        Iterator<WrapperAction> it = this.wrappers.iterator();
        while (it.hasNext()) {
            WrapperAction w = it.next();
            if (!w.action.isCustom()) continue;
            LibraryNode n = this.library.getElementNodeOrNull(w.action.getName());
            if (n == null) {
                this.removeWrapperFromToolBar(w);
                it.remove();
                continue;
            }
            w.update(n);
        }
        this.bar.revalidate();
    }

    private final class WrapperAction
    extends AbstractAction {
        private final InsertAction action;
        private int componentPosition;
        private int time;

        private WrapperAction(InsertAction action, int componentPosition) {
            super(action.getValue("Name").toString(), (Icon)action.getValue("SmallIcon"));
            this.action = action;
            this.componentPosition = componentPosition;
            InsertHistory insertHistory2 = InsertHistory.this;
            int n = insertHistory2.mainTime;
            insertHistory2.mainTime = n + 1;
            this.time = n;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.action.actionPerformed(e);
            InsertHistory insertHistory = InsertHistory.this;
            int n = insertHistory.mainTime;
            insertHistory.mainTime = n + 1;
            this.time = n;
        }

        public void update(LibraryNode n) {
            this.action.update(n);
            this.putValue("SmallIcon", this.action.getValue("SmallIcon"));
        }
    }
}

