/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.gui;

import de.neemann.digital.draw.library.ElementLibrary;
import de.neemann.digital.draw.library.LibraryListener;
import de.neemann.digital.draw.library.LibraryNode;
import de.neemann.digital.draw.shapes.ShapeFactory;
import de.neemann.digital.gui.InsertAction;
import de.neemann.digital.gui.InsertHistory;
import de.neemann.digital.gui.components.CircuitComponent;
import de.neemann.digital.lang.Lang;
import de.neemann.gui.ErrorMessage;
import de.neemann.gui.ToolTipAction;
import java.awt.event.ActionEvent;
import java.io.IOException;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;

public class LibrarySelector
implements LibraryListener {
    private final ElementLibrary library;
    private final ShapeFactory shapeFactory;
    private JMenu componentsMenu;
    private InsertHistory insertHistory;
    private CircuitComponent circuitComponent;

    public LibrarySelector(ElementLibrary library, ShapeFactory shapeFactory) {
        this.library = library;
        this.shapeFactory = shapeFactory;
    }

    public JMenu buildMenu(InsertHistory insertHistory, CircuitComponent circuitComponent) {
        this.insertHistory = insertHistory;
        this.circuitComponent = circuitComponent;
        this.componentsMenu = new JMenu(Lang.get("menu_elements", new Object[0]));
        this.libraryChanged(null);
        return this.componentsMenu;
    }

    @Override
    public void libraryChanged(LibraryNode node) {
        JMenuItem m;
        this.componentsMenu.removeAll();
        for (LibraryNode n : this.library.getRoot()) {
            this.addComponents(this.componentsMenu, n);
        }
        if (this.library.getCustomNode() != null && (m = this.componentsMenu.getItem(this.componentsMenu.getItemCount() - 1)) instanceof JMenu) {
            JMenu menu = (JMenu)m;
            menu.addSeparator();
            menu.add(new ToolTipAction(Lang.get("menu_update", new Object[0])){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        LibrarySelector.this.library.updateEntries();
                    }
                    catch (IOException ex) {
                        SwingUtilities.invokeLater(new ErrorMessage(Lang.get("msg_errorUpdatingLibrary", new Object[0])).addCause(ex));
                    }
                }
            }.setToolTip(Lang.get("menu_update_tt", new Object[0])).createJMenuItem());
        }
    }

    private void addComponents(JMenu parts, LibraryNode node) {
        if (node.isLeaf()) {
            if (!node.isHidden()) {
                parts.add(new InsertAction(node, this.insertHistory, this.circuitComponent, this.shapeFactory).createJMenuItem());
            }
        } else {
            JMenu subMenu = new JMenu(node.getName());
            for (LibraryNode child : node) {
                this.addComponents(subMenu, child);
            }
            parts.add(subMenu);
        }
    }
}

