/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.gui.components;

import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.Key;
import de.neemann.digital.draw.elements.VisualElement;
import de.neemann.digital.gui.Main;
import de.neemann.digital.gui.components.ConstraintsBuilder;
import de.neemann.digital.gui.components.Editor;
import de.neemann.digital.gui.components.EditorFactory;
import de.neemann.digital.gui.components.EditorPanel;
import de.neemann.digital.lang.Lang;
import de.neemann.gui.ErrorMessage;
import de.neemann.gui.Screen;
import de.neemann.gui.ToolTipAction;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class AttributeDialog
extends JDialog {
    private final List<EditorHolder> editors;
    private final Window parent;
    private final Point pos;
    private final ElementAttributes originalAttributes;
    private final ElementAttributes modifiedAttributes;
    private final JPanel buttonPanel;
    private final AbstractAction okAction;
    private final EditorPanel primaryPanel;
    private HashMap<Key, JCheckBox> checkBoxes;
    private JComponent topMostTextComponent;
    private VisualElement visualElement;
    private boolean okPressed = false;

    public AttributeDialog(Window parent, List<Key> list, ElementAttributes elementAttributes) {
        this(parent, null, list, elementAttributes, false);
    }

    public AttributeDialog(Window parent, Point pos, List<Key> list, ElementAttributes elementAttributes) {
        this(parent, pos, list, elementAttributes, false);
    }

    public AttributeDialog(Window parent, Point pos, ElementAttributes elementAttributes, Key ... keys) {
        this(parent, pos, Arrays.asList(keys), elementAttributes, false);
    }

    public AttributeDialog(Window parent, Point pos, List<Key> list, ElementAttributes elementAttributes, boolean addCheckBoxes) {
        super(parent, Lang.get("attr_dialogTitle", new Object[0]), Dialog.ModalityType.APPLICATION_MODAL);
        this.setDefaultCloseOperation(0);
        this.parent = parent;
        this.pos = pos;
        this.originalAttributes = elementAttributes;
        this.modifiedAttributes = new ElementAttributes(elementAttributes);
        ArrayList<EditorPanel> panels = new ArrayList<EditorPanel>();
        this.primaryPanel = new EditorPanel("primary");
        panels.add(this.primaryPanel);
        this.editors = new ArrayList<EditorHolder>();
        this.topMostTextComponent = null;
        EditorPanel secondaryPanel = null;
        if (!addCheckBoxes && this.enableTwoTabs(list)) {
            secondaryPanel = new EditorPanel("secondary");
            panels.add(secondaryPanel);
        }
        for (Key key : list) {
            Key dependsOn;
            Editor e = EditorFactory.INSTANCE.create(key, this.modifiedAttributes.get(key));
            this.editors.add(new EditorHolder(e, key));
            EditorPanel panelToUse = this.primaryPanel;
            if (key.isSecondary() && secondaryPanel != null) {
                panelToUse = secondaryPanel;
            }
            if (key.getPanelId() != null) {
                panelToUse = this.findPanel(panels, key.getPanelId());
            }
            e.addToPanel(panelToUse, key, this.modifiedAttributes, this);
            if (addCheckBoxes) {
                if (this.checkBoxes == null) {
                    this.checkBoxes = new HashMap();
                }
                JCheckBox checkBox = new JCheckBox();
                checkBox.setSelected(true);
                checkBox.setToolTipText(Lang.get("msg_modifyThisAttribute", new Object[0]));
                this.checkBoxes.put(key, checkBox);
                panelToUse.add(checkBox, (ConstraintsBuilder cb) -> cb.x(2));
                checkBox.addChangeListener(event -> e.setEnabled(checkBox.isSelected()));
            }
            panelToUse.nextRow();
            if (this.topMostTextComponent == null && e instanceof EditorFactory.StringEditor) {
                this.topMostTextComponent = ((EditorFactory.StringEditor)e).getTextComponent();
            }
            if ((dependsOn = key.getDependsOn()) == null || addCheckBoxes) continue;
            for (EditorHolder ed : this.editors) {
                if (!ed.key.getKey().equals(dependsOn.getKey())) continue;
                ed.setDependantEditor(e, key.getCheckEnabled());
            }
        }
        if (panels.size() == 1) {
            this.getContentPane().add(this.primaryPanel.getScrollPane());
        } else {
            JTabbedPane tp = new JTabbedPane(1);
            for (EditorPanel ep : panels) {
                tp.addTab(Lang.get(ep.getLangKey(), new Object[0]), ep.getScrollPane());
            }
            this.getContentPane().add(tp);
        }
        this.okAction = new AbstractAction(Lang.get("ok", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    AttributeDialog.this.fireOk();
                }
                catch (Editor.EditorParseException err) {
                    new ErrorMessage(Lang.get("msg_errorEditingValue", new Object[0])).addCause(err).show(AttributeDialog.this);
                }
            }
        };
        JButton okButton = new JButton(this.okAction);
        AbstractAction cancel = new AbstractAction(Lang.get("cancel", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent e) {
                AttributeDialog.this.tryDispose();
            }
        };
        this.buttonPanel = new JPanel(new FlowLayout(2));
        this.buttonPanel.add(new JButton(cancel));
        this.buttonPanel.add(okButton);
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                AttributeDialog.this.tryDispose();
            }
        });
        this.getRootPane().setDefaultButton(okButton);
        this.getRootPane().registerKeyboardAction(cancel, KeyStroke.getKeyStroke(27, 0), 2);
    }

    private void tryDispose() {
        EditorHolder majorModification = null;
        for (EditorHolder eh : this.editors) {
            if (!eh.e.invisibleModification()) continue;
            majorModification = eh;
        }
        if (majorModification == null) {
            this.dispose();
        } else {
            int r = JOptionPane.showOptionDialog(this, Lang.get("msg_dataWillBeLost_n", majorModification.key.getName()), Lang.get("msg_warning", new Object[0]), 0, 2, null, new String[]{Lang.get("btn_discard", new Object[0]), Lang.get("btn_editFurther", new Object[0])}, Lang.get("cancel", new Object[0]));
            if (r == 0) {
                this.dispose();
            }
        }
    }

    private EditorPanel findPanel(ArrayList<EditorPanel> panels, String panelId) {
        EditorPanel p2;
        for (EditorPanel p2 : panels) {
            if (!panelId.equals(p2.getPanelId())) continue;
            return p2;
        }
        p2 = new EditorPanel(panelId);
        panels.add(p2);
        return p2;
    }

    public AttributeDialog setDialogTitle(String title) {
        this.setTitle(title);
        return this;
    }

    private boolean enableTwoTabs(List<Key> list) {
        int secCount = 0;
        int primCount = 0;
        for (Key k : list) {
            if (k.isSecondary()) {
                ++secCount;
                continue;
            }
            ++primCount;
        }
        return primCount > 1 && secCount > 1;
    }

    public void fireOk() throws Editor.EditorParseException {
        this.storeEditedValues();
        this.okPressed = true;
        this.dispose();
    }

    HashMap<Key, JCheckBox> getCheckBoxes() {
        return this.checkBoxes;
    }

    AttributeDialog addButton(String label, ToolTipAction action) {
        this.primaryPanel.addButton(label, action);
        return this;
    }

    AttributeDialog addButton(ToolTipAction action) {
        this.buttonPanel.add((Component)action.createJButton(), 0);
        return this;
    }

    void storeEditedValues() throws Editor.EditorParseException {
        for (EditorHolder e : this.editors) {
            e.setTo(this.modifiedAttributes);
        }
    }

    void updateEditedValues() throws Editor.EditorParseException {
        for (EditorHolder e : this.editors) {
            e.getFrom(this.modifiedAttributes);
        }
    }

    ElementAttributes getModifiedAttributes() {
        return this.modifiedAttributes;
    }

    public ElementAttributes showDialog() {
        this.pack();
        if (this.pos == null) {
            this.setLocationRelativeTo(this.parent);
        } else {
            Screen.setLocation(this, this.pos, true);
        }
        if (this.topMostTextComponent != null) {
            SwingUtilities.invokeLater(() -> {
                boolean bl = this.topMostTextComponent.requestFocusInWindow();
            });
        }
        this.setVisible(true);
        if (this.okPressed && !this.originalAttributes.equals(this.modifiedAttributes)) {
            return this.modifiedAttributes;
        }
        return null;
    }

    Window getDialogParent() {
        return this.parent;
    }

    public boolean isOkPressed() {
        return this.okPressed;
    }

    public Main getMain() {
        if (this.parent instanceof Main) {
            return (Main)this.parent;
        }
        return null;
    }

    public File getRootFile() {
        File root = null;
        Main main = this.getMain();
        if (main != null) {
            root = main.getLibrary().getRootFilePath();
        }
        return root;
    }

    public VisualElement getVisualElement() {
        return this.visualElement;
    }

    public AttributeDialog setVisualElement(VisualElement visualElement) {
        this.visualElement = visualElement;
        return this;
    }

    public void disableOk() {
        this.okAction.setEnabled(false);
        this.okPressed = false;
    }

    private static final class EditorHolder<T> {
        private final Editor<T> e;
        private final Key<T> key;

        private EditorHolder(Editor<T> e, Key<T> key) {
            this.e = e;
            this.key = key;
        }

        public void setTo(ElementAttributes attr) throws Editor.EditorParseException {
            T value = this.e.getValue();
            attr.set(this.key, value);
        }

        void getFrom(ElementAttributes attr) {
            T value = attr.get(this.key);
            this.e.setValue(value);
        }

        void setDependantEditor(Editor editor, Key.CheckEnabled<T> checkEnabled) {
            try {
                editor.setEnabled(checkEnabled.isEnabled(this.e.getValue()));
            }
            catch (Editor.EditorParseException e1) {
                e1.printStackTrace();
            }
            this.e.addActionListener(actionEvent -> {
                try {
                    editor.setEnabled(checkEnabled.isEnabled(this.e.getValue()));
                }
                catch (Editor.EditorParseException e1) {
                    e1.printStackTrace();
                }
            });
        }
    }
}

