/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.gui.components;

import de.neemann.digital.core.Bits;
import de.neemann.digital.core.NodeException;
import de.neemann.digital.core.ObservableValue;
import de.neemann.digital.core.SyncAccess;
import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.ElementTypeDescription;
import de.neemann.digital.core.element.ImmutableList;
import de.neemann.digital.core.element.Key;
import de.neemann.digital.core.element.Keys;
import de.neemann.digital.core.element.PinDescription;
import de.neemann.digital.core.element.PinInfo;
import de.neemann.digital.core.io.Const;
import de.neemann.digital.core.io.In;
import de.neemann.digital.core.io.InValue;
import de.neemann.digital.core.io.Out;
import de.neemann.digital.core.switching.Switch;
import de.neemann.digital.core.wiring.Clock;
import de.neemann.digital.draw.elements.Circuit;
import de.neemann.digital.draw.elements.Movable;
import de.neemann.digital.draw.elements.Pin;
import de.neemann.digital.draw.elements.PinException;
import de.neemann.digital.draw.elements.Tunnel;
import de.neemann.digital.draw.elements.VisualElement;
import de.neemann.digital.draw.elements.Wire;
import de.neemann.digital.draw.graphics.ColorKey;
import de.neemann.digital.draw.graphics.ColorScheme;
import de.neemann.digital.draw.graphics.Graphic;
import de.neemann.digital.draw.graphics.GraphicMinMax;
import de.neemann.digital.draw.graphics.GraphicSwing;
import de.neemann.digital.draw.graphics.Polygon;
import de.neemann.digital.draw.graphics.Style;
import de.neemann.digital.draw.graphics.TransformRotate;
import de.neemann.digital.draw.graphics.Vector;
import de.neemann.digital.draw.graphics.VectorFloat;
import de.neemann.digital.draw.library.ElementLibrary;
import de.neemann.digital.draw.library.ElementNotFoundException;
import de.neemann.digital.draw.library.ElementTypeDescriptionCustom;
import de.neemann.digital.draw.library.GenericCode;
import de.neemann.digital.draw.library.GenericInitCode;
import de.neemann.digital.draw.library.LibraryListener;
import de.neemann.digital.draw.library.LibraryNode;
import de.neemann.digital.draw.library.ResolveGenerics;
import de.neemann.digital.draw.model.Net;
import de.neemann.digital.draw.model.NetList;
import de.neemann.digital.draw.shapes.CustomCircuitShapeType;
import de.neemann.digital.draw.shapes.Drawable;
import de.neemann.digital.draw.shapes.InputShape;
import de.neemann.digital.draw.shapes.ShapeFactory;
import de.neemann.digital.gui.Main;
import de.neemann.digital.gui.Settings;
import de.neemann.digital.gui.components.AttributeDialog;
import de.neemann.digital.gui.components.CircuitScrollPanel;
import de.neemann.digital.gui.components.CircuitTransferable;
import de.neemann.digital.gui.components.CopiedElementLabelRenamer;
import de.neemann.digital.gui.components.Editor;
import de.neemann.digital.gui.components.ElementHelpDialog;
import de.neemann.digital.gui.components.ItemPicker;
import de.neemann.digital.gui.components.LabelGenerator;
import de.neemann.digital.gui.components.TransformHolder;
import de.neemann.digital.gui.components.data.DummyElement;
import de.neemann.digital.gui.components.modification.ModificationOfVisualElement;
import de.neemann.digital.gui.components.modification.ModifyAttribute;
import de.neemann.digital.gui.components.modification.ModifyAttributes;
import de.neemann.digital.gui.components.modification.ModifyCircuitAttributes;
import de.neemann.digital.gui.components.modification.ModifyDeleteElement;
import de.neemann.digital.gui.components.modification.ModifyDeleteRect;
import de.neemann.digital.gui.components.modification.ModifyDeleteWire;
import de.neemann.digital.gui.components.modification.ModifyInsertElement;
import de.neemann.digital.gui.components.modification.ModifyInsertWire;
import de.neemann.digital.gui.components.modification.ModifyInsertWires;
import de.neemann.digital.gui.components.modification.ModifyMoveAndRotElement;
import de.neemann.digital.gui.components.modification.ModifyMoveSelected;
import de.neemann.digital.gui.components.modification.ModifyMoveWire;
import de.neemann.digital.lang.Lang;
import de.neemann.digital.testing.TestCaseElement;
import de.neemann.digital.undo.ChangedListener;
import de.neemann.digital.undo.Modification;
import de.neemann.digital.undo.Modifications;
import de.neemann.digital.undo.ModifyException;
import de.neemann.digital.undo.UndoManager;
import de.neemann.gui.ErrorMessage;
import de.neemann.gui.IconCreator;
import de.neemann.gui.LineBreaker;
import de.neemann.gui.Mouse;
import de.neemann.gui.Screen;
import de.neemann.gui.ToolTipAction;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class CircuitComponent
extends JComponent
implements ChangedListener,
LibraryListener {
    public static final Icon ICON_DELETE = IconCreator.create("delete.png");
    public static final Icon ICON_COPY = IconCreator.create("edit-copy.png");
    private static final Icon ICON_UNDO = IconCreator.create("edit-undo.png");
    private static final Icon ICON_REDO = IconCreator.create("edit-redo.png");
    private static final ArrayList<Key> ATTR_LIST = new ArrayList();
    private static final double MAX_SCALE = 50.0;
    private static final double MIN_SCALE = 0.01;
    private static final String DEL_ACTION = "myDelAction";
    private static final int MOUSE_BORDER_SMALL = 10;
    private static final int MOUSE_BORDER_LARGE = 50;
    private static final int DRAG_DISTANCE;
    private final Main parent;
    private final ElementLibrary library;
    private final HashSet<Drawable> highLighted;
    private final ToolTipAction deleteAction;
    private final MouseController mouseNormal;
    private final MouseControllerInsertElement mouseInsertElement;
    private final MouseControllerMoveElement mouseMoveElement;
    private final MouseControllerMoveWire mouseMoveWire;
    private final MouseControllerWireDiag mouseWireDiag;
    private final MouseControllerWireRect mouseWireRect;
    private final MouseControllerWireSplit mouseWireSplit;
    private final MouseControllerSelect mouseSelect;
    private final MouseControllerMoveSelected mouseMoveSelected;
    private final MouseController mouseRun;
    private final MouseControllerInsertCopied mouseInsertList;
    private final MouseControllerResizeRect mouseResizeRect;
    private final Cursor moveCursor;
    private final ToolTipAction copyAction;
    private final ToolTipAction cutAction;
    private final ToolTipAction pasteAction;
    private final ToolTipAction rotateAction;
    private final ToolTipAction undoAction;
    private final ToolTipAction redoAction;
    private final UndoManager<Circuit> undoManager;
    private final Mouse mouse = Mouse.getMouse();
    private MouseController activeMouseController;
    private AffineTransform transform = new AffineTransform();
    private Vector lastMousePos;
    private SyncAccess modelSync = SyncAccess.NOSYNC;
    private boolean isManualScale;
    private boolean graphicHasChangedFlag = true;
    private boolean hadFocusAtClick = true;
    private boolean lockMessageShown = false;
    private boolean antiAlias = true;
    private double lastScaleX = 0.0;
    private Style highLightStyle = Style.HIGHLIGHT;
    private Circuit shallowCopy;
    private CircuitScrollPanel circuitScrollPanel;
    private TutorialListener tutorialListener;
    private boolean toolTipHighlighted = false;
    private NetList toolTipNetList;
    private String lastUsedTunnelName;
    private boolean presentationMode;
    private BufferedImage buffer;

    static {
        ATTR_LIST.add(Keys.LABEL);
        ATTR_LIST.add(Keys.WIDTH);
        ATTR_LIST.add(Keys.SHAPE_TYPE);
        ATTR_LIST.add(Keys.CUSTOM_SHAPE);
        ATTR_LIST.add(Keys.HEIGHT);
        ATTR_LIST.add(Keys.PINCOUNT);
        ATTR_LIST.add(Keys.BACKGROUND_COLOR);
        ATTR_LIST.add(Keys.DESCRIPTION);
        ATTR_LIST.add(Keys.OSCILLATION_DETECTION_COUNTER);
        ATTR_LIST.add(Keys.LOCKED_MODE);
        ATTR_LIST.add(Keys.ROMMANAGER);
        ATTR_LIST.add(Keys.SHOW_DATA_TABLE);
        ATTR_LIST.add(Keys.SHOW_DATA_GRAPH);
        ATTR_LIST.add(Keys.SHOW_DATA_GRAPH_MICRO);
        ATTR_LIST.add(Keys.SETTINGS_MAX_STEP_COUNT);
        ATTR_LIST.add(Keys.PRELOAD_PROGRAM);
        ATTR_LIST.add(Keys.PROGRAM_TO_PRELOAD);
        ATTR_LIST.add(Keys.BIG_ENDIAN_SETTING);
        ATTR_LIST.add(Keys.SKIP_HDL);
        ATTR_LIST.add(Keys.IS_GENERIC);
        DRAG_DISTANCE = (int)(10.0f * Screen.getInstance().getScaling());
    }

    public static ArrayList<Key> getAttrList() {
        return ATTR_LIST;
    }

    public CircuitComponent(Main parent, ElementLibrary library, ShapeFactory shapeFactory) {
        this.parent = parent;
        this.library = library;
        this.highLighted = new HashSet();
        this.rotateAction = new ToolTipAction(Lang.get("menu_rotate", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent e) {
                CircuitComponent.this.activeMouseController.rotate();
            }
        }.setEnabledChain(false).setAccelerator("R").enableAcceleratorIn(this);
        this.cutAction = this.createCutAction(shapeFactory);
        this.copyAction = this.createCopyAction(shapeFactory);
        this.pasteAction = this.createPasteAction(shapeFactory);
        this.deleteAction = new ToolTipAction(Lang.get("menu_delete", new Object[0]), ICON_DELETE){

            @Override
            public void actionPerformed(ActionEvent e) {
                CircuitComponent.this.activeMouseController.delete();
            }
        }.setToolTip(Lang.get("menu_delete_tt", new Object[0]));
        this.undoAction = new ToolTipAction(Lang.get("menu_undo", new Object[0]), ICON_UNDO){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CircuitComponent.this.undo();
            }
        }.setToolTipProvider(this::getUndoToolTip).setToolTip(Lang.get("menu_undo_tt", new Object[0])).setAcceleratorCTRLplus('Z').enableAcceleratorIn(this);
        this.redoAction = new ToolTipAction(Lang.get("menu_redo", new Object[0]), ICON_REDO){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CircuitComponent.this.redo();
            }
        }.setToolTipProvider(this::getRedoToolTip).setToolTip(Lang.get("menu_redo_tt", new Object[0])).setAcceleratorCTRLplus('Y').enableAcceleratorIn(this);
        new ToolTipAction("Escape"){

            @Override
            public void actionPerformed(ActionEvent e) {
                CircuitComponent.this.activeMouseController.escapePressed();
            }
        }.setAccelerator(KeyStroke.getKeyStroke(27, 0)).enableAcceleratorIn(this);
        new ToolTipAction("flipWire"){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (CircuitComponent.this.activeMouseController instanceof MouseControllerWireRect) {
                    ((MouseControllerWireRect)CircuitComponent.this.activeMouseController).flipWire();
                }
            }
        }.setAccelerator("F").enableAcceleratorIn(this);
        new ToolTipAction("splitWire"){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (CircuitComponent.this.activeMouseController == CircuitComponent.this.mouseNormal) {
                    Vector pos = CircuitComponent.this.getPosVector(((CircuitComponent)CircuitComponent.this).lastMousePos.x, ((CircuitComponent)CircuitComponent.this).lastMousePos.y);
                    Wire w = CircuitComponent.this.getCircuit().getWireAt(pos, 10);
                    if (w != null) {
                        CircuitComponent.this.mouseWireSplit.activate(w, pos);
                    }
                }
            }
        }.setAccelerator("S").enableAcceleratorIn(this);
        this.createAdditionalShortcuts(shapeFactory);
        this.getInputMap().put(KeyStroke.getKeyStroke(127, 0), DEL_ACTION);
        this.getInputMap().put(KeyStroke.getKeyStroke(8, 0), DEL_ACTION);
        this.getActionMap().put(DEL_ACTION, this.deleteAction);
        this.setFocusable(true);
        this.addMouseWheelListener(e -> {
            double f = Math.pow(0.9, e.getWheelRotation());
            if (this.scalingValid(f)) {
                Vector pos = this.getPosVector(e);
                this.transform.translate(pos.x, pos.y);
                this.transform.scale(f, f);
                this.transform.translate(-pos.x, -pos.y);
                this.isManualScale = true;
                if (this.circuitScrollPanel != null) {
                    this.circuitScrollPanel.transformChanged(this.transform);
                }
                this.graphicHasChanged();
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                if (!CircuitComponent.this.isManualScale) {
                    CircuitComponent.this.fitCircuit();
                }
            }
        });
        Cursor normalCursor = new Cursor(0);
        this.moveCursor = new Cursor(13);
        this.mouseNormal = new MouseControllerNormal(normalCursor);
        this.mouseInsertElement = new MouseControllerInsertElement(normalCursor);
        this.mouseInsertList = new MouseControllerInsertCopied(normalCursor);
        this.mouseMoveElement = new MouseControllerMoveElement(normalCursor);
        this.mouseMoveWire = new MouseControllerMoveWire(normalCursor);
        this.mouseWireRect = new MouseControllerWireRect(normalCursor);
        this.mouseWireDiag = new MouseControllerWireDiag(normalCursor);
        this.mouseWireSplit = new MouseControllerWireSplit(normalCursor);
        this.mouseSelect = new MouseControllerSelect(new Cursor(1));
        this.mouseMoveSelected = new MouseControllerMoveSelected(this.moveCursor);
        this.mouseRun = new MouseControllerRun(normalCursor);
        this.mouseResizeRect = new MouseControllerResizeRect(normalCursor);
        this.undoManager = new UndoManager<Circuit>(new Circuit());
        this.addListener(this);
        MouseDispatcher dispatcher = new MouseDispatcher();
        this.addMouseMotionListener(dispatcher);
        this.addMouseListener(dispatcher);
        this.enableFavoritePositions();
        this.mouseNormal.activate();
        if (parent != null) {
            parent.addWindowListener(new WindowAdapter(){

                @Override
                public void windowDeactivated(WindowEvent e) {
                    if (!(CircuitComponent.this.activeMouseController instanceof MouseControllerWizard) && CircuitComponent.this.activeMouseController != CircuitComponent.this.mouseSelect) {
                        CircuitComponent.this.activeMouseController.escapePressed();
                    }
                }
            });
        }
        this.setToolTipText("");
    }

    private void enableFavoritePositions() {
        int j = 0;
        while (j <= 9) {
            int i = j++;
            final Key<TransformHolder> key = new Key<TransformHolder>("view" + i, TransformHolder::new);
            new ToolTipAction("CTRL+" + i){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ElementAttributes attr = new ElementAttributes(CircuitComponent.this.getCircuit().getAttributes());
                    attr.set(key, new TransformHolder(CircuitComponent.this.transform));
                    CircuitComponent.this.modify(new ModifyCircuitAttributes(attr));
                }
            }.setAcceleratorCTRLplus((char)(48 + i)).enableAcceleratorIn(this);
            new ToolTipAction("" + i){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TransformHolder transformHolder = (TransformHolder)CircuitComponent.this.getCircuit().getAttributes().get(key);
                    if (!transformHolder.isIdentity()) {
                        CircuitComponent.this.transform = transformHolder.createAffineTransform();
                        CircuitComponent.this.isManualScale = true;
                        CircuitComponent.this.graphicHasChanged();
                        if (CircuitComponent.this.circuitScrollPanel != null) {
                            CircuitComponent.this.circuitScrollPanel.transformChanged(CircuitComponent.this.transform);
                        }
                    }
                }
            }.setAccelerator(KeyStroke.getKeyStroke((int)((char)(48 + i)), 0)).enableAcceleratorIn(this);
        }
    }

    private void createAdditionalShortcuts(final ShapeFactory shapeFactory) {
        new ToolTipAction("diagWire"){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (CircuitComponent.this.activeMouseController instanceof MouseControllerWireDiag) {
                    ((MouseControllerWireDiag)CircuitComponent.this.activeMouseController).rectangularWire();
                } else if (CircuitComponent.this.activeMouseController instanceof MouseControllerWireRect) {
                    ((MouseControllerWireRect)CircuitComponent.this.activeMouseController).diagonalWire();
                }
            }
        }.setAccelerator("D").enableAcceleratorIn(this);
        new ToolTipAction("selectAll"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (CircuitComponent.this.activeMouseController == CircuitComponent.this.mouseNormal) {
                    GraphicMinMax gr = new GraphicMinMax();
                    CircuitComponent.this.getCircuit().drawTo(gr);
                    if (gr.getMin() != null && gr.getMax() != null) {
                        CircuitComponent.this.mouseSelect.activate(gr.getMin(), gr.getMax());
                        CircuitComponent.this.mouseSelect.release();
                    }
                }
            }
        }.setAcceleratorCTRLplus('A').enableAcceleratorIn(this);
        new ToolTipAction("duplicate"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ArrayList elements = CircuitComponent.this.getSelectedElements(shapeFactory);
                if (elements != null) {
                    CircuitComponent.this.activeMouseController.escapePressed();
                    ArrayList<Movable> copiedElements = new ArrayList<Movable>();
                    for (Movable m : elements) {
                        if (m instanceof Wire) {
                            copiedElements.add(new Wire((Wire)m));
                            continue;
                        }
                        if (!(m instanceof VisualElement)) continue;
                        copiedElements.add(new VisualElement((VisualElement)m));
                    }
                    CircuitComponent.this.setPartsToInsert(copiedElements, null);
                }
            }
        }.setAcceleratorCTRLplus('D').enableAcceleratorIn(this);
        new ToolTipAction("insertTunnel"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (CircuitComponent.this.activeMouseController == CircuitComponent.this.mouseNormal) {
                    VisualElement tunnel = new VisualElement(Tunnel.DESCRIPTION.getName()).setShapeFactory(shapeFactory);
                    CircuitComponent.this.setPartToInsert(tunnel);
                }
            }
        }.setAccelerator("T").enableAcceleratorIn(this);
        new ToolTipAction("pipetteCopy"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                VisualElement ve;
                if (CircuitComponent.this.activeMouseController == CircuitComponent.this.mouseNormal && (ve = CircuitComponent.this.getActualVisualElement()) != null) {
                    CircuitComponent.this.setPartToInsert(new VisualElement(ve));
                }
            }
        }.setAccelerator("Q").enableAcceleratorIn(this);
        new ToolTipAction("pipette"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                VisualElement ve;
                if (CircuitComponent.this.activeMouseController == CircuitComponent.this.mouseNormal && (ve = CircuitComponent.this.getActualVisualElement()) != null) {
                    VisualElement insert = new VisualElement(ve.getElementName()).setShapeFactory(shapeFactory);
                    CircuitComponent.this.setPartToInsert(insert);
                }
            }
        }.setAcceleratorCTRLplus("Q").enableAcceleratorIn(this);
        ToolTipAction plus = new PlusMinusAction(1).setAccelerator("PLUS").enableAcceleratorIn(this);
        this.getInputMap().put(KeyStroke.getKeyStroke(107, 0), plus);
        ToolTipAction minus = new PlusMinusAction(-1).setAccelerator("MINUS").enableAcceleratorIn(this);
        this.getInputMap().put(KeyStroke.getKeyStroke(109, 0), minus);
        new ToolTipAction(Lang.get("menu_programDiode", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent e) {
                VisualElement ve = CircuitComponent.this.getActualVisualElement();
                if (ve != null) {
                    if (CircuitComponent.this.library.isProgrammable(ve.getElementName())) {
                        boolean blown = ve.getElementAttributes().get(Keys.BLOWN);
                        CircuitComponent.this.modify(new ModifyAttribute<Boolean>(ve, Keys.BLOWN, !blown));
                    } else if (ve.equalsDescription(Switch.DESCRIPTION)) {
                        boolean closed = ve.getElementAttributes().get(Keys.CLOSED);
                        CircuitComponent.this.modify(new ModifyAttribute<Boolean>(ve, Keys.CLOSED, !closed));
                    }
                }
            }
        }.setAccelerator("P").enableAcceleratorIn(this);
    }

    private ToolTipAction createPasteAction(final ShapeFactory shapeFactory) {
        return new ToolTipAction(Lang.get("menu_paste", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!CircuitComponent.this.isLocked()) {
                    Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                    try {
                        Object data = clipboard.getData(DataFlavor.stringFlavor);
                        if (data instanceof String) {
                            Vector posVector = CircuitComponent.this.getPosVector(((CircuitComponent)CircuitComponent.this).lastMousePos.x, ((CircuitComponent)CircuitComponent.this).lastMousePos.y);
                            ArrayList<Movable> elements = CircuitTransferable.createList(data, shapeFactory);
                            if (elements != null) {
                                CircuitComponent.this.setPartsToInsert(elements, posVector);
                            }
                        }
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                        SwingUtilities.invokeLater(new ErrorMessage(Lang.get("msg_clipboardContainsNoImportableData", new Object[0])).setComponent(CircuitComponent.this));
                    }
                }
            }
        }.setAcceleratorCTRLplus('V').enableAcceleratorIn(this);
    }

    private ToolTipAction createCutAction(final ShapeFactory shapeFactory) {
        return new ToolTipAction(Lang.get("menu_cut", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!CircuitComponent.this.isLocked() && CircuitComponent.this.activeMouseController instanceof MouseControllerSelect) {
                    MouseControllerSelect mcs = (MouseControllerSelect)CircuitComponent.this.activeMouseController;
                    Vector min = Vector.min(mcs.corner1, mcs.corner2);
                    Vector max = Vector.max(mcs.corner1, mcs.corner2);
                    ArrayList<Movable> elements = CircuitComponent.this.getCircuit().copyElementsToMove(min, max, shapeFactory);
                    if (elements != null) {
                        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                        clipboard.setContents(new CircuitTransferable(elements), null);
                        CircuitComponent.this.modify(new ModifyDeleteRect(min, max));
                        CircuitComponent.this.activeMouseController.escapePressed();
                    }
                }
            }
        }.setEnabledChain(false).setAcceleratorCTRLplus('X').enableAcceleratorIn(this);
    }

    private ToolTipAction createCopyAction(final ShapeFactory shapeFactory) {
        return new ToolTipAction(Lang.get("menu_copy", new Object[0]), ICON_COPY){

            @Override
            public void actionPerformed(ActionEvent e) {
                ArrayList elements = CircuitComponent.this.getSelectedElements(shapeFactory);
                if (elements != null) {
                    Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                    clipboard.setContents(new CircuitTransferable(elements), null);
                    CircuitComponent.this.activeMouseController.escapePressed();
                }
            }
        }.setEnabledChain(false).setAcceleratorCTRLplus('C').enableAcceleratorIn(this);
    }

    private ArrayList<Movable> getSelectedElements(ShapeFactory shapeFactory) {
        ArrayList<Movable> elements = null;
        if (this.activeMouseController instanceof MouseControllerSelect) {
            MouseControllerSelect mcs = (MouseControllerSelect)this.activeMouseController;
            elements = this.getCircuit().copyElementsToMove(Vector.min(mcs.corner1, mcs.corner2), Vector.max(mcs.corner1, mcs.corner2), shapeFactory);
        } else if (this.activeMouseController instanceof MouseControllerMoveElement) {
            MouseControllerMoveElement mcme = (MouseControllerMoveElement)this.activeMouseController;
            elements = new ArrayList<VisualElement>();
            elements.add(mcme.visualElement);
        }
        return elements;
    }

    public void editCircuitAttributes() {
        ElementAttributes modifiedAttributes = new AttributeDialog((Window)this.parent, ATTR_LIST, this.getCircuit().getAttributes()).setDialogTitle(Lang.get("menu_editAttributes", new Object[0])).showDialog();
        if (modifiedAttributes != null) {
            this.modify(new ModifyCircuitAttributes(modifiedAttributes));
        }
    }

    public void modify(Modification<Circuit> modification) {
        try {
            if (modification != null) {
                this.toolTipNetList = null;
                this.undoManager.apply(modification);
                if (this.tutorialListener != null) {
                    this.tutorialListener.modified(modification);
                }
                if (this.circuitScrollPanel != null) {
                    this.circuitScrollPanel.sizeChanged();
                }
            }
        }
        catch (ModifyException e) {
            throw new RuntimeException("internal error in modify", e);
        }
    }

    public void graphicHasChanged() {
        this.graphicHasChangedFlag = true;
        this.repaint();
    }

    private void undo() {
        if (this.activeMouseController != this.mouseNormal) {
            this.activeMouseController.escapePressed();
        } else if (!this.isLocked() && this.undoManager.undoAvailable()) {
            try {
                this.undoManager.undo();
            }
            catch (ModifyException e) {
                throw new RuntimeException("internal error in undo", e);
            }
        }
    }

    private String getUndoToolTip() {
        if (this.undoManager.undoAvailable()) {
            return Lang.get("mod_undo_N", this.undoManager.getUndoModification().toString());
        }
        return Lang.get("menu_undo_tt", new Object[0]);
    }

    private void redo() {
        if (this.activeMouseController != this.mouseNormal) {
            this.activeMouseController.escapePressed();
        } else if (!this.isLocked() && this.undoManager.redoAvailable()) {
            try {
                this.undoManager.redo();
            }
            catch (ModifyException e) {
                throw new RuntimeException("internal error in redo", e);
            }
        }
    }

    private String getRedoToolTip() {
        if (this.undoManager.redoAvailable()) {
            return Lang.get("mod_redo_N", this.undoManager.getRedoModification().toString());
        }
        return Lang.get("menu_redo_tt", new Object[0]);
    }

    public void save(File filename) throws IOException {
        this.getCircuit().save(filename);
        try {
            this.undoManager.applyWithoutHistory(circuit -> circuit.setOrigin(filename));
        }
        catch (ModifyException e) {
            throw new RuntimeException("internal error in save", e);
        }
        this.undoManager.saved();
    }

    public Main getMain() {
        return this.parent;
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        Vector pos;
        Circuit circuit;
        VisualElement ve;
        if (this.toolTipHighlighted) {
            this.toolTipHighlighted = false;
            this.removeHighLighted();
        }
        if ((ve = (circuit = this.getCircuitOrShallowCopy()).getElementAt(pos = this.getPosVector(event))) != null) {
            if (this.presentationMode) {
                return null;
            }
            Pin p = ve.getPinAt(CircuitComponent.raster(pos));
            if (p != null) {
                return this.createPinToolTip(p);
            }
            try {
                ElementTypeDescription etd = this.library.getElementType(ve.getElementName());
                String tt = etd.getDescription(ve.getElementAttributes());
                String pin = ve.getElementAttributes().get(Keys.PINNUMBER);
                if (pin.length() > 0) {
                    tt = String.valueOf(tt) + " (" + Lang.get("msg_pin_N", pin) + ")";
                }
                return this.checkToolTip(tt);
            }
            catch (ElementNotFoundException e) {
                return null;
            }
        }
        Wire w = circuit.getWireAt(pos, (int)(10.0 / this.transform.getScaleX()));
        if (w != null) {
            ObservableValue v = w.getValue();
            if (v != null) {
                return v.getValueString();
            }
            if (Settings.getInstance().get(Keys.SETTINGS_WIRETOOLTIP).booleanValue() && (this.highLighted == null || this.highLighted.isEmpty() || this.toolTipHighlighted)) {
                try {
                    Net n;
                    if (this.toolTipNetList == null) {
                        this.toolTipNetList = new NetList(this.getCircuit());
                    }
                    if ((n = this.toolTipNetList.getNetOfPos(w.p1)) != null) {
                        this.removeHighLighted();
                        this.addHighLighted(n.getWires());
                        this.toolTipHighlighted = true;
                    }
                }
                catch (PinException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    private String createPinToolTip(Pin p) {
        String pinNumber;
        String text = p.getName();
        String des = p.getDescription();
        if (des != null && des.length() > 0) {
            text = String.valueOf(text) + ": " + des;
        }
        if ((pinNumber = p.getPinNumber()) != null && pinNumber.length() > 0) {
            text = String.valueOf(text) + " (" + Lang.get("msg_pin_N", pinNumber) + ")";
        }
        return this.checkToolTip(text);
    }

    private String checkToolTip(String tt) {
        if (tt != null && tt.length() == 0) {
            return null;
        }
        return new LineBreaker().toHTML().breakLines(tt);
    }

    public ToolTipAction getDeleteAction() {
        return this.deleteAction;
    }

    public ToolTipAction getCutAction() {
        return this.cutAction;
    }

    public ToolTipAction getCopyAction() {
        return this.copyAction;
    }

    public ToolTipAction getPasteAction() {
        return this.pasteAction;
    }

    public ToolTipAction getRotateAction() {
        return this.rotateAction;
    }

    public void setModeAndReset(boolean runMode, SyncAccess modelSync) {
        this.modelSync = modelSync;
        if (runMode) {
            this.redoAction.setEnabled(false);
            this.undoAction.setEnabled(false);
            this.mouseRun.activate();
        } else {
            this.enableUndoRedo();
            this.mouseNormal.activate();
            this.getCircuit().clearState();
        }
        this.requestFocusInWindow();
        if (this.tutorialListener != null) {
            this.tutorialListener.modified(null);
        }
    }

    private void enableUndoRedo() {
        this.redoAction.setEnabled(this.undoManager.redoAvailable());
        this.undoAction.setEnabled(this.undoManager.undoAvailable());
    }

    public Collection<Drawable> getHighLighted() {
        return this.highLighted;
    }

    public <T extends Drawable> void addHighLighted(T drawable) {
        if (drawable != null) {
            this.highLighted.add(drawable);
            this.graphicHasChanged();
        }
    }

    public void addHighLighted(Collection<? extends Drawable> drawables) {
        if (drawables != null) {
            this.highLighted.addAll(drawables);
            this.graphicHasChanged();
        }
    }

    public void addHighLightedWires(ImmutableList<ObservableValue> values) {
        if (values == null) {
            return;
        }
        HashSet<ObservableValue> ov = new HashSet<ObservableValue>(values);
        for (Wire w : this.getCircuit().getWires()) {
            if (!ov.contains(w.getValue())) continue;
            this.addHighLighted(w);
        }
    }

    public void removeHighLighted() {
        if (!this.highLighted.isEmpty()) {
            this.highLighted.clear();
            this.highLightStyle = Style.HIGHLIGHT;
            this.graphicHasChanged();
        }
    }

    public void setHighLightStyle(Style highLightStyle) {
        this.highLightStyle = highLightStyle;
    }

    public Style getHighLightStyle() {
        return this.highLightStyle;
    }

    public void setPartToInsert(VisualElement element) {
        if (element.equalsDescription(Tunnel.DESCRIPTION) && this.lastUsedTunnelName != null) {
            CopiedElementLabelRenamer.LabelInstance li = CopiedElementLabelRenamer.LabelInstance.create(Tunnel.DESCRIPTION.getName(), this.lastUsedTunnelName);
            if (li != null) {
                this.lastUsedTunnelName = li.getLabel(1);
            }
            element.setAttribute(Keys.NETNAME, this.lastUsedTunnelName);
        }
        this.parent.ensureModelIsStopped();
        this.mouseInsertElement.activate(element);
        Point point = MouseInfo.getPointerInfo().getLocation();
        SwingUtilities.convertPointFromScreen(point, this);
        if (point.x < 50 || point.x > this.getWidth() - 10 || point.y < 50 || point.y > this.getHeight() - 10) {
            if (point.x < 50) {
                point.x = 50;
            } else if (point.x > this.getWidth() - 10) {
                point.x = this.getWidth() - 10;
            }
            if (point.y < 50) {
                point.y = 50;
            } else if (point.y > this.getHeight() - 10) {
                point.y = this.getHeight() - 10;
            }
        }
        this.mouseInsertElement.updateMousePos(this.getPosVector(point.x, point.y));
        this.graphicHasChanged();
        this.requestFocus();
    }

    public void setPartsToInsert(ArrayList<Movable> elements, Vector pos) {
        this.removeHighLighted();
        this.parent.ensureModelIsStopped();
        if (pos == null) {
            pos = this.lastMousePos != null ? this.getPosVector(this.lastMousePos.x, this.lastMousePos.y) : this.getPosVector(0, 0);
        }
        if (Settings.getInstance().get(Keys.SETTINGS_RENAME_LABELS).booleanValue()) {
            elements = new CopiedElementLabelRenamer(this.getCircuit(), elements).rename();
        }
        this.mouseInsertList.activate(elements, pos);
        this.graphicHasChanged();
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D gr2;
        boolean newBufferRequired;
        super.paintComponent(g);
        boolean bl = newBufferRequired = this.buffer == null || this.getWidth() != this.buffer.getWidth() || this.getHeight() != this.buffer.getHeight();
        if (newBufferRequired && !this.isManualScale) {
            this.fitCircuit();
        }
        double scaleX = this.transform.getScaleX();
        if (this.graphicHasChangedFlag || newBufferRequired) {
            boolean scaleHasChanged;
            if (newBufferRequired) {
                this.buffer = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().createCompatibleImage(this.getWidth(), this.getHeight());
            }
            gr2 = this.buffer.createGraphics();
            GraphicSwing gr = new GraphicSwing(gr2, (int)(2.0 / scaleX));
            gr.enableAntiAlias(this.antiAlias);
            gr2.setColor(ColorScheme.getSelected().getColor(ColorKey.BACKGROUND));
            gr2.fillRect(0, 0, this.getWidth(), this.getHeight());
            if (scaleX > 0.3 && Settings.getInstance().get(Keys.SETTINGS_GRID).booleanValue() && !this.presentationMode) {
                this.drawGrid(gr2);
            }
            if (this.presentationMode) {
                gr2.setColor(Color.LIGHT_GRAY);
                gr2.drawString(Lang.get("menu_presentationMode", new Object[0]), 4, this.getHeight() - 4);
            }
            gr2.transform(this.transform);
            long time = System.currentTimeMillis();
            this.getCircuitOrShallowCopy().drawTo(gr, this.highLighted, this.highLightStyle, this.modelSync, this.presentationMode);
            time = System.currentTimeMillis() - time;
            boolean bl2 = scaleHasChanged = this.lastScaleX != scaleX;
            if (time > 500L && !scaleHasChanged) {
                this.antiAlias = false;
            }
            if (time < 50L) {
                this.antiAlias = true;
            }
            this.graphicHasChangedFlag = false;
        }
        g.drawImage(this.buffer, 0, 0, null);
        gr2 = (Graphics2D)g;
        AffineTransform oldTrans = gr2.getTransform();
        gr2.transform(this.transform);
        GraphicSwing gr = new GraphicSwing(gr2, (int)(2.0 / scaleX));
        gr.enableAntiAlias(this.activeMouseController.drawables() < 200);
        this.activeMouseController.drawTo(gr);
        gr2.setTransform(oldTrans);
        this.lastScaleX = scaleX;
    }

    private void drawGrid(Graphics2D gr2) {
        double max;
        double min;
        Vector g1 = CircuitComponent.raster(this.getPosVector(0, 0));
        Point2D.Double p1 = new Point2D.Double();
        this.transform.transform(new Point(g1.x, g1.y), p1);
        Vector g2 = CircuitComponent.raster(this.getPosVector(this.getWidth(), this.getHeight()));
        Point2D.Double p2 = new Point2D.Double();
        this.transform.transform(new Point(g2.x, g2.y), p2);
        int cx = (g2.x - g1.x) / 20;
        int cy = (g2.y - g1.y) / 20;
        if (cx == 0 || cy == 0) {
            return;
        }
        float screenScaling = Screen.getInstance().getScaling();
        double delta = this.transform.getScaleX() * 2.0 * (double)screenScaling;
        if (delta < (min = (double)(2.0f * screenScaling))) {
            delta = min;
        }
        if (delta > (max = (double)(8.0f * screenScaling))) {
            delta = max;
        }
        double sub = delta / 2.0;
        gr2.setColor(ColorScheme.getSelected().getColor(ColorKey.GRID));
        int x = 0;
        while (x <= cx) {
            double xx = ((Point2D)p1).getX() + (((Point2D)p2).getX() - ((Point2D)p1).getX()) * (double)x / (double)cx - sub;
            int y = 0;
            while (y <= cy) {
                double yy = ((Point2D)p1).getY() + (((Point2D)p2).getY() - ((Point2D)p1).getY()) * (double)y / (double)cy - sub;
                gr2.fill(new Rectangle2D.Double(xx, yy, delta, delta));
                ++y;
            }
            ++x;
        }
        if (this.getCircuit().getAttributes().get(Keys.IS_GENERIC).booleanValue()) {
            double dx = (((Point2D)p2).getX() - ((Point2D)p1).getX()) / (double)cx / 2.0;
            double dy = (((Point2D)p2).getY() - ((Point2D)p1).getY()) / (double)cy / 2.0;
            Point2D.Double origin = new Point2D.Double();
            this.transform.transform(new Point(0, 0), origin);
            gr2.drawOval((int)(origin.getX() - dy), (int)(origin.getY() - dy), (int)(dx * 2.0), (int)(dy * 2.0));
        }
    }

    public Point transform(Vector pos) {
        Point p = new Point();
        this.transform.transform(new Point(pos.x, pos.y), p);
        return p;
    }

    @Override
    public void hasChanged() {
        this.graphicHasChanged();
        this.enableUndoRedo();
    }

    private Vector getPosVector(MouseEvent e) {
        return this.getPosVector(e.getX(), e.getY());
    }

    private Vector getPosVector(int x, int y) {
        try {
            Point2D.Float p = new Point2D.Float();
            this.transform.inverseTransform(new Point(x, y), p);
            return new Vector((int)Math.round(p.getX()), (int)Math.round(p.getY()));
        }
        catch (NoninvertibleTransformException e1) {
            throw new RuntimeException(e1);
        }
    }

    public static Vector raster(Vector pos) {
        return new Vector((int)Math.round((double)pos.x / 20.0) * 20, (int)Math.round((double)pos.y / 20.0) * 20);
    }

    public static Vector toMinRaster(Vector pos, boolean minRaster) {
        if (!minRaster) {
            return pos;
        }
        int s = 40;
        return new Vector((int)Math.round((double)pos.x / 40.0) * 40, (int)Math.round((double)pos.y / 40.0) * 40);
    }

    public Circuit getCircuit() {
        return this.undoManager.getActual();
    }

    public Circuit getCircuitOrShallowCopy() {
        if (this.shallowCopy != null) {
            return this.shallowCopy;
        }
        return this.undoManager.getActual();
    }

    public void setCircuit(Circuit circuit) {
        this.undoManager.setInitial(circuit);
        this.undoAction.setEnabled(false);
        this.redoAction.setEnabled(false);
        this.toolTipNetList = null;
        if (this.circuitScrollPanel != null) {
            this.circuitScrollPanel.sizeChanged();
        }
        this.fitCircuit();
        this.setModeAndReset(false, SyncAccess.NOSYNC);
    }

    public void fitCircuit() {
        GraphicMinMax gr = new GraphicMinMax();
        this.getCircuitOrShallowCopy().drawTo(gr, this.presentationMode);
        AffineTransform newTrans = new AffineTransform();
        if (gr.getMin() != null && this.getWidth() != 0 && this.getHeight() != 0) {
            Vector delta = gr.getMax().sub(gr.getMin());
            int pad = this.circuitScrollPanel.getBarWidth();
            double sx = ((double)this.getWidth() - (double)pad) / (double)(delta.x + 40);
            double sy = ((double)this.getHeight() - (double)pad) / (double)(delta.y + 40);
            double s = Math.min(sx, sy);
            newTrans.setToScale(s, s);
            Vector center = gr.getMin().add(gr.getMax()).div(2);
            newTrans.translate(-center.x, -center.y);
            Vector dif = new Vector(this.getWidth(), this.getHeight()).div(2);
            newTrans.translate((double)dif.x / s, (double)dif.y / s);
            this.isManualScale = false;
        } else {
            this.isManualScale = true;
        }
        if (!newTrans.equals(this.transform)) {
            this.transform = newTrans;
            if (this.circuitScrollPanel != null) {
                this.circuitScrollPanel.transformChanged(this.transform);
            }
            this.graphicHasChanged();
        }
    }

    public void scaleCircuit(double f) {
        if (this.scalingValid(f)) {
            Vector dif = this.getPosVector(this.getWidth() / 2, this.getHeight() / 2);
            this.transform.translate(dif.x, dif.y);
            this.transform.scale(f, f);
            this.transform.translate(-dif.x, -dif.y);
            this.isManualScale = true;
            if (this.circuitScrollPanel != null) {
                this.circuitScrollPanel.transformChanged(this.transform);
            }
            this.graphicHasChanged();
        }
    }

    private boolean scalingValid(double f) {
        if (this.transform.getScaleX() > 50.0 && f > 1.0) {
            return false;
        }
        return !(this.transform.getScaleX() < 0.01) || !(f < 1.0);
    }

    public void setScale(float f) {
        Vector origin = this.getPosVector(this.getWidth() / 2, this.getHeight() / 2);
        this.transform.setToScale(f, f);
        VectorFloat tr = new Vector(this.getWidth() / 2, this.getHeight() / 2).mul(1.0f / f).sub(origin);
        this.transform.translate(tr.getXFloat(), tr.getYFloat());
        this.isManualScale = true;
        if (this.circuitScrollPanel != null) {
            this.circuitScrollPanel.transformChanged(this.transform);
        }
        this.graphicHasChanged();
    }

    public void translateCircuit(int dx, int dy) {
        this.transform.translate(dx, dy);
        this.isManualScale = true;
        if (this.circuitScrollPanel != null) {
            this.circuitScrollPanel.transformChanged(this.transform);
        }
        this.graphicHasChanged();
    }

    void translateCircuitToX(double x) {
        double[] matrix = new double[6];
        this.transform.getMatrix(matrix);
        matrix[4] = x;
        this.transform = new AffineTransform(matrix);
        this.isManualScale = true;
        if (this.circuitScrollPanel != null) {
            this.circuitScrollPanel.transformChanged(this.transform);
        }
        this.graphicHasChanged();
    }

    void translateCircuitToY(double y) {
        double[] matrix = new double[6];
        this.transform.getMatrix(matrix);
        matrix[5] = y;
        this.transform = new AffineTransform(matrix);
        this.isManualScale = true;
        if (this.circuitScrollPanel != null) {
            this.circuitScrollPanel.transformChanged(this.transform);
        }
        this.graphicHasChanged();
    }

    private void editAttributes(final VisualElement element, MouseEvent e) {
        block13: {
            try {
                ElementTypeDescriptionCustom customDescr;
                ArrayList<Key> list = this.getAttributeList(element);
                if (list.size() <= 0) break block13;
                final ElementTypeDescription elementType = this.library.getElementType(element.getElementName());
                if (elementType instanceof ElementTypeDescriptionCustom && (customDescr = (ElementTypeDescriptionCustom)elementType).isGeneric() && element.getElementAttributes().get(Keys.GENERIC).isEmpty()) {
                    try {
                        element.getElementAttributes().set(Keys.GENERIC, customDescr.getDeclarationDefault());
                    }
                    catch (NodeException ex) {
                        new ErrorMessage(Lang.get("msg_errParsingGenerics", new Object[0])).addCause(ex).show(this);
                    }
                }
                if (this.getCircuit().getAttributes().get(Keys.IS_GENERIC).booleanValue() && (elementType == GenericInitCode.DESCRIPTION || elementType == TestCaseElement.DESCRIPTION) && element.getElementAttributes().get(Keys.GENERIC).isEmpty()) {
                    try {
                        element.getElementAttributes().set(Keys.GENERIC, ElementTypeDescriptionCustom.createDeclarationDefault(this.getCircuit()));
                    }
                    catch (NodeException ex) {
                        new ErrorMessage(Lang.get("msg_errParsingGenerics", new Object[0])).addCause(ex).show(this);
                    }
                }
                Point p = new Point(e.getX(), e.getY());
                SwingUtilities.convertPointToScreen(p, this);
                final AttributeDialog attributeDialog = new AttributeDialog((Window)this.parent, p, list, element.getElementAttributes()).setDialogTitle(elementType.getTranslatedName()).setVisualElement(element);
                if (elementType instanceof ElementTypeDescriptionCustom) {
                    attributeDialog.addButton(Lang.get("attr_openCircuitLabel", new Object[0]), new ToolTipAction(Lang.get("attr_openCircuit", new Object[0])){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            attributeDialog.dispose();
                            new Main.MainBuilder().setParent(CircuitComponent.this.parent).setFileToOpen(((ElementTypeDescriptionCustom)elementType).getFile()).setLibrary(CircuitComponent.this.library).denyMostFileActions().setPresentationMode(CircuitComponent.this.presentationMode).keepPrefMainFile().openLater();
                        }
                    }.setToolTip(Lang.get("attr_openCircuit_tt", new Object[0])));
                }
                if ((elementType == GenericInitCode.DESCRIPTION || elementType == GenericCode.DESCRIPTION) && this.getCircuit().getAttributes().get(Keys.IS_GENERIC).booleanValue()) {
                    attributeDialog.addButton(Lang.get("attr_createConcreteCircuitLabel", new Object[0]), new ToolTipAction(Lang.get("attr_createConcreteCircuit", new Object[0])){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            try {
                                attributeDialog.fireOk();
                                ElementAttributes modified = attributeDialog.getModifiedAttributes();
                                if (modified != null && !CircuitComponent.this.isLocked() && !modified.equals(element.getElementAttributes())) {
                                    ModifyAttributes mod = new ModifyAttributes(element, modified);
                                    CircuitComponent.this.modify(CircuitComponent.this.checkNetRename(element, modified, mod));
                                }
                                ElementAttributes attr = null;
                                if (elementType == GenericInitCode.DESCRIPTION) {
                                    attr = element.getElementAttributes();
                                }
                                Circuit concreteCircuit = new ResolveGenerics(CircuitComponent.this.getCircuit(), CircuitComponent.this.library).resolveCircuit(attr).cleanupConcreteCircuit().getCircuit();
                                new Main.MainBuilder().setParent(CircuitComponent.this.parent).setCircuit(concreteCircuit).setLibrary(CircuitComponent.this.library).denyMostFileActions().keepPrefMainFile().openLater();
                            }
                            catch (NodeException | ElementNotFoundException | Editor.EditorParseException ex) {
                                new ErrorMessage(Lang.get("attr_createConcreteCircuitErr", new Object[0])).addCause(ex).show(CircuitComponent.this.parent);
                            }
                        }
                    }.setToolTip(Lang.get("attr_createConcreteCircuit_tt", new Object[0])));
                }
                attributeDialog.addButton(new ToolTipAction(Lang.get("attr_help", new Object[0])){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        try {
                            attributeDialog.dispose();
                            new ElementHelpDialog(attributeDialog.getDialogParent(), elementType, element.getElementAttributes(), CircuitComponent.this.getCircuit().getAttributes().get(Keys.IS_GENERIC)).setVisible(true);
                        }
                        catch (NodeException | PinException e1) {
                            new ErrorMessage(Lang.get("msg_creatingHelp", new Object[0])).addCause(e1).show(CircuitComponent.this);
                        }
                    }
                }.setToolTip(Lang.get("attr_help_tt", new Object[0])));
                boolean locked = this.isLocked();
                if (this.isLocked()) {
                    attributeDialog.disableOk();
                }
                ElementAttributes modified = attributeDialog.showDialog();
                if (elementType == Tunnel.DESCRIPTION && modified != null && modified.contains(Keys.NETNAME)) {
                    this.lastUsedTunnelName = modified.get(Keys.NETNAME);
                }
                if (modified != null && !locked) {
                    ModifyAttributes mod = new ModifyAttributes(element, modified);
                    this.modify(this.checkNetRename(element, modified, mod));
                }
            }
            catch (ElementNotFoundException elementNotFoundException) {
                // empty catch block
            }
        }
    }

    private Modification<Circuit> checkNetRename(VisualElement element, ElementAttributes modified, Modification<Circuit> mod) {
        List<VisualElement> others;
        String oldName = element.getElementAttributes().get(Keys.NETNAME);
        if (element.equalsDescription(Tunnel.DESCRIPTION) && modified.contains(Keys.NETNAME) && !modified.get(Keys.NETNAME).equals(oldName) && !oldName.isEmpty() && (others = this.getCircuit().getElements(el -> el != element && el.equalsDescription(Tunnel.DESCRIPTION) && el.getElementAttributes().get(Keys.NETNAME).equals(oldName))).size() > 0) {
            int res;
            String newName = modified.get(Keys.NETNAME);
            if (Settings.getInstance().get(Keys.SETTINGS_SHOW_TUNNEL_RENAME_DIALOG).booleanValue() && (res = JOptionPane.showConfirmDialog(this, new LineBreaker().toHTML().preserveContainedLineBreaks().breakLines(Lang.get("msg_renameNet_N_OLD_NEW", others.size(), oldName, newName)), Lang.get("msg_renameNet", new Object[0]), 0)) == 0) {
                Modifications.Builder<Circuit> b = new Modifications.Builder<Circuit>(Lang.get("msg_renameNet", new Object[0])).add(mod);
                for (VisualElement o : others) {
                    b.add(new ModifyAttribute<String>(o, Keys.NETNAME, newName));
                }
                return b.build();
            }
        }
        return mod;
    }

    @Override
    public void libraryChanged(LibraryNode node) {
        this.getCircuit().clearState();
        this.graphicHasChangedFlag = true;
        this.repaint();
    }

    public boolean isLocked() {
        boolean locked = this.getCircuit().getAttributes().get(Keys.LOCKED_MODE);
        if (locked && !this.lockMessageShown) {
            String message = Lang.get("msg_isLocked", Lang.get("menu_edit", new Object[0]), Lang.get("menu_editAttributes", new Object[0]), Lang.get("key_lockedMode", new Object[0]));
            SwingUtilities.invokeLater(new ErrorMessage(message).setComponent(this));
            this.lockMessageShown = true;
        }
        return locked;
    }

    public ToolTipAction getUndoAction() {
        return this.undoAction;
    }

    public ToolTipAction getRedoAction() {
        return this.redoAction;
    }

    public void currentToDefault() {
        if (!this.isLocked()) {
            Modifications.Builder<Circuit> builder = new Modifications.Builder<Circuit>(Lang.get("menu_actualToDefault", new Object[0]));
            Circuit circuit = this.getCircuitOrShallowCopy();
            for (VisualElement ve : circuit.getElements()) {
                InValue oldValue;
                InValue newValue;
                ObservableValue ov;
                if (!ve.equalsDescription(In.DESCRIPTION) || (ov = ((InputShape)ve.getShape()).getObservableValue()) == null || (newValue = new InValue(ov)).equals(oldValue = ve.getElementAttributes().get(Keys.INPUT_DEFAULT))) continue;
                builder.add(new ModifyAttribute<InValue>(ve, Keys.INPUT_DEFAULT, newValue));
            }
            this.modify(builder.build());
        }
    }

    public void restoreAllFuses() {
        Modifications.Builder<Circuit> builder = new Modifications.Builder<Circuit>(Lang.get("menu_restoreAllFuses", new Object[0]));
        for (VisualElement ve : this.getCircuit().getElements()) {
            if (!this.library.isProgrammable(ve.getElementName()) || !ve.getElementAttributes().get(Keys.BLOWN).booleanValue()) continue;
            builder.add(new ModifyAttribute<Boolean>(ve, Keys.BLOWN, false));
        }
        this.modify(builder.build());
    }

    public void labelPins() {
        LabelGenerator inGenerator = new LabelGenerator('A', 'B', 'C', 'D', 'E', 'F', 'G', 'H');
        LabelGenerator outGenerator = new LabelGenerator('Y', 'X', 'Z', 'U', 'V');
        Modifications.Builder<Circuit> builder = new Modifications.Builder<Circuit>(Lang.get("menu_labelPins", new Object[0]));
        for (VisualElement ve : this.getCircuit().getElements()) {
            if (ve.equalsDescription(In.DESCRIPTION) && ve.getElementAttributes().getLabel().length() == 0) {
                builder.add(new ModifyAttribute<String>(ve, Keys.LABEL, inGenerator.createLabel()));
                continue;
            }
            if (!ve.equalsDescription(Out.DESCRIPTION) || ve.getElementAttributes().getLabel().length() != 0) continue;
            builder.add(new ModifyAttribute<String>(ve, Keys.LABEL, outGenerator.createLabel()));
        }
        this.modify(builder.build());
    }

    private VisualElement getActualVisualElement() {
        if (this.activeMouseController instanceof MouseControllerMoveElement) {
            this.mouseNormal.activate();
        }
        VisualElement ve = null;
        if (this.activeMouseController instanceof MouseControllerNormal) {
            Vector pos = this.getPosVector(this.lastMousePos.x, this.lastMousePos.y);
            ve = this.getCircuit().getElementAt(pos);
            if (ve == null) {
                ve = this.getCircuit().getElementAt(pos, true);
            }
        }
        return ve;
    }

    public ElementLibrary getLibrary() {
        return this.library;
    }

    private void editGroup(Vector min, Vector max) {
        if (!this.isLocked()) {
            try {
                ArrayList<Key> keyList = new ArrayList<Key>();
                ArrayList<VisualElement> elementList = new ArrayList<VisualElement>();
                HashMap<Key, Boolean> useKeyMap = new HashMap<Key, Boolean>();
                ElementAttributes attr = new ElementAttributes();
                for (VisualElement ve : this.getCircuit().getElements()) {
                    if (!ve.matches(min, max)) continue;
                    elementList.add(ve);
                    for (Key key : this.getAttributeList(ve)) {
                        if (!key.isGroupEditAllowed()) continue;
                        if (keyList.contains(key)) {
                            if (ve.getElementAttributes().get(key).equals(attr.get(key))) continue;
                            useKeyMap.put(key, false);
                            continue;
                        }
                        keyList.add(key);
                        attr.set(key, ve.getElementAttributes().get(key));
                        useKeyMap.put(key, true);
                    }
                }
                if (keyList.size() > 0) {
                    AttributeDialog ad = new AttributeDialog((Window)this.parent, null, keyList, attr, true);
                    for (Map.Entry u : useKeyMap.entrySet()) {
                        ad.getCheckBoxes().get(u.getKey()).setSelected((Boolean)u.getValue());
                    }
                    ElementAttributes mod = ad.showDialog();
                    if (ad.isOkPressed()) {
                        if (mod == null) {
                            mod = attr;
                        }
                        Modifications.Builder<Circuit> builder = new Modifications.Builder<Circuit>(Lang.get("mod_groupEdit", new Object[0]));
                        for (Key key : keyList) {
                            if (!ad.getCheckBoxes().get(key).isSelected()) continue;
                            Object newVal = mod.get(key);
                            for (VisualElement ve : elementList) {
                                if (!this.getAttributeList(ve).contains(key) || ve.getElementAttributes().get(key).equals(newVal)) continue;
                                builder.add(new ModifyAttribute(ve, key, newVal));
                            }
                        }
                        this.modify(builder.build());
                    }
                }
            }
            catch (ElementNotFoundException elementNotFoundException) {
                // empty catch block
            }
        }
    }

    private ArrayList<Key> getAttributeList(VisualElement ve) throws ElementNotFoundException {
        ArrayList<Key> list = this.library.getElementType(ve.getElementName()).getAttributeList();
        if (this.getCircuit().getAttributes().get(Keys.IS_GENERIC).booleanValue() && !list.contains(Keys.GENERIC) && !list.contains(Keys.GENERICLARGE)) {
            list = new ArrayList<Key>(list);
            list.add(Keys.GENERIC);
        }
        return list;
    }

    public boolean isModified() {
        return this.undoManager.isModified();
    }

    public void addListener(ChangedListener listener) {
        this.undoManager.addListener(listener);
    }

    boolean isManualScale() {
        return this.isManualScale;
    }

    public void setCopy(Circuit circuit) {
        this.shallowCopy = circuit;
    }

    public void setPresentationMode(boolean presentationMode) {
        this.presentationMode = presentationMode;
        this.graphicHasChanged();
    }

    public boolean getPresentationMode() {
        return this.presentationMode;
    }

    private SearchResult getVisualElement(Vector pos, boolean includeText) {
        List<VisualElement> list = this.getCircuit().getElementListAt(pos, includeText);
        if (list.size() == 1) {
            return new SearchResult(SearchResult.State.FOUND, list.get(0));
        }
        if (list.size() > 1) {
            ItemPicker<VisualElement> picker = new ItemPicker<VisualElement>((Window)this.parent, list);
            VisualElement vp = picker.select();
            if (vp == null) {
                return new SearchResult(SearchResult.State.CANCELED, null);
            }
            return new SearchResult(SearchResult.State.FOUND, vp);
        }
        return new SearchResult(SearchResult.State.NONE, null);
    }

    private boolean needsMinRaster(VisualElement element) {
        if (this.getCircuit().getAttributes().get(Keys.SHAPE_TYPE) != CustomCircuitShapeType.MINIMIZED) {
            return false;
        }
        return element.equalsDescription(In.DESCRIPTION) || element.equalsDescription(Out.DESCRIPTION) || element.equalsDescription(Clock.DESCRIPTION);
    }

    private void insertWires(VisualElement element) {
        if (this.tutorialListener == null) {
            Modifications.Builder<Circuit> wires = new Modifications.Builder<Circuit>(Lang.get("lib_wires", new Object[0]));
            for (Pin p : element.getPins()) {
                this.insertWirePin(p, element, wires);
            }
            this.modify(wires.build());
        }
    }

    private void insertWirePin(Pin p, VisualElement element, Modifications.Builder<Circuit> wires) {
        TransformRotate tr = new TransformRotate(new Vector(0, 0), element.getRotate());
        Vector pos = new Vector(-20, 0);
        if (p.getDirection() != PinDescription.Direction.input) {
            pos = new Vector(20, 0);
        }
        pos = tr.transform(pos);
        pos = pos.add(p.getPos());
        PinInfo found = null;
        List<VisualElement> el = this.getCircuit().getElementListAt(pos, false);
        for (VisualElement ve : el) {
            Pin pinAt = ve.getPinAt(pos);
            if (pinAt != null) {
                if (found != null) {
                    return;
                }
                found = pinAt;
            }
            if (!ve.isPinPos(p.getPos())) continue;
            return;
        }
        if (found != null && PinDescription.Direction.isInOut(p.getDirection(), found.getDirection())) {
            Wire newWire = new Wire(((Pin)found).getPos(), p.getPos());
            for (Wire w : this.getCircuit().getWires()) {
                if (!w.equalsContent(newWire)) continue;
                return;
            }
            wires.add(new ModifyInsertWire(newWire));
        }
    }

    public void setCircuitScrollPanel(CircuitScrollPanel circuitScrollPanel) {
        this.circuitScrollPanel = circuitScrollPanel;
        if (circuitScrollPanel != null) {
            circuitScrollPanel.transformChanged(this.transform);
        }
    }

    public void activateWizard(WizardNotification wizardNotification) {
        this.mouseNormal.activate();
        this.getCircuit().clearState();
        new MouseControllerWizard(wizardNotification).activate();
    }

    public void setTutorialListener(TutorialListener tutorialListener) {
        this.tutorialListener = tutorialListener;
    }

    public void deactivateWizard() {
        if (this.activeMouseController instanceof MouseControllerWizard) {
            MouseControllerWizard mcw = (MouseControllerWizard)this.activeMouseController;
            mcw.wizardNotification.closed();
        }
        this.mouseNormal.activate();
    }

    private static interface Actor {
        public void interact(CircuitComponent var1, Point var2, Vector var3, SyncAccess var4);
    }

    private class MouseController {
        private final Cursor mouseCursor;

        private MouseController(Cursor mouseCursor) {
            this.mouseCursor = mouseCursor;
        }

        void activate() {
            if (CircuitComponent.this.activeMouseController != null && CircuitComponent.this.activeMouseController != this) {
                CircuitComponent.this.activeMouseController.deactivate();
            }
            CircuitComponent.this.activeMouseController = this;
            CircuitComponent.this.shallowCopy = null;
            CircuitComponent.this.deleteAction.setEnabled(false);
            CircuitComponent.this.copyAction.setEnabled(false);
            CircuitComponent.this.cutAction.setEnabled(false);
            CircuitComponent.this.rotateAction.setEnabled(false);
            CircuitComponent.this.setCursor(this.mouseCursor);
            CircuitComponent.this.graphicHasChanged();
        }

        void deactivate() {
        }

        void clicked(MouseEvent e) {
        }

        void pressed(MouseEvent e) {
        }

        void released(MouseEvent e) {
        }

        void moved(MouseEvent e) {
        }

        boolean dragged(MouseEvent e) {
            return false;
        }

        public int drawables() {
            return 0;
        }

        public void drawTo(Graphic gr) {
        }

        public void delete() {
        }

        public void rotate() {
        }

        public void escapePressed() {
        }
    }

    private final class MouseControllerInsertCopied
    extends MouseController {
        private ArrayList<Movable> elements;
        private Vector lastPos;

        private MouseControllerInsertCopied(Cursor cursor) {
            super(cursor);
        }

        private void activate(ArrayList<Movable> elements, Vector pos) {
            super.activate();
            this.elements = elements;
            this.lastPos = pos;
            Vector max = null;
            for (Movable m : elements) {
                if (m instanceof VisualElement) {
                    GraphicMinMax mm = ((VisualElement)m).getMinMax(false);
                    if (max == null) {
                        max = mm.getMax();
                        continue;
                    }
                    max = Vector.max(max, mm.getMax());
                    continue;
                }
                if (!(m instanceof Wire)) continue;
                Wire w = (Wire)m;
                max = max == null ? Vector.max(w.p1, w.p2) : Vector.max(max, w.p1, w.p2);
            }
            if (max != null) {
                Vector delta = CircuitComponent.raster(this.lastPos.sub(max));
                for (Movable m : elements) {
                    m.move(delta);
                }
            }
            CircuitComponent.this.deleteAction.setEnabled(true);
            CircuitComponent.this.rotateAction.setEnabled(true);
        }

        @Override
        void moved(MouseEvent e) {
            if (this.elements != null) {
                Vector pos = CircuitComponent.this.getPosVector(e);
                Vector delta = CircuitComponent.raster(pos.sub(this.lastPos));
                if (delta.x != 0 || delta.y != 0) {
                    for (Movable m : this.elements) {
                        m.move(delta);
                    }
                    CircuitComponent.this.repaint();
                    this.lastPos = this.lastPos.add(delta);
                }
            }
        }

        @Override
        public int drawables() {
            if (this.elements == null) {
                return 0;
            }
            return this.elements.size();
        }

        @Override
        public void drawTo(Graphic gr) {
            if (this.elements != null) {
                for (Movable m : this.elements) {
                    if (!(m instanceof Drawable)) continue;
                    ((Drawable)((Object)m)).drawTo(gr, Style.HIGHLIGHT);
                }
            }
        }

        @Override
        public void delete() {
            CircuitComponent.this.mouseNormal.activate();
        }

        @Override
        void clicked(MouseEvent e) {
            if (this.elements != null && CircuitComponent.this.mouse.isPrimaryClick(e)) {
                Modifications.Builder<Circuit> builder = new Modifications.Builder<Circuit>(Lang.get("mod_insertCopied", new Object[0]));
                ArrayList<Wire> wires = new ArrayList<Wire>();
                for (Movable m : this.elements) {
                    if (m instanceof Wire) {
                        wires.add((Wire)m);
                    }
                    if (!(m instanceof VisualElement)) continue;
                    builder.add(new ModifyInsertElement((VisualElement)m));
                }
                builder.add(ModifyInsertWires.create(wires));
                CircuitComponent.this.modify(builder.build());
            }
            CircuitComponent.this.mouseNormal.activate();
        }

        @Override
        public void rotate() {
            ModifyMoveSelected.rotateElements(this.elements, CircuitComponent.raster(this.lastPos));
            CircuitComponent.this.graphicHasChanged();
        }

        @Override
        public void escapePressed() {
            CircuitComponent.this.mouseNormal.activate();
        }
    }

    private final class MouseControllerInsertElement
    extends MouseController {
        private VisualElement element;
        private Vector delta;
        private boolean minRaster;

        private MouseControllerInsertElement(Cursor cursor) {
            super(cursor);
        }

        private void activate(VisualElement element) {
            super.activate();
            this.element = element;
            this.delta = null;
            CircuitComponent.this.deleteAction.setEnabled(true);
            CircuitComponent.this.rotateAction.setEnabled(true);
            this.minRaster = CircuitComponent.this.needsMinRaster(element);
        }

        @Override
        void moved(MouseEvent e) {
            this.updateMousePos(CircuitComponent.this.getPosVector(e));
        }

        void updateMousePos(Vector pos) {
            if (this.delta == null) {
                GraphicMinMax minMax = this.element.getMinMax(false);
                this.delta = this.element.getPos().sub(minMax.getMax());
            }
            this.element.setPos(CircuitComponent.toMinRaster(pos.add(this.delta), this.minRaster));
            CircuitComponent.this.repaint();
        }

        @Override
        public void delete() {
            CircuitComponent.this.mouseNormal.activate();
        }

        @Override
        public void drawTo(Graphic gr) {
            if (this.delta != null) {
                this.element.drawTo(gr, Style.HIGHLIGHT);
            }
        }

        @Override
        void clicked(MouseEvent e) {
            if (CircuitComponent.this.mouse.isPrimaryClick(e) && !CircuitComponent.this.isLocked()) {
                CircuitComponent.this.modify(new ModifyInsertElement(this.element));
                CircuitComponent.this.insertWires(this.element);
            }
            if (!CircuitComponent.this.mouse.isClickModifier(e)) {
                CircuitComponent.this.mouseNormal.activate();
            }
        }

        @Override
        public void rotate() {
            this.element.rotate();
            CircuitComponent.this.repaint();
        }

        @Override
        public void escapePressed() {
            CircuitComponent.this.mouseNormal.activate();
        }
    }

    private final class MouseControllerMoveElement
    extends MouseController {
        private VisualElement visualElement;
        private Vector delta;
        private VisualElement originalVisualElement;
        private boolean minRaster;

        private MouseControllerMoveElement(Cursor cursor) {
            super(cursor);
        }

        private void activate(VisualElement visualElement, Vector pos) {
            super.activate();
            this.originalVisualElement = visualElement;
            this.visualElement = new VisualElement(visualElement);
            CircuitComponent.this.shallowCopy = CircuitComponent.this.getCircuit().createShallowCopy();
            CircuitComponent.this.shallowCopy.delete(visualElement);
            this.delta = this.originalVisualElement.getPos().sub(pos);
            CircuitComponent.this.deleteAction.setEnabled(true);
            CircuitComponent.this.rotateAction.setEnabled(true);
            CircuitComponent.this.copyAction.setEnabled(true);
            this.minRaster = CircuitComponent.this.needsMinRaster(visualElement);
            CircuitComponent.this.graphicHasChanged();
        }

        @Override
        void clicked(MouseEvent e) {
            if (!CircuitComponent.this.isLocked()) {
                this.visualElement.setPos(this.visualElement.getPos());
                if (!this.visualElement.getPos().equals(this.originalVisualElement.getPos()) || this.visualElement.getRotate() != this.originalVisualElement.getRotate()) {
                    CircuitComponent.this.modify(new ModifyMoveAndRotElement(this.originalVisualElement, this.visualElement.getPos(), this.visualElement.getRotate()));
                    CircuitComponent.this.insertWires(this.visualElement);
                }
            }
            CircuitComponent.this.mouseNormal.activate();
        }

        @Override
        void moved(MouseEvent e) {
            if (!CircuitComponent.this.isLocked()) {
                Vector pos = CircuitComponent.this.getPosVector(e);
                this.visualElement.setPos(CircuitComponent.toMinRaster(pos.add(this.delta), this.minRaster));
                CircuitComponent.this.repaint();
            }
        }

        @Override
        public void drawTo(Graphic gr) {
            this.visualElement.drawTo(gr, Style.HIGHLIGHT);
        }

        @Override
        public void delete() {
            if (!CircuitComponent.this.isLocked()) {
                CircuitComponent.this.getCircuit().delete(this.visualElement);
                CircuitComponent.this.isManualScale = true;
                CircuitComponent.this.modify(new ModifyDeleteElement(this.originalVisualElement));
                CircuitComponent.this.mouseNormal.activate();
            }
        }

        @Override
        public void rotate() {
            if (!CircuitComponent.this.isLocked()) {
                this.visualElement.rotate();
                CircuitComponent.this.repaint();
            }
        }

        @Override
        public void escapePressed() {
            CircuitComponent.this.mouseNormal.activate();
        }
    }

    private final class MouseControllerMoveSelected
    extends MouseController {
        private Circuit.RectContainer elements;
        private Vector lastPos;
        private Vector center;
        private Vector accumulatedDelta;
        private int accumulatedRotate;
        private Vector min;
        private Vector max;

        private MouseControllerMoveSelected(Cursor cursor) {
            super(cursor);
        }

        private void activate(Vector corner1, Vector corner2, Vector pos) {
            super.activate();
            CircuitComponent.this.rotateAction.setEnabled(true);
            this.lastPos = pos;
            this.center = CircuitComponent.raster(corner1.add(corner2).div(2));
            this.accumulatedDelta = new Vector(0, 0);
            this.accumulatedRotate = 0;
            this.min = Vector.min(corner1, corner2);
            this.max = Vector.max(corner1, corner2);
            this.elements = CircuitComponent.this.getCircuit().copyElementsInRect(this.min, this.max, CircuitComponent.this.library.getShapeFactory());
            if (this.elements == null) {
                CircuitComponent.this.mouseNormal.activate();
            } else {
                CircuitComponent.this.shallowCopy = CircuitComponent.this.getCircuit().createShallowCopy();
                CircuitComponent.this.shallowCopy.delete(this.min, this.max);
            }
            CircuitComponent.this.removeHighLighted();
        }

        @Override
        void moved(MouseEvent e) {
            this.lastPos = CircuitComponent.this.getPosVector(e);
        }

        @Override
        boolean dragged(MouseEvent e) {
            Vector pos = CircuitComponent.this.getPosVector(e);
            Vector delta = CircuitComponent.raster(pos.sub(this.lastPos));
            if (delta.x != 0 || delta.y != 0) {
                for (Movable m : this.elements.getMovables()) {
                    m.move(delta);
                }
                this.accumulatedDelta = this.accumulatedDelta.add(delta);
                CircuitComponent.this.repaint();
                this.lastPos = this.lastPos.add(delta);
                this.center = this.center.add(delta);
            }
            return true;
        }

        @Override
        void released(MouseEvent e) {
            if (this.accumulatedDelta.x != 0 || this.accumulatedDelta.y != 0 || this.accumulatedRotate != 0) {
                CircuitComponent.this.modify(new ModifyMoveSelected(this.min, this.max, this.accumulatedDelta, this.accumulatedRotate, this.center));
                CircuitComponent.this.getCircuit().elementsMoved();
            }
            CircuitComponent.this.mouseNormal.activate();
        }

        @Override
        public void escapePressed() {
            CircuitComponent.this.mouseNormal.activate();
        }

        @Override
        public void rotate() {
            ModifyMoveSelected.rotateElements(this.elements.getMovables(), this.center);
            CircuitComponent.this.repaint();
            ++this.accumulatedRotate;
        }

        @Override
        public int drawables() {
            return this.elements.getDrawables().size();
        }

        @Override
        public void drawTo(Graphic gr) {
            for (Drawable m : this.elements.getDrawables()) {
                m.drawTo(gr, Style.HIGHLIGHT);
            }
        }
    }

    private final class MouseControllerMoveWire
    extends MouseController {
        private Wire wire;
        private Vector pos;
        private Wire originalWire;

        private MouseControllerMoveWire(Cursor cursor) {
            super(cursor);
        }

        private void activate(Wire wire, Vector pos) {
            super.activate();
            this.originalWire = wire;
            CircuitComponent.this.shallowCopy = CircuitComponent.this.getCircuit().createShallowCopy();
            CircuitComponent.this.shallowCopy.delete(this.originalWire);
            this.wire = new Wire(wire);
            this.pos = CircuitComponent.raster(pos);
            CircuitComponent.this.deleteAction.setEnabled(true);
            CircuitComponent.this.removeHighLighted();
            CircuitComponent.this.graphicHasChanged();
        }

        @Override
        void clicked(MouseEvent e) {
            if (!this.originalWire.p1.equals(this.wire.p1)) {
                CircuitComponent.this.removeHighLighted();
                CircuitComponent.this.modify(new ModifyMoveWire(this.originalWire, this.wire));
                CircuitComponent.this.getCircuit().elementsMoved();
            }
            CircuitComponent.this.mouseNormal.activate();
        }

        @Override
        void moved(MouseEvent e) {
            Vector pos = CircuitComponent.raster(CircuitComponent.this.getPosVector(e));
            Vector delta = pos.sub(this.pos);
            if (!delta.isZero()) {
                this.wire.move(delta);
                this.wire.noDot();
                CircuitComponent.this.isManualScale = true;
                CircuitComponent.this.repaint();
            }
            this.pos = pos;
        }

        @Override
        public void delete() {
            CircuitComponent.this.getCircuit().delete(this.wire);
            CircuitComponent.this.isManualScale = true;
            CircuitComponent.this.modify(new ModifyDeleteWire(this.originalWire));
            CircuitComponent.this.mouseNormal.activate();
        }

        @Override
        public void drawTo(Graphic gr) {
            this.wire.drawTo(gr, Style.HIGHLIGHT);
        }

        @Override
        public void escapePressed() {
            CircuitComponent.this.mouseNormal.activate();
        }
    }

    private final class MouseControllerNormal
    extends MouseController {
        private Vector pos;
        private MouseEvent downButton;
        private VisualElement pressedElement;

        private MouseControllerNormal(Cursor cursor) {
            super(cursor);
        }

        @Override
        void activate() {
            super.activate();
            this.pos = null;
        }

        @Override
        void clicked(MouseEvent e) {
            Vector pos = CircuitComponent.this.getPosVector(e);
            if (CircuitComponent.this.mouse.isSecondaryClick(e)) {
                SearchResult sel = CircuitComponent.this.getVisualElement(pos, true);
                if (sel.getVisualElement() != null) {
                    CircuitComponent.this.editAttributes(sel.getVisualElement(), e);
                }
            } else if (CircuitComponent.this.mouse.isPrimaryClick(e) && CircuitComponent.this.hadFocusAtClick) {
                SearchResult sel = CircuitComponent.this.getVisualElement(pos, false);
                switch (sel.getState()) {
                    case FOUND: {
                        VisualElement vp = sel.getVisualElement();
                        if (vp.isPinPos(CircuitComponent.raster(pos)) && !CircuitComponent.this.mouse.isClickModifier(e)) {
                            if (CircuitComponent.this.isLocked()) break;
                            CircuitComponent.this.mouseWireRect.activate(pos);
                            break;
                        }
                        CircuitComponent.this.mouseMoveElement.activate(vp, pos);
                        break;
                    }
                    case NONE: {
                        if (CircuitComponent.this.isLocked()) break;
                        if (CircuitComponent.this.mouse.isClickModifier(e)) {
                            Wire wire = CircuitComponent.this.getCircuit().getWireAt(pos, 10);
                            if (wire == null) break;
                            CircuitComponent.this.mouseMoveWire.activate(wire, pos);
                            break;
                        }
                        CircuitComponent.this.mouseWireRect.activate(pos);
                    }
                }
            }
        }

        @Override
        void deactivate() {
            CircuitComponent.this.removeHighLighted();
        }

        @Override
        void pressed(MouseEvent e) {
            this.downButton = e;
            this.pos = CircuitComponent.this.getPosVector(e);
            this.pressedElement = CircuitComponent.this.getCircuit().getElementAt(this.pos, false);
        }

        @Override
        void released(MouseEvent e) {
            this.pressedElement = null;
        }

        @Override
        boolean dragged(MouseEvent e) {
            if (CircuitComponent.this.mouse.isPrimaryClick(this.downButton)) {
                Vector p = CircuitComponent.this.getPosVector(e);
                if (this.pos == null) {
                    this.pos = p;
                }
                if (this.pressedElement != null && this.pressedElement.equalsDescription(DummyElement.RECTDESCRIPTION)) {
                    CircuitComponent.this.mouseResizeRect.activate(this.pressedElement, this.pos);
                } else {
                    CircuitComponent.this.mouseSelect.activate(this.pos, p);
                }
                return true;
            }
            return !CircuitComponent.this.mouse.isSecondaryClick(this.downButton);
        }
    }

    private final class MouseControllerResizeRect
    extends MouseController {
        private VisualElement element;
        private Vector startPos;
        private int rectX;
        private int rectY;
        private int rectWidth;
        private int rectHeight;
        private boolean changeNorth;
        private boolean changeSouth;
        private boolean changeWest;
        private boolean changeEast;

        private MouseControllerResizeRect(Cursor cursor) {
            super(cursor);
        }

        void activate(VisualElement element, Vector pos) {
            super.activate();
            this.element = element;
            this.startPos = CircuitComponent.raster(pos);
            this.setCursorForResizingRect(element, pos);
            this.rectX = element.getPos().x;
            this.rectY = element.getPos().y;
            this.rectWidth = element.getElementAttributes().get(Keys.RECT_WIDTH) * 20;
            this.rectHeight = element.getElementAttributes().get(Keys.RECT_HEIGHT) * 20;
            Vector posInRect = CircuitComponent.raster(pos.sub(element.getPos()));
            this.changeNorth = posInRect.y <= 0;
            this.changeSouth = posInRect.y == this.rectHeight;
            this.changeEast = posInRect.x == 0;
            this.changeWest = posInRect.x == this.rectWidth;
        }

        public void setCursorForResizingRect(VisualElement rect, Vector pos) {
            Vector posInRect = CircuitComponent.raster(pos.sub(rect.getPos()));
            int width = rect.getElementAttributes().get(Keys.RECT_WIDTH) * 20;
            int height = rect.getElementAttributes().get(Keys.RECT_HEIGHT) * 20;
            int cursor = posInRect.x == width ? (posInRect.y <= 0 ? 7 : (posInRect.y == height ? 5 : 11)) : (posInRect.x == 0 ? (posInRect.y <= 0 ? 6 : (posInRect.y == height ? 4 : 10)) : (posInRect.y <= 0 ? 8 : 9));
            CircuitComponent.this.setCursor(new Cursor(cursor));
        }

        @Override
        boolean dragged(MouseEvent e) {
            ElementAttributes attributes = this.element.getElementAttributes();
            Vector d = CircuitComponent.raster(CircuitComponent.this.getPosVector(e)).sub(this.startPos);
            if (this.changeNorth) {
                this.rectY = this.element.getPos().y + d.y;
                this.rectHeight = attributes.get(Keys.RECT_HEIGHT) * 20 - d.y;
            } else if (this.changeSouth) {
                this.rectHeight = attributes.get(Keys.RECT_HEIGHT) * 20 + d.y;
            }
            if (this.changeEast) {
                this.rectX = this.element.getPos().x + d.x;
                this.rectWidth = attributes.get(Keys.RECT_WIDTH) * 20 - d.x;
            } else if (this.changeWest) {
                this.rectWidth = attributes.get(Keys.RECT_WIDTH) * 20 + d.x;
            }
            CircuitComponent.this.repaint();
            return true;
        }

        @Override
        void released(MouseEvent e) {
            if (this.rectWidth < 0) {
                this.rectWidth = -this.rectWidth;
                this.rectX -= this.rectWidth;
            }
            if (this.rectHeight < 0) {
                this.rectHeight = -this.rectHeight;
                this.rectY -= this.rectHeight;
            }
            this.rectWidth = Math.max(this.rectWidth, Keys.RECT_WIDTH.getMin() * 20);
            this.rectHeight = Math.max(this.rectHeight, Keys.RECT_HEIGHT.getMin() * 20);
            ElementAttributes newAttributes = new ElementAttributes(this.element.getElementAttributes()).set(Keys.RECT_WIDTH, this.rectWidth / 20).set(Keys.RECT_HEIGHT, this.rectHeight / 20);
            CircuitComponent.this.modify(new Modifications.Builder<Circuit>(Lang.get("mod_setAttributesIn_N", ModificationOfVisualElement.getToolTipName(this.element))).add(new ModifyAttributes(this.element, newAttributes)).add(new ModifyMoveAndRotElement(this.element, new Vector(this.rectX, this.rectY), this.element.getRotate())).build());
            CircuitComponent.this.mouseNormal.activate();
        }

        @Override
        public void drawTo(Graphic gr) {
            gr.drawPolygon(new Polygon(true).add(this.rectX, this.rectY).add(this.rectX + this.rectWidth, this.rectY).add(this.rectX + this.rectWidth, this.rectY + this.rectHeight).add(this.rectX, this.rectY + this.rectHeight), Style.HIGHLIGHT);
        }
    }

    private final class MouseControllerRun
    extends MouseController {
        private VisualElement draggedElement;

        private MouseControllerRun(Cursor cursor) {
            super(cursor);
        }

        @Override
        void pressed(MouseEvent e) {
            VisualElement ve = this.getInteractiveElementAt(e);
            if (ve != null) {
                this.interact(e, ve::elementPressed);
                this.draggedElement = ve;
            } else {
                this.draggedElement = null;
            }
        }

        private VisualElement getInteractiveElementAt(MouseEvent e) {
            Circuit circuit = CircuitComponent.this.getCircuitOrShallowCopy();
            List<VisualElement> elementList = circuit.getElementListAt(CircuitComponent.this.getPosVector(e), false);
            for (VisualElement ve : elementList) {
                if (!ve.isInteractive()) continue;
                return ve;
            }
            return null;
        }

        @Override
        void released(MouseEvent e) {
            if (this.draggedElement != null) {
                this.interact(e, (cc, pos, posInComponent, modelSync1) -> this.draggedElement.elementReleased(cc, pos, posInComponent, modelSync1));
                this.draggedElement = null;
            }
        }

        @Override
        void clicked(MouseEvent e) {
            VisualElement ve = this.getInteractiveElementAt(e);
            if (ve != null) {
                this.interact(e, ve::elementClicked);
            }
        }

        @Override
        boolean dragged(MouseEvent e) {
            if (this.draggedElement != null) {
                this.interact(e, (cc, pos, posInComponent, modelSync1) -> this.draggedElement.elementDragged(cc, pos, posInComponent, modelSync1));
                return true;
            }
            return false;
        }

        private void interact(MouseEvent e, Actor actor) {
            Point p = new Point(e.getX(), e.getY());
            SwingUtilities.convertPointToScreen(p, CircuitComponent.this);
            actor.interact(CircuitComponent.this, p, CircuitComponent.this.getPosVector(e), CircuitComponent.this.modelSync);
        }
    }

    private final class MouseControllerSelect
    extends MouseController {
        private static final int MIN_SIZE = 8;
        private Vector corner1;
        private Vector corner2;
        private boolean wasReleased;
        private boolean moveOnDragging;

        private MouseControllerSelect(Cursor cursor) {
            super(cursor);
        }

        private void activate(Vector corner1, Vector corner2) {
            super.activate();
            this.corner1 = corner1;
            this.corner2 = corner2;
            CircuitComponent.this.deleteAction.setEnabled(true);
            CircuitComponent.this.copyAction.setEnabled(true);
            CircuitComponent.this.cutAction.setEnabled(true);
            CircuitComponent.this.rotateAction.setEnabled(true);
            this.wasReleased = false;
            this.updateHighlighting();
        }

        @Override
        void clicked(MouseEvent e) {
            if (CircuitComponent.this.mouse.isPrimaryClick(e)) {
                CircuitComponent.this.mouseNormal.activate();
                CircuitComponent.this.removeHighLighted();
            } else if (CircuitComponent.this.mouse.isSecondaryClick(e)) {
                CircuitComponent.this.editGroup(Vector.min(this.corner1, this.corner2), Vector.max(this.corner1, this.corner2));
                CircuitComponent.this.mouseNormal.activate();
                CircuitComponent.this.removeHighLighted();
            }
        }

        @Override
        void released(MouseEvent e) {
            this.wasReleased = true;
            Vector dif = this.corner1.sub(this.corner2);
            if (Math.abs(dif.x) > 8 && Math.abs(dif.y) > 8) {
                CircuitComponent.this.setCursor(CircuitComponent.this.moveCursor);
            } else {
                CircuitComponent.this.removeHighLighted();
                CircuitComponent.this.mouseNormal.activate();
            }
        }

        @Override
        void pressed(MouseEvent e) {
            this.moveOnDragging = CircuitComponent.this.mouse.isPrimaryClick(e);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        boolean dragged(MouseEvent e) {
            if (this.wasReleased) {
                if (!this.moveOnDragging) return false;
                if (CircuitComponent.this.isLocked()) return true;
                CircuitComponent.this.mouseMoveSelected.activate(this.corner1, this.corner2, CircuitComponent.this.getPosVector(e));
                return true;
            } else {
                this.corner2 = CircuitComponent.this.getPosVector(e);
                if (CircuitComponent.this.mouse.isClickModifier(e)) {
                    int absDy;
                    Vector dif = this.corner2.sub(this.corner1);
                    int dx = dif.x;
                    int dy = dif.y;
                    int absDx = Math.abs(dx);
                    if (absDx != (absDy = Math.abs(dy))) {
                        if (absDx > absDy) {
                            dx = dx > absDy ? absDy : -absDy;
                        } else {
                            dy = dy > absDx ? absDx : -absDx;
                        }
                    }
                    this.corner2 = this.corner1.add(dx, dy);
                }
                this.updateHighlighting();
            }
            return true;
        }

        private void updateHighlighting() {
            ArrayList<Drawable> elements = CircuitComponent.this.getCircuit().getElementsToHighlight(Vector.min(this.corner1, this.corner2), Vector.max(this.corner1, this.corner2));
            CircuitComponent.this.removeHighLighted();
            if (elements != null) {
                CircuitComponent.this.addHighLighted(elements);
            }
            CircuitComponent.this.repaint();
        }

        public void release() {
            this.wasReleased = true;
        }

        @Override
        public void drawTo(Graphic gr) {
            Vector p1 = new Vector(this.corner1.x, this.corner2.y);
            Vector p2 = new Vector(this.corner2.x, this.corner1.y);
            gr.drawLine(this.corner1, p1, Style.DASH);
            gr.drawLine(p1, this.corner2, Style.DASH);
            gr.drawLine(p2, this.corner2, Style.DASH);
            gr.drawLine(this.corner1, p2, Style.DASH);
        }

        @Override
        public void delete() {
            if (!CircuitComponent.this.isLocked()) {
                CircuitComponent.this.isManualScale = true;
                CircuitComponent.this.modify(new ModifyDeleteRect(Vector.min(this.corner1, this.corner2), Vector.max(this.corner1, this.corner2)));
                CircuitComponent.this.mouseNormal.activate();
            }
        }

        @Override
        public void rotate() {
            if (!CircuitComponent.this.isLocked()) {
                CircuitComponent.this.mouseMoveSelected.activate(this.corner1, this.corner2, CircuitComponent.this.lastMousePos);
                CircuitComponent.this.mouseMoveSelected.rotate();
            }
        }

        @Override
        public void escapePressed() {
            CircuitComponent.this.removeHighLighted();
            CircuitComponent.this.mouseNormal.activate();
        }
    }

    private final class MouseControllerWireDiag
    extends MouseController {
        private Wire wire;

        private MouseControllerWireDiag(Cursor cursor) {
            super(cursor);
        }

        private void activate(Vector startPos, Vector endPos) {
            super.activate();
            this.wire = new Wire(CircuitComponent.raster(startPos), CircuitComponent.raster(endPos));
        }

        @Override
        void moved(MouseEvent e) {
            this.wire.setP2(CircuitComponent.raster(CircuitComponent.this.getPosVector(e)));
            CircuitComponent.this.repaint();
        }

        @Override
        void clicked(MouseEvent e) {
            if (CircuitComponent.this.mouse.isClickModifier(e)) {
                Vector pos = CircuitComponent.raster(CircuitComponent.this.getPosVector(e));
                Wire wire = CircuitComponent.this.getCircuit().getWireAt(pos, 10);
                if (wire != null) {
                    CircuitComponent.this.mouseMoveWire.activate(wire, pos);
                }
            } else if (CircuitComponent.this.mouse.isSecondaryClick(e)) {
                CircuitComponent.this.mouseNormal.activate();
            } else if (CircuitComponent.this.mouse.isPrimaryClick(e)) {
                boolean clickOnWire = CircuitComponent.this.getCircuit().isWireAt(this.wire.p2);
                CircuitComponent.this.modify(new ModifyInsertWire(this.wire).checkIfLenZero());
                if (clickOnWire || CircuitComponent.this.getCircuit().isPinPos(this.wire.p2)) {
                    CircuitComponent.this.mouseNormal.activate();
                } else {
                    CircuitComponent.this.mouseWireRect.activate(this.wire.p2);
                }
            }
        }

        @Override
        public void drawTo(Graphic gr) {
            this.wire.drawTo(gr, Style.HIGHLIGHT);
        }

        @Override
        public void escapePressed() {
            CircuitComponent.this.mouseNormal.activate();
        }

        private void rectangularWire() {
            CircuitComponent.this.mouseWireRect.activate(this.wire.p1, this.wire.p2);
        }
    }

    private final class MouseControllerWireRect
    extends MouseController {
        private Wire wire1;
        private Wire wire2;
        private boolean selectionMade;
        private boolean firstHorizontal;
        private Vector initialPos;
        private Vector lastPosition;

        private MouseControllerWireRect(Cursor cursor) {
            super(cursor);
        }

        private void activate(Vector startPos) {
            startPos = CircuitComponent.raster(startPos);
            this.activate(startPos, startPos);
            this.selectionMade = false;
        }

        private void activate(Vector startPos, Vector endPos) {
            super.activate();
            this.initialPos = CircuitComponent.raster(startPos);
            this.wire1 = new Wire(startPos, endPos);
            this.wire2 = new Wire(startPos, endPos);
            this.selectionMade = true;
            this.lastPosition = endPos;
            this.setWires();
        }

        @Override
        void moved(MouseEvent e) {
            this.lastPosition = CircuitComponent.raster(CircuitComponent.this.getPosVector(e));
            if (!this.selectionMade) {
                boolean dy;
                Vector delta = this.lastPosition.sub(this.initialPos);
                boolean dx = Math.abs(delta.x) > DRAG_DISTANCE;
                boolean bl = dy = Math.abs(delta.y) > DRAG_DISTANCE;
                if (dx || dy) {
                    this.firstHorizontal = dx;
                    this.selectionMade = true;
                }
            }
            this.setWires();
        }

        private void setWires() {
            Vector pm = this.firstHorizontal ? new Vector(this.lastPosition.x, this.wire1.p1.y) : new Vector(this.wire1.p1.x, this.lastPosition.y);
            this.wire1.setP2(pm);
            this.wire2.setP1(pm);
            this.wire2.setP2(this.lastPosition);
            CircuitComponent.this.repaint();
        }

        @Override
        void clicked(MouseEvent e) {
            if (CircuitComponent.this.mouse.isClickModifier(e)) {
                Vector pos = CircuitComponent.raster(CircuitComponent.this.getPosVector(e));
                Wire wire = CircuitComponent.this.getCircuit().getWireAt(pos, 10);
                if (wire != null) {
                    CircuitComponent.this.mouseMoveWire.activate(wire, pos);
                }
            } else if (CircuitComponent.this.mouse.isSecondaryClick(e)) {
                CircuitComponent.this.mouseNormal.activate();
            } else if (CircuitComponent.this.mouse.isPrimaryClick(e)) {
                boolean clickOnWire = CircuitComponent.this.getCircuit().isWireAt(this.wire2.p2);
                CircuitComponent.this.modify(new Modifications.Builder<Circuit>(Lang.get("mod_insertWire", new Object[0])).add(new ModifyInsertWire(this.wire1).checkIfLenZero()).add(new ModifyInsertWire(this.wire2).checkIfLenZero()).build());
                if (clickOnWire || CircuitComponent.this.getCircuit().isPinPos(this.wire2.p2)) {
                    CircuitComponent.this.mouseNormal.activate();
                } else {
                    this.initialPos = this.wire2.p2;
                    this.selectionMade = false;
                    this.wire1 = new Wire(this.wire2.p2, this.wire2.p2);
                    this.wire2 = new Wire(this.wire2.p2, this.wire2.p2);
                }
            }
        }

        @Override
        public void drawTo(Graphic gr) {
            this.wire1.drawTo(gr, Style.HIGHLIGHT);
            this.wire2.drawTo(gr, Style.HIGHLIGHT);
        }

        @Override
        public void escapePressed() {
            CircuitComponent.this.mouseNormal.activate();
        }

        void diagonalWire() {
            CircuitComponent.this.mouseWireDiag.activate(this.initialPos, this.wire2.p2);
            CircuitComponent.this.repaint();
        }

        private void flipWire() {
            this.selectionMade = true;
            this.firstHorizontal = !this.firstHorizontal;
            this.setWires();
        }
    }

    private final class MouseControllerWireSplit
    extends MouseController {
        private Wire wire1;
        private Wire wire2;
        private Wire origWire;

        private MouseControllerWireSplit(Cursor cursor) {
            super(cursor);
        }

        private void activate(Wire w, Vector startPos) {
            super.activate();
            startPos = CircuitComponent.raster(startPos);
            this.origWire = w;
            CircuitComponent.this.shallowCopy = CircuitComponent.this.getCircuit().createShallowCopy();
            CircuitComponent.this.shallowCopy.delete(w);
            this.wire1 = new Wire(w.p1, startPos);
            this.wire2 = new Wire(startPos, w.p2);
        }

        @Override
        void moved(MouseEvent e) {
            Vector p = CircuitComponent.raster(CircuitComponent.this.getPosVector(e));
            this.wire1.setP2(p);
            this.wire2.setP1(p);
            CircuitComponent.this.repaint();
        }

        @Override
        void clicked(MouseEvent e) {
            if (CircuitComponent.this.mouse.isPrimaryClick(e)) {
                Modifications.Builder<Circuit> m = new Modifications.Builder<Circuit>(Lang.get("mod_splitWire", new Object[0]));
                m.add(new ModifyDeleteWire(this.origWire));
                m.add(new ModifyInsertWire(this.wire1));
                m.add(new ModifyInsertWire(this.wire2));
                CircuitComponent.this.modify(m.build());
                CircuitComponent.this.mouseNormal.activate();
            } else if (CircuitComponent.this.mouse.isSecondaryClick(e)) {
                this.escapePressed();
            }
        }

        @Override
        public void escapePressed() {
            CircuitComponent.this.mouseNormal.activate();
        }

        @Override
        public void drawTo(Graphic gr) {
            this.wire1.drawTo(gr, Style.HIGHLIGHT);
            this.wire2.drawTo(gr, Style.HIGHLIGHT);
        }
    }

    private final class MouseControllerWizard
    extends MouseController {
        private final WizardNotification wizardNotification;

        private MouseControllerWizard(WizardNotification wizardNotification) {
            super(new Cursor(1));
            this.wizardNotification = wizardNotification;
        }

        @Override
        void clicked(MouseEvent e) {
            Vector pos = CircuitComponent.this.getPosVector(e);
            SearchResult sel = CircuitComponent.this.getVisualElement(pos, true);
            if (sel.getVisualElement() != null) {
                this.wizardNotification.notify(sel.getVisualElement());
            }
        }

        @Override
        public void escapePressed() {
            this.wizardNotification.closed();
            CircuitComponent.this.mouseNormal.activate();
        }
    }

    private class MouseDispatcher
    extends MouseAdapter
    implements MouseMotionListener {
        private Vector pos;
        private boolean isMoved;
        private int statusX;
        private int statusY;

        private MouseDispatcher() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            CircuitComponent.this.hadFocusAtClick = CircuitComponent.this.hasFocus() || CircuitComponent.this.parent.hasMouseFocus();
            this.pos = new Vector(e.getX(), e.getY());
            this.isMoved = false;
            CircuitComponent.this.requestFocusInWindow();
            CircuitComponent.this.activeMouseController.pressed(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            CircuitComponent.this.activeMouseController.released(e);
            if (!this.wasMoved(e) && !this.isMoved) {
                CircuitComponent.this.activeMouseController.clicked(e);
            }
        }

        private boolean wasMoved(MouseEvent e) {
            if (this.pos == null) {
                return false;
            }
            Vector d = new Vector(e.getX(), e.getY()).sub(this.pos);
            return Math.abs(d.x) > DRAG_DISTANCE || Math.abs(d.y) > DRAG_DISTANCE;
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (CircuitComponent.this.toolTipHighlighted) {
                CircuitComponent.this.removeHighLighted();
                CircuitComponent.this.toolTipHighlighted = false;
            }
            CircuitComponent.this.lastMousePos = new Vector(e.getX(), e.getY());
            if (CircuitComponent.this.getCircuit().getAttributes().get(Keys.IS_GENERIC).booleanValue()) {
                Vector p = CircuitComponent.this.getPosVector(e);
                int x = Math.round(p.getXFloat() / 20.0f);
                int y = Math.round(p.getYFloat() / 20.0f);
                if (x != this.statusX || y != this.statusY) {
                    CircuitComponent.this.getMain().setStatus("pos: " + x + ", " + y);
                    this.statusX = x;
                    this.statusY = y;
                }
            }
            CircuitComponent.this.activeMouseController.moved(e);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            CircuitComponent.this.lastMousePos = new Vector(e.getX(), e.getY());
            CircuitComponent.this.activeMouseController.moved(e);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            CircuitComponent.this.lastMousePos = new Vector(e.getX(), e.getY());
            if (this.wasMoved(e) || this.isMoved) {
                this.isMoved = true;
                if (!CircuitComponent.this.activeMouseController.dragged(e)) {
                    Vector newPos = new Vector(e.getX(), e.getY());
                    Vector delta = newPos.sub(this.pos);
                    double s = CircuitComponent.this.transform.getScaleX();
                    CircuitComponent.this.transform.translate((double)delta.x / s, (double)delta.y / s);
                    CircuitComponent.this.isManualScale = true;
                    if (CircuitComponent.this.circuitScrollPanel != null) {
                        CircuitComponent.this.circuitScrollPanel.transformChanged(CircuitComponent.this.transform);
                    }
                    this.pos = newPos;
                    CircuitComponent.this.graphicHasChanged();
                }
            }
        }
    }

    private final class PlusMinusAction
    extends ToolTipAction {
        private final int delta;

        private PlusMinusAction(int delta) {
            super("plusMinus");
            this.delta = delta;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            VisualElement ve;
            if (!CircuitComponent.this.isLocked() && (ve = CircuitComponent.this.getActualVisualElement()) != null) {
                try {
                    if (CircuitComponent.this.library.getElementType(ve.getElementName()).hasAttribute(Keys.INPUT_COUNT)) {
                        int number = ve.getElementAttributes().get(Keys.INPUT_COUNT) + this.delta;
                        if (number >= Keys.INPUT_COUNT.getMin() && number <= Keys.INPUT_COUNT.getMax()) {
                            CircuitComponent.this.modify(new ModifyAttribute<Integer>(ve, Keys.INPUT_COUNT, number));
                        }
                    } else if (ve.equalsDescription(Const.DESCRIPTION)) {
                        long v = ve.getElementAttributes().get(Keys.VALUE) + (long)this.delta;
                        CircuitComponent.this.modify(new ModifyAttribute<Long>(ve, Keys.VALUE, v &= Bits.mask(ve.getElementAttributes().getBits())));
                    }
                }
                catch (ElementNotFoundException elementNotFoundException) {
                    // empty catch block
                }
            }
        }
    }

    private static final class SearchResult {
        private final State state;
        private final VisualElement visualElement;

        private SearchResult(State state, VisualElement visualElement) {
            this.state = state;
            this.visualElement = visualElement;
        }

        private State getState() {
            return this.state;
        }

        private VisualElement getVisualElement() {
            return this.visualElement;
        }

        static enum State {
            NONE,
            FOUND,
            CANCELED;

        }
    }

    public static interface TutorialListener {
        public void modified(Modification<Circuit> var1);
    }

    public static interface WizardNotification {
        public void notify(VisualElement var1);

        public void closed();
    }
}

