/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.gui.components;

import de.neemann.digital.lang.Lang;
import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import javax.swing.event.ListDataListener;

public class ItemPicker<T>
extends JDialog {
    private final JList<T> list;
    private final List<T> items;
    private T selectedEntry = null;

    public ItemPicker(Window parent, List<T> items) {
        this(parent, Lang.get("win_itempicker_title", new Object[0]), items);
    }

    public ItemPicker(Window parent, String title, List<T> items) {
        super(parent, title, Dialog.ModalityType.APPLICATION_MODAL);
        this.items = items;
        this.setDefaultCloseOperation(2);
        this.list = new JList(new MyListModel(items));
        this.list.getInputMap().put(KeyStroke.getKeyStroke(27, 0), "myESC");
        this.list.getActionMap().put("myESC", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ItemPicker.this.dispose();
            }
        });
        this.list.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "myENTER");
        this.list.getActionMap().put("myENTER", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ItemPicker.this.setSelectedAsResult();
            }
        });
        this.list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    ItemPicker.this.setSelectedAsResult();
                }
            }
        });
        this.getContentPane().add(new JScrollPane(this.list));
        this.pack();
        this.setLocationRelativeTo(parent);
    }

    private void setSelectedAsResult() {
        int index = this.list.getSelectedIndex();
        if (index >= 0) {
            this.selectedEntry = this.items.get(index);
        }
        this.dispose();
    }

    public boolean showDialog() {
        this.setVisible(true);
        return this.selectedEntry != null;
    }

    public T getSelected() {
        return this.selectedEntry;
    }

    public T select() {
        if (this.showDialog()) {
            return this.getSelected();
        }
        return null;
    }

    private static final class MyListModel<T>
    implements ListModel<T> {
        private final List<T> items;

        private MyListModel(List<T> items) {
            this.items = items;
        }

        @Override
        public int getSize() {
            return this.items.size();
        }

        @Override
        public T getElementAt(int index) {
            return this.items.get(index);
        }

        @Override
        public void addListDataListener(ListDataListener l) {
        }

        @Override
        public void removeListDataListener(ListDataListener l) {
        }
    }
}

