/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.gui.components;

import de.neemann.digital.core.Bits;
import de.neemann.digital.core.IntFormat;
import de.neemann.digital.core.Model;
import de.neemann.digital.core.ModelEvent;
import de.neemann.digital.core.ModelEventType;
import de.neemann.digital.core.ModelStateObserverTyped;
import de.neemann.digital.core.ObservableValue;
import de.neemann.digital.core.SyncAccess;
import de.neemann.digital.core.Value;
import de.neemann.digital.core.ValueFormatter;
import de.neemann.digital.gui.components.ConstraintsBuilder;
import de.neemann.digital.lang.Lang;
import de.neemann.gui.Screen;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SpinnerModel;
import javax.swing.border.Border;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public final class SingleValueDialog
extends JDialog
implements ModelStateObserverTyped {
    private static final Format[] FORMATS;
    private static final Border SEPARATOR;
    private final ObservableValue value;
    private final SyncAccess syncAccess;
    private final JTextField textField;
    private boolean textIsModifying;
    private final boolean supportsHighZ;
    private final JComboBox<Format> formatComboBox;
    private final long mask;
    private JCheckBox[] checkBoxes;
    private Value editValue;
    private ValueFormatter valueFormatter = IntFormat.DEFAULT_FORMATTER;

    static {
        SEPARATOR = BorderFactory.createEmptyBorder(0, 0, 0, 5);
        ArrayList<Format> f = new ArrayList<Format>();
        IntFormat[] intFormatArray = IntFormat.values();
        int n = intFormatArray.length;
        int n2 = 0;
        while (n2 < n) {
            IntFormat intf = intFormatArray[n2];
            if (!intf.dependsOnAttributes()) {
                f.add(new Format(intf));
            }
            ++n2;
        }
        FORMATS = f.toArray(new Format[0]);
    }

    private static Format findFormat(ValueFormatter f) {
        Format[] formatArray = FORMATS;
        int n = FORMATS.length;
        int n2 = 0;
        while (n2 < n) {
            Format ff = formatArray[n2];
            if (ff.intFormat.createFormatter(null) == f) {
                return ff;
            }
            ++n2;
        }
        return null;
    }

    public SingleValueDialog(JFrame parent, Point pos, String label, ObservableValue value, boolean supportsHighZ, final Model model, SyncAccess syncAccess) {
        super(parent, Lang.get("win_valueInputTitle_N", label), false);
        this.setDefaultCloseOperation(2);
        this.value = value;
        this.syncAccess = syncAccess;
        this.editValue = value.getCopy();
        this.supportsHighZ = supportsHighZ;
        this.mask = Bits.mask(value.getBits());
        this.textField = new JTextField(10);
        this.textField.setHorizontalAlignment(4);
        this.formatComboBox = new JComboBox<Format>(FORMATS);
        this.formatComboBox.addActionListener(actionEvent -> {
            Format selectedItem = (Format)this.formatComboBox.getSelectedItem();
            if (selectedItem != null) {
                this.valueFormatter = selectedItem.intFormat.createFormatter(null);
                this.updateSeparators();
            }
            this.setLongToDialog(this.editValue);
        });
        JPanel checkBoxPanel = this.createCheckBoxPanel(this.editValue);
        model.addObserver(this);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                model.removeObserver(SingleValueDialog.this);
            }
        });
        JPanel panel = new JPanel(new GridBagLayout());
        JSpinner spinner = new JSpinner(new MySpinnerModel()){

            @Override
            protected JComponent createEditor(SpinnerModel spinnerModel) {
                return SingleValueDialog.this.textField;
            }
        };
        this.textField.getDocument().addDocumentListener(new MyDocumentListener(() -> this.setStringToDialog(this.textField.getText())));
        this.setLongToDialog(this.editValue);
        JButton okButton = new JButton(new AbstractAction(Lang.get("ok", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SingleValueDialog.this.apply();
                SingleValueDialog.this.dispose();
            }
        });
        AbstractAction applyAction = new AbstractAction(Lang.get("btn_apply", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SingleValueDialog.this.apply();
            }
        };
        JButton applyButton = new JButton(applyAction);
        ConstraintsBuilder constr = new ConstraintsBuilder().inset(3).dynamicWidth().fill();
        panel.add((Component)new JLabel(Lang.get("win_valueInputTitle_N", label)), constr);
        panel.add((Component)spinner, constr.x(1));
        panel.add((Component)applyButton, constr.x(2));
        constr.nextRow();
        panel.add((Component)new JLabel(Lang.get("key_intFormat", new Object[0])), constr);
        panel.add(this.formatComboBox, constr.x(1));
        panel.add((Component)okButton, constr.x(2));
        constr.nextRow();
        panel.add((Component)new JLabel(Lang.get("key_intFormat_bin", new Object[0])), constr);
        panel.add((Component)checkBoxPanel, constr.x(1));
        this.getContentPane().add(panel);
        this.textField.getInputMap().put(KeyStroke.getKeyStroke(10, 64, true), applyAction);
        this.textField.getActionMap().put(applyAction, applyAction);
        this.getRootPane().setDefaultButton(okButton);
        this.getRootPane().registerKeyboardAction(actionEvent -> this.dispose(), KeyStroke.getKeyStroke(27, 0), 2);
        this.updateSeparators();
        Screen.setLocation(this, pos, true);
        this.textField.requestFocus();
        this.textField.select(0, Integer.MAX_VALUE);
    }

    @Override
    public void requestFocus() {
        super.requestFocus();
        this.textField.requestFocus();
        this.textField.select(0, Integer.MAX_VALUE);
    }

    private void apply() {
        this.syncAccess.modify(() -> this.editValue.applyTo(this.value));
    }

    @Override
    public void handleEvent(ModelEvent event) {
        if (event.equals(ModelEvent.CLOSED)) {
            this.dispose();
        }
    }

    @Override
    public ModelEventType[] getEvents() {
        return new ModelEventType[]{ModelEventType.CLOSED};
    }

    private JPanel createCheckBoxPanel(Value value) {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        int bits = value.getBits();
        long l = value.getValue();
        this.checkBoxes = new JCheckBox[bits];
        int i = bits - 1;
        while (i >= 0) {
            int bit = i;
            this.checkBoxes[bit] = new JCheckBox("", (l & 1L << bit) != 0L);
            this.checkBoxes[bit].setBorder(null);
            this.checkBoxes[bit].addActionListener(actionEvent -> this.setBit(bit, this.checkBoxes[bit].isSelected()));
            p.add(this.checkBoxes[bit]);
            --i;
        }
        return p;
    }

    private void setBit(int bitNum, boolean set) {
        this.editValue = set ? new Value(this.editValue.getValue() | 1L << bitNum, this.editValue.getBits()) : new Value(this.editValue.getValue() & (1L << bitNum ^ 0xFFFFFFFFFFFFFFFFL), this.editValue.getBits());
        this.setLongToDialog(this.editValue);
    }

    private void setLongToDialog(Value editValue) {
        if (!this.textIsModifying) {
            this.textField.setText(this.valueFormatter.formatToEdit(editValue));
            this.textField.requestFocus();
        }
    }

    public SingleValueDialog setSelectedFormat(ValueFormatter format) {
        this.valueFormatter = format;
        this.formatComboBox.setSelectedItem(SingleValueDialog.findFormat(this.valueFormatter));
        this.setLongToDialog(this.editValue);
        this.updateSeparators();
        this.requestFocus();
        return this;
    }

    private void updateSeparators() {
        int bits = this.editValue.getBits();
        int i = 1;
        while (i < this.checkBoxes.length) {
            if (this.valueFormatter.isSeparatorInFrontOf(bits, i)) {
                this.checkBoxes[i].setBorder(SEPARATOR);
            } else {
                this.checkBoxes[i].setBorder(null);
            }
            ++i;
        }
        this.pack();
    }

    private void setStringToDialog(String text) {
        if ((text = text.trim()).equalsIgnoreCase("z") && this.supportsHighZ) {
            this.editValue = new Value(this.editValue.getBits());
        } else {
            try {
                this.editValue = new Value(Bits.decode(text, true), this.editValue.getBits());
            }
            catch (Bits.NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        long value = this.editValue.getValue();
        int i = 0;
        while (i < this.checkBoxes.length) {
            this.checkBoxes[i].setSelected((value & 1L << i) != 0L);
            ++i;
        }
    }

    private static final class Format {
        private final IntFormat intFormat;
        private final String name;

        private Format(IntFormat intFormat) {
            this.intFormat = intFormat;
            this.name = Lang.get("key_intFormat_" + intFormat.name(), new Object[0]);
        }

        public String toString() {
            return this.name;
        }
    }

    private final class MyDocumentListener
    implements DocumentListener {
        private final Runnable runnable;

        private MyDocumentListener(Runnable runnable) {
            this.runnable = runnable;
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.run();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.run();
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            this.run();
        }

        private void run() {
            SingleValueDialog.this.textIsModifying = true;
            this.runnable.run();
            SingleValueDialog.this.textIsModifying = false;
        }
    }

    private class MySpinnerModel
    implements SpinnerModel {
        private MySpinnerModel() {
        }

        @Override
        public Object getValue() {
            return SingleValueDialog.this.editValue;
        }

        @Override
        public void setValue(Object o) {
            if (o instanceof Number) {
                SingleValueDialog.this.editValue = new Value(((Number)o).longValue(), SingleValueDialog.this.editValue.getBits());
                SingleValueDialog.this.setLongToDialog(SingleValueDialog.this.editValue);
                SingleValueDialog.this.apply();
            }
        }

        @Override
        public Object getNextValue() {
            return SingleValueDialog.this.editValue.getValue() + 1L & SingleValueDialog.this.mask;
        }

        @Override
        public Object getPreviousValue() {
            return SingleValueDialog.this.editValue.getValue() - 1L & SingleValueDialog.this.mask;
        }

        @Override
        public void addChangeListener(ChangeListener changeListener) {
        }

        @Override
        public void removeChangeListener(ChangeListener changeListener) {
        }
    }
}

