/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.gui.components.data;

import de.neemann.digital.core.Model;
import de.neemann.digital.core.Observer;
import de.neemann.digital.core.Signal;
import de.neemann.digital.core.SyncAccess;
import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.data.ValueTable;
import de.neemann.digital.draw.graphics.ExportFactory;
import de.neemann.digital.draw.graphics.Graphic;
import de.neemann.digital.draw.graphics.GraphicMinMax;
import de.neemann.digital.draw.graphics.GraphicSVG;
import de.neemann.digital.gui.SaveAsHelper;
import de.neemann.digital.gui.Settings;
import de.neemann.digital.gui.components.OrderMerger;
import de.neemann.digital.gui.components.data.GraphComponent;
import de.neemann.digital.gui.components.data.ValueTableObserver;
import de.neemann.digital.gui.components.table.ShowStringDialog;
import de.neemann.digital.gui.components.testing.ValueTableDialog;
import de.neemann.digital.lang.Lang;
import de.neemann.gui.IconCreator;
import de.neemann.gui.MyFileChooser;
import de.neemann.gui.ToolTipAction;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JScrollBar;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileNameExtensionFilter;

public class GraphDialog
extends JDialog
implements Observer {
    private final GraphComponent graphComponent;
    private final ToolTipAction showTable;
    private static final Icon ICON_EXPAND = IconCreator.create("View-zoom-fit.png");
    private static final Icon ICON_ZOOM_IN = IconCreator.create("View-zoom-in.png");
    private static final Icon ICON_ZOOM_OUT = IconCreator.create("View-zoom-out.png");
    private ValueTable.ColumnInfo[] columnInfo;
    private final AtomicBoolean paintPending = new AtomicBoolean();

    public static GraphDialog createLiveDialog(JFrame owner, final Model model, boolean microStep, List<String> ordering, int sampleSize) {
        String title = microStep ? Lang.get("win_measures_microstep", new Object[0]) : Lang.get("win_measures_fullstep", new Object[0]);
        ArrayList<Signal> signals = model.getSignalsCopy();
        signals.removeIf(signal -> !signal.isShowInGraph());
        new OrderMerger<String, Signal>(ordering){

            @Override
            public boolean equals(Signal a, String b) {
                return a.getName().equals(b);
            }
        }.order(signals);
        final ValueTableObserver valueTableObserver = new ValueTableObserver(microStep, signals, sampleSize);
        GraphDialog graphDialog = new GraphDialog(owner, title, valueTableObserver.getLogData(), model, true).setColumnInfo(GraphDialog.createColumnsInfo(signals));
        graphDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                model.addObserver(valueTableObserver);
            }

            @Override
            public void windowClosed(WindowEvent e) {
                model.removeObserver(valueTableObserver);
            }
        });
        return graphDialog;
    }

    static ValueTable.ColumnInfo[] createColumnsInfo(ArrayList<Signal> signals) {
        ValueTable.ColumnInfo[] info = new ValueTable.ColumnInfo[signals.size()];
        int i = 0;
        while (i < signals.size()) {
            Signal s = signals.get(i);
            info[i] = new ValueTable.ColumnInfo(s.getFormat(), s.getValue().getBits());
            ++i;
        }
        return info;
    }

    public GraphDialog(Window owner, String title, ValueTable logData) {
        this(owner, title, logData, SyncAccess.NOSYNC, true);
    }

    GraphDialog(Window owner, final String title, final ValueTable logData, SyncAccess modelSync, boolean showHelp) {
        super(owner, title, Dialog.ModalityType.MODELESS);
        this.setDefaultCloseOperation(2);
        this.graphComponent = new GraphComponent(logData, modelSync);
        this.getContentPane().add(this.graphComponent);
        JScrollBar horizontalScrollBar = new JScrollBar(0);
        this.getContentPane().add((Component)horizontalScrollBar, "South");
        this.graphComponent.setHorizontalScrollBar(horizontalScrollBar);
        JScrollBar verticalScrollBar = new JScrollBar(1);
        this.getContentPane().add((Component)verticalScrollBar, "East");
        this.graphComponent.setVerticalScrollBar(verticalScrollBar);
        logData.addObserver(this);
        JToolBar toolBar = new JToolBar();
        ToolTipAction maximize = new ToolTipAction(Lang.get("menu_maximize", new Object[0]), ICON_EXPAND){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraphDialog.this.graphComponent.fitData();
            }
        }.setAccelerator("F1");
        ToolTipAction zoomIn = new ToolTipAction(Lang.get("menu_zoomIn", new Object[0]), ICON_ZOOM_IN){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraphDialog.this.graphComponent.scale(1.25, GraphDialog.this.getWidth() / 2);
            }
        }.setAcceleratorCTRLplus("PLUS");
        ToolTipAction zoomOut = new ToolTipAction(Lang.get("menu_zoomOut", new Object[0]), ICON_ZOOM_OUT){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraphDialog.this.graphComponent.scale(0.8f, GraphDialog.this.getWidth() / 2);
            }
        }.setAcceleratorCTRLplus("MINUS");
        this.showTable = new ToolTipAction(Lang.get("menu_showDataAsTable", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent e) {
                new ValueTableDialog((Window)GraphDialog.this, title).addValueTable(Lang.get("win_data", new Object[0]), logData).disableGraph().setVisible(true);
            }
        }.setToolTip(Lang.get("menu_showDataAsTable_tt", new Object[0]));
        toolBar.add(zoomIn.createJButtonNoText());
        toolBar.add(zoomOut.createJButtonNoText());
        toolBar.add(maximize.createJButtonNoText());
        this.getContentPane().add((Component)toolBar, "North");
        this.pack();
        JMenuBar bar = new JMenuBar();
        JMenu file = new JMenu(Lang.get("menu_file", new Object[0]));
        bar.add(file);
        file.add(new ToolTipAction(Lang.get("menu_saveData", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent e) {
                MyFileChooser fileChooser = new MyFileChooser();
                fileChooser.setFileFilter(new FileNameExtensionFilter("Comma Separated Values", "csv"));
                new SaveAsHelper(GraphDialog.this, fileChooser, "csv").checkOverwrite(file -> logData.saveCSV(file, GraphDialog.this.columnInfo));
            }
        }.setToolTip(Lang.get("menu_saveData_tt", new Object[0])).createJMenuItem());
        file.add(new ExportAction(Lang.get("menu_exportSVG", new Object[0]), GraphicSVG::new).createJMenuItem());
        JMenu view = new JMenu(Lang.get("menu_view", new Object[0]));
        bar.add(view);
        view.add(maximize.createJMenuItem());
        view.add(zoomOut.createJMenuItem());
        view.add(zoomIn.createJMenuItem());
        view.addSeparator();
        view.add(this.showTable.createJMenuItem());
        if (showHelp) {
            JMenu help = new JMenu(Lang.get("menu_help", new Object[0]));
            bar.add(help);
            help.add(new ToolTipAction(Lang.get("btn_help", new Object[0])){

                @Override
                public void actionPerformed(ActionEvent e) {
                    new ShowStringDialog((Window)GraphDialog.this, Lang.get("msg_graphHelpTitle", new Object[0]), Lang.get("msg_graphHelp", new Object[0]), true).setVisible(true);
                }
            }.createJMenuItem());
        }
        this.setJMenuBar(bar);
        this.pack();
        this.setLocationRelativeTo(owner);
    }

    GraphDialog setColumnInfo(ValueTable.ColumnInfo[] columnInfo) {
        this.columnInfo = columnInfo;
        return this;
    }

    @Override
    public void hasChanged() {
        if (this.paintPending.compareAndSet(false, true)) {
            SwingUtilities.invokeLater(() -> {
                this.graphComponent.revalidate();
                this.graphComponent.repaint();
                this.paintPending.set(false);
            });
        }
    }

    public GraphDialog disableTable() {
        this.showTable.setEnabled(false);
        return this;
    }

    private final class ExportAction
    extends ToolTipAction {
        private final ExportFactory factory;

        private ExportAction(String title, ExportFactory factory) {
            super(title);
            this.factory = factory;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MyFileChooser fileChooser = new MyFileChooser();
            ElementAttributes settings = Settings.getInstance().getAttributes();
            File exportDir = settings.getFile("exportDirectory");
            if (exportDir != null) {
                fileChooser.setCurrentDirectory(exportDir);
            }
            fileChooser.setFileFilter(new FileNameExtensionFilter("SVG", "svg"));
            new SaveAsHelper(GraphDialog.this, fileChooser, "svg").checkOverwrite(file -> {
                settings.setFile("exportDirectory", file.getParentFile());
                Throwable throwable = null;
                Object var4_5 = null;
                try (Graphic gr = this.factory.create(new FileOutputStream(file));){
                    GraphicMinMax minMax = new GraphicMinMax();
                    GraphDialog.this.graphComponent.getPlotter().drawTo(minMax, null);
                    gr.setBoundingBox(minMax.getMin(), minMax.getMax());
                    GraphDialog.this.graphComponent.getPlotter().drawTo(gr, null);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            });
        }
    }
}

