/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.gui.components.graphics;

import de.neemann.digital.core.Model;
import de.neemann.digital.core.ModelEventType;
import de.neemann.digital.core.Node;
import de.neemann.digital.core.NodeException;
import de.neemann.digital.core.ObservableValue;
import de.neemann.digital.core.ObservableValues;
import de.neemann.digital.core.element.Element;
import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.ElementTypeDescription;
import de.neemann.digital.core.element.Keys;
import de.neemann.digital.core.element.PinInfo;
import de.neemann.digital.core.memory.DataField;
import de.neemann.digital.core.memory.RAMInterface;
import de.neemann.digital.gui.components.graphics.GraphicDialog;
import java.awt.Window;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.SwingUtilities;

public class GraphicCard
extends Node
implements Element,
RAMInterface {
    public static final ElementTypeDescription DESCRIPTION = new ElementTypeDescription(GraphicCard.class, PinInfo.input("A"), PinInfo.input("str"), PinInfo.input("C").setClock(), PinInfo.input("ld"), PinInfo.input("B")).addAttribute(Keys.ROTATE).addAttribute(Keys.BITS).addAttribute(Keys.LABEL).addAttribute(Keys.GRAPHIC_WIDTH).addAttribute(Keys.GRAPHIC_HEIGHT);
    private final DataField memory;
    private final int width;
    private final int height;
    private final int bankSize;
    private GraphicDialog graphicDialog;
    private final int size;
    private final String label;
    private final int bits;
    private final int addrBits;
    private ObservableValue dataOut;
    private ObservableValue addrIn;
    private ObservableValue strIn;
    private ObservableValue clkIn;
    private ObservableValue ldIn;
    private ObservableValue dataIn;
    private ObservableValue bankIn;
    private boolean lastClk;
    private boolean ld;
    private int addr;
    private boolean lastBank;
    private boolean runningInMainFrame;
    private final AtomicBoolean paintPending = new AtomicBoolean();

    public GraphicCard(ElementAttributes attr) {
        this.label = attr.getLabel();
        this.width = attr.get(Keys.GRAPHIC_WIDTH);
        this.height = attr.get(Keys.GRAPHIC_HEIGHT);
        this.bankSize = this.width * this.height;
        this.bits = attr.get(Keys.BITS);
        this.size = this.bankSize * 2;
        int aBits = 1;
        while (1 << aBits < this.size) {
            ++aBits;
        }
        this.addrBits = aBits;
        this.memory = new DataField(this.size);
        this.dataOut = new ObservableValue("D", this.bits).setToHighZ().setPinDescription(DESCRIPTION).setBidirectional();
    }

    @Override
    public void setInputs(ObservableValues inputs) throws NodeException {
        this.addrIn = ((ObservableValue)inputs.get(0)).checkBits(this.addrBits, this).addObserverToValue(this);
        this.strIn = ((ObservableValue)inputs.get(1)).checkBits(1, this).addObserverToValue(this);
        this.clkIn = ((ObservableValue)inputs.get(2)).checkBits(1, this).addObserverToValue(this);
        this.ldIn = ((ObservableValue)inputs.get(3)).checkBits(1, this).addObserverToValue(this);
        this.bankIn = ((ObservableValue)inputs.get(4)).checkBits(1, this).addObserverToValue(this);
        this.dataIn = ((ObservableValue)inputs.get(5)).checkBits(this.bits, this).addObserverToValue(this);
    }

    @Override
    public ObservableValues getOutputs() {
        return this.dataOut.asList();
    }

    @Override
    public void readInputs() throws NodeException {
        boolean str;
        long data = 0L;
        boolean clk = this.clkIn.getBool();
        if (!this.lastClk && clk) {
            str = this.strIn.getBool();
            if (str) {
                data = this.dataIn.getValue();
            }
        } else {
            str = false;
        }
        this.ld = this.ldIn.getBool();
        if (this.ld || str) {
            this.addr = (int)this.addrIn.getValue();
        }
        boolean bank = this.bankIn.getBool();
        if (str) {
            this.memory.setData(this.addr, data);
            if (this.addr >= this.bankSize == bank) {
                this.updateGraphic(bank);
            }
        }
        if (this.lastBank != bank) {
            this.updateGraphic(bank);
        }
        this.lastBank = bank;
        this.lastClk = clk;
    }

    @Override
    public void writeOutputs() throws NodeException {
        if (this.ld) {
            this.dataOut.setValue(this.memory.getDataWord(this.addr));
        } else {
            this.dataOut.setToHighZ();
        }
    }

    @Override
    public void init(Model model) throws NodeException {
        model.addObserver(event -> {
            boolean bl = this.runningInMainFrame = model.runningInMainFrame();
        }, ModelEventType.STARTED, new ModelEventType[0]);
    }

    @Override
    public DataField getMemory() {
        return this.memory;
    }

    private void updateGraphic(boolean bank) {
        if (this.runningInMainFrame && this.paintPending.compareAndSet(false, true)) {
            SwingUtilities.invokeLater(() -> {
                if (this.graphicDialog == null || !this.graphicDialog.isVisible()) {
                    this.graphicDialog = new GraphicDialog((Window)this.getModel().getWindowPosManager().getMainFrame(), this.width, this.height);
                    this.getModel().getWindowPosManager().register("GraphicCard_" + this.label, this.graphicDialog);
                }
                this.paintPending.set(false);
                this.graphicDialog.updateGraphic(this.memory, bank);
            });
        }
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public int getDataBits() {
        return this.bits;
    }

    @Override
    public int getAddrBits() {
        return this.addrBits;
    }

    @Override
    public boolean isProgramMemory() {
        return false;
    }

    @Override
    public void setProgramMemory(DataField dataField) {
        this.memory.setDataFrom(dataField);
    }
}

