/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.gui.components.graphics;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JComponent;

public class GraphicComponent
extends JComponent {
    private static final Color[] PALETTE = GraphicComponent.createPalette();
    private final int width;
    private final int height;
    private long[] data;
    private int offs;

    public GraphicComponent(int width, int height) {
        int ph;
        this.width = width;
        this.height = height;
        int pw = 640 / width;
        if (pw < 1) {
            pw = 1;
        }
        if ((ph = 400 / height) < 1) {
            ph = 1;
        }
        int pixSize = (pw + ph) / 2;
        Dimension size = new Dimension(width * pixSize, height * pixSize);
        this.setPreferredSize(size);
        this.setOpaque(true);
    }

    public void updateGraphic(long[] data, boolean bank) {
        this.data = data;
        this.offs = bank ? this.width * this.height : 0;
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.data != null) {
            int x = 0;
            while (x < this.width) {
                int xPos = x * this.getWidth() / this.width;
                int dx = (x + 1) * this.getWidth() / this.width - xPos;
                int y = 0;
                while (y < this.height) {
                    int p = (int)this.data[this.offs + y * this.width + x];
                    if (p >= PALETTE.length) {
                        p = 1;
                    }
                    g.setColor(PALETTE[p]);
                    int ypos = y * this.getHeight() / this.height;
                    int dy = (y + 1) * this.getHeight() / this.height - ypos;
                    g.fillRect(xPos, ypos, dx, dy);
                    ++y;
                }
                ++x;
            }
        }
    }

    private static Color[] createPalette() {
        int b;
        int g;
        Color[] col = new Color[65536];
        int i = 0;
        while (i < col.length) {
            col[i] = Color.BLACK;
            ++i;
        }
        col[0] = Color.WHITE;
        col[1] = Color.BLACK;
        col[2] = Color.RED;
        col[3] = Color.GREEN;
        col[4] = Color.BLUE;
        col[5] = Color.YELLOW;
        col[6] = Color.CYAN;
        col[7] = Color.MAGENTA;
        col[8] = Color.ORANGE;
        col[9] = Color.PINK;
        int g2 = 0;
        while (g2 < 32) {
            int in = 255 - GraphicComponent.getComp(g2, 32);
            col[32 + g2] = new Color(in, in, in);
            ++g2;
        }
        int index = 64;
        int r = 0;
        while (r < 4) {
            g = 0;
            while (g < 4) {
                b = 0;
                while (b < 4) {
                    col[index] = new Color(GraphicComponent.getComp(r, 4), GraphicComponent.getComp(g, 4), GraphicComponent.getComp(b, 4));
                    ++index;
                    ++b;
                }
                ++g;
            }
            ++r;
        }
        index = 32768;
        r = 0;
        while (r < 32) {
            g = 0;
            while (g < 32) {
                b = 0;
                while (b < 32) {
                    col[index] = new Color(GraphicComponent.getComp(r, 32), GraphicComponent.getComp(g, 32), GraphicComponent.getComp(b, 32));
                    ++index;
                    ++b;
                }
                ++g;
            }
            ++r;
        }
        return col;
    }

    private static int getComp(int c, int values) {
        return 255 * c / (values - 1);
    }
}

