/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.gui.components.modification;

import de.neemann.digital.draw.elements.Circuit;
import de.neemann.digital.draw.elements.Wire;
import de.neemann.digital.draw.graphics.Vector;
import de.neemann.digital.undo.Modification;
import de.neemann.digital.undo.ModifyException;

public abstract class ModificationOfWire
implements Modification<Circuit> {
    private final Vector p1;
    private final String description;
    private final Vector p2;

    ModificationOfWire(Wire wire, String description) {
        this.description = description;
        this.p1 = wire.p1;
        this.p2 = wire.p2;
    }

    public String toString() {
        return this.description;
    }

    Wire getWire(Circuit circuit) throws ModifyException {
        for (Wire w : circuit.getWires()) {
            if (!w.p1.equals(this.p1) || !w.p2.equals(this.p2)) continue;
            return w;
        }
        throw new ModifyException("internal error: Wire not found!");
    }
}

