/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.gui.components.modification;

import de.neemann.digital.draw.elements.Circuit;
import de.neemann.digital.draw.elements.Wire;
import de.neemann.digital.draw.graphics.Vector;
import de.neemann.digital.gui.components.modification.ModifyInsertWire;
import de.neemann.digital.lang.Lang;
import de.neemann.digital.undo.Modification;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public final class ModifyInsertWires
implements Modification<Circuit> {
    private final ArrayList<LocalWire> wires;

    public static Modification<Circuit> create(List<Wire> newWires) {
        switch (newWires.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return new ModifyInsertWire(newWires.get(0));
            }
        }
        return new ModifyInsertWires(newWires);
    }

    private ModifyInsertWires(Collection<Wire> newWires) {
        this.wires = new ArrayList(newWires.size());
        for (Wire w : newWires) {
            this.wires.add(new LocalWire(w));
        }
    }

    @Override
    public void modify(Circuit circuit) {
        ArrayList<Wire> wl = new ArrayList<Wire>(this.wires.size());
        for (LocalWire w : this.wires) {
            wl.add(new Wire(w.p1, w.p2));
        }
        circuit.add(wl);
    }

    public String toString() {
        return Lang.get("mod_insertedWire", new Object[0]);
    }

    private static final class LocalWire {
        private final Vector p1;
        private final Vector p2;

        private LocalWire(Wire w) {
            this.p1 = w.p1;
            this.p2 = w.p2;
        }
    }
}

