/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.gui.components.table;

import de.neemann.digital.analyse.expression.Expression;
import de.neemann.digital.analyse.expression.ExpressionException;
import de.neemann.digital.analyse.expression.format.FormatterException;
import de.neemann.digital.analyse.expression.modify.ExpressionModifier;
import de.neemann.digital.builder.BuilderException;
import de.neemann.digital.builder.BuilderInterface;
import de.neemann.digital.gui.components.table.ExpressionListener;
import de.neemann.digital.gui.components.table.ExpressionListenerJK;
import de.neemann.digital.gui.components.table.ExpressionListenerOptimizeJK;
import de.neemann.digital.gui.components.table.ExpressionListenerStore;
import de.neemann.digital.lang.Lang;
import java.util.HashSet;

public class BuilderExpressionCreator {
    private final HashSet<String> contained = new HashSet();
    private final BuilderInterface builder;
    private final ExpressionModifier[] modifier;
    private boolean useJKOptimizer = false;

    public BuilderExpressionCreator(BuilderInterface builder, ExpressionModifier ... modifier) {
        this.builder = builder;
        this.modifier = modifier;
    }

    public void create(ExpressionListenerStore expressions) throws ExpressionException, FormatterException {
        if (expressions == null) {
            throw new ExpressionException(Lang.get("err_noExpressionsAvailable", new Object[0]));
        }
        ExpressionListener el = new ExpressionListener(){

            @Override
            public void resultFound(String name, Expression expression) throws FormatterException, ExpressionException {
                if (!BuilderExpressionCreator.this.contained.contains(name)) {
                    BuilderExpressionCreator.this.contained.add(name);
                    try {
                        String n = ExpressionListenerJK.isSequentialVar(name);
                        if (n != null) {
                            BuilderExpressionCreator.this.builder.addSequential(n, ExpressionModifier.modifyExpression(expression, BuilderExpressionCreator.this.modifier));
                        } else {
                            BuilderExpressionCreator.this.builder.addCombinatorial(name, ExpressionModifier.modifyExpression(expression, BuilderExpressionCreator.this.modifier));
                        }
                    }
                    catch (BuilderException e) {
                        throw new RuntimeException(e);
                    }
                }
            }

            @Override
            public void close() {
            }
        };
        if (this.useJKOptimizer) {
            el = new ExpressionListenerOptimizeJK(el);
        }
        expressions.replayTo(el);
        el.close();
    }

    public BuilderExpressionCreator setUseJKOptimizer(boolean useJKOptimizer) {
        this.useJKOptimizer = useJKOptimizer;
        return this;
    }
}

