/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.gui.components.table;

import de.neemann.digital.analyse.expression.ContextFiller;
import de.neemann.digital.analyse.expression.Expression;
import de.neemann.digital.analyse.expression.ExpressionException;
import de.neemann.digital.analyse.expression.Variable;
import de.neemann.digital.analyse.expression.format.FormatterException;
import de.neemann.digital.analyse.quinemc.BoolTable;
import de.neemann.digital.analyse.quinemc.ThreeStateValue;
import de.neemann.digital.gui.components.table.ExpressionListener;
import de.neemann.digital.lang.Lang;
import java.util.List;

public class CheckResultListener
implements ExpressionListener {
    private final ExpressionListener listener;
    private final List<Variable> variables;
    private final BoolTable boolTable;

    public CheckResultListener(ExpressionListener listener, List<Variable> variables, BoolTable boolTable) throws ExpressionException {
        this.listener = listener;
        this.variables = variables;
        this.boolTable = boolTable;
        int n = 1 << variables.size();
        if (n != boolTable.size()) {
            throw new ExpressionException(Lang.get("err_exact_N0_valuesNecessaryNot_N1", n, boolTable.size()));
        }
    }

    @Override
    public void resultFound(String name, Expression expression) throws FormatterException, ExpressionException {
        this.listener.resultFound(name, expression);
        ContextFiller cf = new ContextFiller(this.variables);
        int i = 0;
        while (i < this.boolTable.size()) {
            this.check(this.boolTable.get(i), expression.calculate(cf.setContextTo(i)));
            ++i;
        }
    }

    private void check(ThreeStateValue threeStateValue, boolean calculate) throws ExpressionException {
        switch (threeStateValue) {
            case dontCare: {
                return;
            }
            case one: {
                if (calculate) break;
                throw new ExpressionException(Lang.get("err_minimizationFailed", new Object[0]));
            }
            case zero: {
                if (!calculate) break;
                throw new ExpressionException(Lang.get("err_minimizationFailed", new Object[0]));
            }
        }
    }

    @Override
    public void close() throws FormatterException, ExpressionException {
        this.listener.close();
    }
}

