/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.gui.components.table;

import de.neemann.digital.analyse.DetermineJKStateMachine;
import de.neemann.digital.analyse.expression.Expression;
import de.neemann.digital.analyse.expression.ExpressionException;
import de.neemann.digital.analyse.expression.format.FormatterException;
import de.neemann.digital.gui.components.table.ExpressionListener;
import de.neemann.digital.gui.components.table.ExpressionListenerJK;

public class ExpressionListenerOptimizeJK
implements ExpressionListener {
    private final ExpressionListener parent;
    private String lastName;
    private Expression lastExpression;
    private int lastComplexity;

    public ExpressionListenerOptimizeJK(ExpressionListener parent) {
        this.parent = parent;
    }

    @Override
    public void resultFound(String name, Expression expression) throws FormatterException, ExpressionException {
        String varName = ExpressionListenerJK.isSequentialVar(name);
        if (varName != null) {
            if (name.equals(this.lastName)) {
                int c = new DetermineJKStateMachine(varName, expression).getComplexity();
                if (c < this.lastComplexity) {
                    this.lastName = name;
                    this.lastExpression = expression;
                    this.lastComplexity = c;
                }
            } else {
                this.handlePending();
                this.lastName = name;
                this.lastExpression = expression;
                this.lastComplexity = new DetermineJKStateMachine(varName, expression).getComplexity();
            }
        } else {
            this.handlePending();
            this.parent.resultFound(name, expression);
        }
    }

    private void handlePending() throws FormatterException, ExpressionException {
        if (this.lastName != null) {
            this.parent.resultFound(this.lastName, this.lastExpression);
            this.lastName = null;
        }
    }

    @Override
    public void close() throws FormatterException, ExpressionException {
        this.handlePending();
        this.parent.close();
    }
}

