/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.gui.components.table;

import de.neemann.digital.analyse.TruthTable;
import de.neemann.digital.analyse.expression.ExpressionException;
import de.neemann.digital.gui.components.ElementOrderer;
import de.neemann.digital.lang.Lang;
import java.util.ArrayList;

public class ReorderOutputs {
    private final TruthTable table;
    private final ArrayList<String> names;

    public ReorderOutputs(TruthTable table, ArrayList<String> names) {
        this.table = table;
        this.names = names;
    }

    public ReorderOutputs(TruthTable table) {
        this.table = table;
        this.names = new ArrayList();
        int i = 0;
        while (i < table.getResultCount()) {
            this.names.add(table.getResultName(i));
            ++i;
        }
    }

    public ElementOrderer.OrderInterface<String> getItems() {
        return new ElementOrderer.ListOrder<String>(this.names);
    }

    public void reorder() throws ExpressionException {
        TruthTable oldTable = this.table.createDeepCopy();
        this.table.clear(oldTable.getVars());
        block0: for (String name : this.names) {
            int i = 0;
            while (i < oldTable.getResultCount()) {
                if (oldTable.getResultName(i).equals(name)) {
                    this.table.addResult(oldTable.getResultName(i), oldTable.getResult(i));
                    continue block0;
                }
                ++i;
            }
        }
        if (this.table.getResultCount() < 1) {
            throw new ExpressionException(Lang.get("err_oneResultIsRequired", new Object[0]));
        }
    }
}

