/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.gui.components.table;

import de.neemann.digital.analyse.AnalyseException;
import de.neemann.digital.analyse.ModelAnalyser;
import de.neemann.digital.analyse.ModelAnalyserInfo;
import de.neemann.digital.analyse.TruthTable;
import de.neemann.digital.analyse.TruthTableTableModel;
import de.neemann.digital.analyse.expression.Expression;
import de.neemann.digital.analyse.expression.ExpressionException;
import de.neemann.digital.analyse.expression.NamedExpression;
import de.neemann.digital.analyse.expression.Variable;
import de.neemann.digital.analyse.expression.format.FormatterException;
import de.neemann.digital.analyse.expression.modify.ExpressionModifier;
import de.neemann.digital.analyse.expression.modify.NAnd;
import de.neemann.digital.analyse.expression.modify.NInputs;
import de.neemann.digital.analyse.expression.modify.NOr;
import de.neemann.digital.analyse.format.TruthTableFormatterCSV;
import de.neemann.digital.analyse.format.TruthTableFormatterHex;
import de.neemann.digital.analyse.format.TruthTableFormatterTestCase;
import de.neemann.digital.analyse.quinemc.BoolTableByteArray;
import de.neemann.digital.builder.ATF150x.ATFDevice;
import de.neemann.digital.builder.ExpressionToFileExporter;
import de.neemann.digital.builder.Gal16v8.CuplExporter;
import de.neemann.digital.builder.Gal16v8.Gal16v8JEDECExporter;
import de.neemann.digital.builder.Gal22v10.Gal22v10CuplExporter;
import de.neemann.digital.builder.Gal22v10.Gal22v10JEDECExporter;
import de.neemann.digital.builder.circuit.CircuitBuilder;
import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.Key;
import de.neemann.digital.core.element.Keys;
import de.neemann.digital.draw.elements.Circuit;
import de.neemann.digital.draw.graphics.text.ParseException;
import de.neemann.digital.draw.graphics.text.Parser;
import de.neemann.digital.draw.graphics.text.formatter.PlainTextFormatter;
import de.neemann.digital.draw.library.ElementLibrary;
import de.neemann.digital.draw.shapes.ShapeFactory;
import de.neemann.digital.gui.Main;
import de.neemann.digital.gui.SaveAsHelper;
import de.neemann.digital.gui.components.AttributeDialog;
import de.neemann.digital.gui.components.ElementOrderer;
import de.neemann.digital.gui.components.karnaugh.KarnaughMapDialog;
import de.neemann.digital.gui.components.table.AllSolutionsDialog;
import de.neemann.digital.gui.components.table.BuilderExpressionCreator;
import de.neemann.digital.gui.components.table.ExpressionComponent;
import de.neemann.digital.gui.components.table.ExpressionCreator;
import de.neemann.digital.gui.components.table.ExpressionListener;
import de.neemann.digital.gui.components.table.ExpressionListenerCSVCondensed;
import de.neemann.digital.gui.components.table.ExpressionListenerJK;
import de.neemann.digital.gui.components.table.ExpressionListenerStore;
import de.neemann.digital.gui.components.table.LaTeXExpressionListener;
import de.neemann.digital.gui.components.table.PlainTextExpressionListener;
import de.neemann.digital.gui.components.table.ProgressDialog;
import de.neemann.digital.gui.components.table.ReorderInputs;
import de.neemann.digital.gui.components.table.ReorderOutputs;
import de.neemann.digital.gui.components.table.ShowStringDialog;
import de.neemann.digital.gui.components.table.TableReorderManager;
import de.neemann.digital.gui.components.table.hardware.GenerateCUPL;
import de.neemann.digital.gui.components.table.hardware.GenerateFile;
import de.neemann.digital.gui.components.table.hardware.HardwareDescriptionGenerator;
import de.neemann.digital.lang.Lang;
import de.neemann.digital.undo.ModifyException;
import de.neemann.digital.undo.UndoManager;
import de.neemann.gui.ErrorMessage;
import de.neemann.gui.Mouse;
import de.neemann.gui.MyFileChooser;
import de.neemann.gui.Screen;
import de.neemann.gui.ToolTipAction;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableDialog
extends JDialog {
    private static final Logger LOGGER = LoggerFactory.getLogger(TableDialog.class);
    private static final Preferences PREFS = Preferences.userRoot().node("dig").node("generator");
    private static final Color MYGRAY = new Color(230, 230, 230);
    private static final Color ODDWHITE = new Color(255, 255, 220);
    private static final List<Key> LIST = new ArrayList<Key>();
    private final ExpressionComponent statusBar;
    private final JTable table;
    private final Font font;
    private final ElementLibrary library;
    private final ShapeFactory shapeFactory;
    private final ToolTipAction karnaughMenuAction;
    private final HashMap<String, HardwareDescriptionGenerator> availGenerators = new HashMap();
    private final JMenu hardwareMenu;
    private final TruthTableTableModel model;
    private final AllSolutionsDialog allSolutionsDialog;
    private final KarnaughMapDialog kvMap;
    private final Mouse mouse = Mouse.getMouse();
    private final UndoManager<TruthTable> undoManager;
    private JCheckBoxMenuItem createJK;
    private File filename;
    private int columnIndex;
    private ExpressionListenerStore lastGeneratedExpressions;
    private JMenuItem lastUsedGenratorMenuItem;

    static {
        LIST.add(Keys.LABEL);
    }

    public static void openFile(File file) {
        try {
            TruthTable tt = TruthTable.readFromFile(file);
            ElementLibrary library = new ElementLibrary();
            new ShapeFactory(library);
            SwingUtilities.invokeLater(() -> new TableDialog(null, tt, library, file).setVisible(true));
        }
        catch (IOException e) {
            new ErrorMessage().addCause(e).show();
        }
    }

    public TableDialog(Window parent, TruthTable truthTable, ElementLibrary library, File filename) {
        super(parent, Lang.get("win_table", new Object[0]));
        this.undoManager = new UndoManager<TruthTable>(truthTable);
        this.library = library;
        this.shapeFactory = library.getShapeFactory();
        this.filename = filename;
        this.setDefaultCloseOperation(2);
        this.model = new TruthTableTableModel(this.undoManager);
        this.model.addTableModelListener(new CalculationTableModelListener());
        this.kvMap = new KarnaughMapDialog(this, this.model::incValue);
        this.statusBar = new ExpressionComponent();
        this.font = Screen.getInstance().getFont(1.66f);
        this.statusBar.setFont(this.font);
        this.table = new JTable(this.model);
        JComboBox<String> comboBox = new JComboBox<String>(TruthTableTableModel.STATENAMES);
        this.table.setDefaultEditor(Integer.class, new DefaultCellEditor(comboBox));
        this.table.setDefaultRenderer(Integer.class, new CenterDefaultTableCellRenderer());
        this.table.getTableHeader().setDefaultRenderer(new StringDefaultTableCellRenderer());
        this.table.setRowHeight(this.font.getSize() * 6 / 5);
        this.table.getInputMap().put(KeyStroke.getKeyStroke("0"), "0_ACTION");
        this.table.getActionMap().put("0_ACTION", new SetAction(0));
        this.table.getInputMap().put(KeyStroke.getKeyStroke("1"), "1_ACTION");
        this.table.getActionMap().put("1_ACTION", new SetAction(1));
        this.table.getInputMap().put(KeyStroke.getKeyStroke("X"), "X_ACTION");
        this.table.getActionMap().put("X_ACTION", new SetAction(2));
        new TableReorderManager(this, this.table);
        this.allSolutionsDialog = new AllSolutionsDialog(this, this.font);
        final JTableHeader header = this.table.getTableHeader();
        header.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                if (TableDialog.this.mouse.isSecondaryClick(event)) {
                    TableDialog.this.columnIndex = header.columnAtPoint(event.getPoint());
                    if (TableDialog.this.columnIndex != -1) {
                        TableDialog.this.editColumnName(TableDialog.this.columnIndex, new Point(event.getXOnScreen(), event.getYOnScreen()));
                    }
                }
            }
        });
        JMenuBar bar = new JMenuBar();
        bar.add(this.createFileMenu());
        JMenu sizeMenu = new JMenu(Lang.get("menu_table_new", new Object[0]));
        JMenu combinatorial = new JMenu(Lang.get("menu_table_new_combinatorial", new Object[0]));
        sizeMenu.add(combinatorial);
        int i = 2;
        while (i <= 8) {
            combinatorial.add(new JMenuItem(new SizeAction(i)));
            ++i;
        }
        JMenu sequential = new JMenu(Lang.get("menu_table_new_sequential", new Object[0]));
        sizeMenu.add(sequential);
        int i2 = 2;
        while (i2 <= 8) {
            sequential.add(new JMenuItem(new SizeSequentialAction(i2)));
            ++i2;
        }
        if (Main.isExperimentalMode()) {
            JMenu sequentialBiDir = new JMenu(Lang.get("menu_table_new_sequential_bidir", new Object[0]));
            sizeMenu.add(sequentialBiDir);
            int i3 = 2;
            while (i3 <= 8) {
                sequentialBiDir.add(new JMenuItem(new SizeSequentialBidirectionalAction(i3)));
                ++i3;
            }
        }
        bar.add(sizeMenu);
        JMenu edit = new JMenu(Lang.get("menu_edit", new Object[0]));
        bar.add(edit);
        this.addUndoRedo(edit);
        edit.addSeparator();
        edit.add(new ToolTipAction(Lang.get("menu_table_reorder_inputs", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent e) {
                ArrayList<String> varNames = ((TruthTable)TableDialog.this.undoManager.getActual()).getVarNames();
                if (new ElementOrderer<String>((Window)TableDialog.this, Lang.get("menu_table_reorder_inputs", new Object[0]), new ElementOrderer.ListOrder<String>(varNames)).addDeleteButton(2).addOkButton().showDialog()) {
                    try {
                        TableDialog.this.undoManager.apply(tt -> {
                            try {
                                new ReorderInputs((TruthTable)tt, varNames).reorder();
                            }
                            catch (ExpressionException ex) {
                                throw new ModifyException("failed to reorder", ex);
                            }
                        });
                        TableDialog.this.tableChanged();
                    }
                    catch (ModifyException e1) {
                        new ErrorMessage().addCause(e1).show(TableDialog.this);
                    }
                }
            }
        }.createJMenuItem());
        edit.add(new ToolTipAction(Lang.get("menu_table_columnsAddVariable", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    TableDialog.this.undoManager.apply(TruthTable::addVariable);
                    TableDialog.this.tableChanged();
                }
                catch (ModifyException e) {
                    new ErrorMessage().addCause(e).show(TableDialog.this);
                }
            }
        }.setToolTip(Lang.get("menu_table_columnsAddVariable_tt", new Object[0])).createJMenuItem());
        edit.add(new ToolTipAction(Lang.get("menu_table_reorder_outputs", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent e) {
                ArrayList<String> resultNames = ((TruthTable)TableDialog.this.undoManager.getActual()).getResultNames();
                if (new ElementOrderer<String>((Window)TableDialog.this, Lang.get("menu_table_reorder_outputs", new Object[0]), new ElementOrderer.ListOrder<String>(resultNames)).addDeleteButton(1).addOkButton().showDialog()) {
                    try {
                        TableDialog.this.undoManager.apply(tt -> {
                            try {
                                new ReorderOutputs((TruthTable)tt, resultNames).reorder();
                            }
                            catch (ExpressionException ex) {
                                throw new ModifyException("failed to reorder", ex);
                            }
                        });
                        TableDialog.this.tableChanged();
                    }
                    catch (ModifyException e1) {
                        new ErrorMessage().addCause(e1).show(TableDialog.this);
                    }
                }
            }
        }.createJMenuItem());
        edit.add(new ToolTipAction(Lang.get("menu_table_columnsAdd", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    TableDialog.this.undoManager.apply(TruthTable::addResult);
                    TableDialog.this.tableChanged();
                }
                catch (ModifyException e) {
                    new ErrorMessage().addCause(e).show(TableDialog.this);
                }
            }
        }.setToolTip(Lang.get("menu_table_columnsAdd_tt", new Object[0])).createJMenuItem());
        edit.addSeparator();
        this.createSetMenuEntries(edit);
        this.hardwareMenu = this.createCreateMenu();
        bar.add(this.hardwareMenu);
        this.checkLastUsedGenerator();
        JMenu karnaughMenu = new JMenu(Lang.get("menu_karnaughMap", new Object[0]));
        this.karnaughMenuAction = new ToolTipAction(Lang.get("menu_karnaughMap", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TableDialog.this.kvMap.setVisible(true);
            }
        }.setToolTip(Lang.get("menu_karnaughMap_tt", new Object[0])).setAccelerator("F1");
        karnaughMenu.add(this.karnaughMenuAction.createJMenuItem());
        bar.add(karnaughMenu);
        this.setJMenuBar(bar);
        this.karnaughMenuAction.setEnabled(this.undoManager.getActual().getVars().size() <= 4);
        this.calculateExpressions();
        this.getContentPane().add(new JScrollPane(this.table));
        this.getContentPane().add((Component)this.statusBar, "South");
        this.pack();
        this.setLocationRelativeTo(parent);
    }

    private void addUndoRedo(JMenu edit) {
        ToolTipAction undo = new ToolTipAction(Lang.get("menu_undo", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (TableDialog.this.undoManager.undoAvailable()) {
                    try {
                        TableDialog.this.undoManager.undo();
                        TableDialog.this.tableChanged();
                    }
                    catch (ModifyException e) {
                        new ErrorMessage().addCause(e).show(TableDialog.this);
                    }
                }
            }
        }.setAcceleratorCTRLplus("Z");
        ToolTipAction redo = new ToolTipAction(Lang.get("menu_redo", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (TableDialog.this.undoManager.redoAvailable()) {
                    try {
                        TableDialog.this.undoManager.redo();
                        TableDialog.this.tableChanged();
                    }
                    catch (ModifyException e) {
                        new ErrorMessage().addCause(e).show(TableDialog.this);
                    }
                }
            }
        }.setAcceleratorCTRLplus("Y");
        edit.add(undo.createJMenuItem());
        edit.add(redo.createJMenuItem());
        this.undoManager.addListener(() -> {
            undo.setEnabled(this.undoManager.undoAvailable());
            redo.setEnabled(this.undoManager.redoAvailable());
            if (this.undoManager.isModified()) {
                this.setTitle("*" + Lang.get("win_table", new Object[0]));
            } else {
                this.setTitle(Lang.get("win_table", new Object[0]));
            }
        }).hasChanged();
    }

    public void tableChanged() {
        this.karnaughMenuAction.setEnabled(this.undoManager.getActual().getVars().size() <= 4);
        this.calculateExpressions();
        this.model.fireTableChanged();
    }

    private void editColumnName(int columnIndex, Point pos) {
        String newName;
        ElementAttributes attr = new ElementAttributes();
        String name = this.model.getColumnName(columnIndex);
        attr.set(Keys.LABEL, name);
        ElementAttributes modified = new AttributeDialog((Window)this, pos, LIST, attr).showDialog();
        if (modified != null && !(newName = modified.get(Keys.LABEL).trim().replace(' ', '-')).equals(name)) {
            this.model.setColumnName(columnIndex, newName);
        }
    }

    private JMenu createFileMenu() {
        JMenu fileMenu = new JMenu(Lang.get("menu_file", new Object[0]));
        fileMenu.add(new ToolTipAction(Lang.get("menu_open", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent e) {
                MyFileChooser fc = new MyFileChooser();
                if (TableDialog.this.filename != null) {
                    fc.setSelectedFile(SaveAsHelper.checkSuffix(TableDialog.this.filename, "tru"));
                }
                fc.setFileFilter(new FileNameExtensionFilter(Lang.get("msg_truthTableCSV", new Object[0]), "csv"));
                fc.setFileFilter(new FileNameExtensionFilter(Lang.get("msg_truthTable", new Object[0]), "tru"));
                if (fc.showOpenDialog(TableDialog.this) == 0) {
                    try {
                        File file = fc.getSelectedFile();
                        TruthTable truthTable = TruthTable.readFromFile(file);
                        TableDialog.this.undoManager.setInitial(truthTable);
                        TableDialog.this.tableChanged();
                        TableDialog.this.filename = file;
                    }
                    catch (IOException e1) {
                        new ErrorMessage().addCause(e1).show(TableDialog.this);
                    }
                }
            }
        });
        fileMenu.add(new ToolTipAction(Lang.get("menu_save", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent e) {
                MyFileChooser fc = new MyFileChooser();
                if (TableDialog.this.filename != null) {
                    fc.setSelectedFile(SaveAsHelper.checkSuffix(TableDialog.this.filename, "tru"));
                }
                fc.setFileFilter(new FileNameExtensionFilter(Lang.get("msg_truthTable", new Object[0]), "tru"));
                new SaveAsHelper(TableDialog.this, fc, "tru").checkOverwrite(file -> {
                    ((TruthTable)TableDialog.this.undoManager.getActual()).save(file);
                    TableDialog.this.filename = file;
                });
            }
        });
        fileMenu.add(new TextExportAction(this, Lang.get("menu_table_exportTablePlainText", new Object[0])){

            @Override
            ExpressionListener createExpressionListener() {
                return new PlainTextExpressionListener();
            }
        });
        fileMenu.add(new TextExportAction(this, Lang.get("menu_table_exportTableLaTeX", new Object[0])){

            @Override
            ExpressionListener createExpressionListener() throws ExpressionException {
                return new LaTeXExpressionListener((TruthTable)undoManager.getActual());
            }
        });
        fileMenu.add(new ToolTipAction(Lang.get("menu_table_createFunctionFixture", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ModelAnalyserInfo modelAnalyzerInfo = ((TruthTable)TableDialog.this.undoManager.getActual()).getModelAnalyzerInfo();
                    if (modelAnalyzerInfo != null && modelAnalyzerInfo.isSequential()) {
                        JOptionPane.showMessageDialog(TableDialog.this, Lang.get("menu_table_createFunctionFixture_isSequential", new Object[0]));
                    }
                    TruthTableFormatterTestCase test = new TruthTableFormatterTestCase(modelAnalyzerInfo);
                    String testCase = test.format((TruthTable)TableDialog.this.undoManager.getActual());
                    new ShowStringDialog(TableDialog.this, Lang.get("win_table_exportDialog", new Object[0]), testCase).setVisible(true);
                }
                catch (ExpressionException e1) {
                    new ErrorMessage(Lang.get("msg_errorDuringCalculation", new Object[0])).addCause(e1).show(TableDialog.this);
                }
            }
        }.setToolTip(Lang.get("menu_table_createFunctionFixture_tt", new Object[0])).createJMenuItem());
        JMenu export = new JMenu(Lang.get("menu_export", new Object[0]));
        fileMenu.add(export);
        export.add(new FileExportActionConfirm(this, Lang.get("menu_table_exportHex", new Object[0]), "hex"){

            @Override
            protected String getString() throws ExpressionException {
                return new TruthTableFormatterHex().format((TruthTable)undoManager.getActual());
            }
        }.setToolTip(Lang.get("menu_table_exportHex_tt", new Object[0])).createJMenuItem());
        export.add(new FileExportAction(this, Lang.get("menu_table_exportCSVCondensed", new Object[0]), "csv"){

            @Override
            protected String getString() throws FormatterException, ExpressionException {
                ExpressionListenerCSVCondensed expressionListener = new ExpressionListenerCSVCondensed();
                lastGeneratedExpressions.replayTo(expressionListener);
                expressionListener.close();
                return expressionListener.toString();
            }
        }.setToolTip(Lang.get("menu_table_exportCSVCondensed_tt", new Object[0])).createJMenuItem());
        export.add(new FileExportActionConfirm(this, Lang.get("menu_table_exportCSV", new Object[0]), "csv"){

            @Override
            protected String getString() throws ExpressionException {
                return new TruthTableFormatterCSV().format((TruthTable)undoManager.getActual());
            }
        }.setToolTip(Lang.get("menu_table_exportCSV_tt", new Object[0])).createJMenuItem());
        this.createJK = new JCheckBoxMenuItem(Lang.get("menu_table_JK", new Object[0]));
        this.createJK.addActionListener(e -> this.calculateExpressions());
        fileMenu.add(this.createJK);
        fileMenu.add(this.allSolutionsDialog.getReopenAction());
        return fileMenu;
    }

    private void createSetMenuEntries(JMenu edit) {
        edit.add(new ToolTipAction(Lang.get("menu_table_setXTo0", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableDialog.this.modifyTable(v -> v > 1 ? (byte)0 : v);
            }
        }.setToolTip(Lang.get("menu_table_setXTo0_tt", new Object[0])).createJMenuItem());
        edit.add(new ToolTipAction(Lang.get("menu_table_setXTo1", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableDialog.this.modifyTable(v -> v > 1 ? (byte)1 : v);
            }
        }.setToolTip(Lang.get("menu_table_setXTo1_tt", new Object[0])).createJMenuItem());
        edit.add(new ToolTipAction(Lang.get("menu_table_setAllToX", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableDialog.this.modifyTable(v -> 2);
            }
        }.setToolTip(Lang.get("menu_table_setAllToX_tt", new Object[0])).createJMenuItem());
        edit.add(new ToolTipAction(Lang.get("menu_table_setAllTo0", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableDialog.this.modifyTable(v -> 0);
            }
        }.setToolTip(Lang.get("menu_table_setAllTo0_tt", new Object[0])).createJMenuItem());
        edit.add(new ToolTipAction(Lang.get("menu_table_setAllTo1", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableDialog.this.modifyTable(v -> 1);
            }
        }.setToolTip(Lang.get("menu_table_setAllTo1_tt", new Object[0])).createJMenuItem());
        edit.add(new ToolTipAction(Lang.get("menu_table_invert", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableDialog.this.modifyTable(v -> v > 1 ? v : (byte)(1 - v));
            }
        }.setToolTip(Lang.get("menu_table_invert_tt", new Object[0])).createJMenuItem());
    }

    private void modifyTable(BoolTableByteArray.TableModifier m) {
        try {
            this.undoManager.apply(truthTable -> {
                TruthTable truthTable2 = truthTable.modifyValues(m);
            });
            this.tableChanged();
        }
        catch (ModifyException e) {
            e.printStackTrace();
            new ErrorMessage().addCause(e).show(this);
        }
    }

    private JMenu createCreateMenu() {
        JMenu createMenu = new JMenu(Lang.get("menu_table_create", new Object[0]));
        createMenu.add(new ToolTipAction(Lang.get("menu_table_createCircuit", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TableDialog.this.createCircuit(new ExpressionModifier[]{ExpressionModifier.IDENTITY});
            }
        }.setToolTip(Lang.get("menu_table_createCircuit_tt", new Object[0])).setAccelerator("F2").enableAcceleratorIn(this.table).createJMenuItem());
        JMenu createSpecial = new JMenu(Lang.get("menu_table_createCircuitMore", new Object[0]));
        createSpecial.add(new ToolTipAction(Lang.get("menu_table_createCircuitJK", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TableDialog.this.createCircuit(true, false, new ExpressionModifier[]{ExpressionModifier.IDENTITY});
            }
        }.setToolTip(Lang.get("menu_table_createCircuitJK_tt", new Object[0])).createJMenuItem());
        createSpecial.add(new ToolTipAction(Lang.get("menu_table_createCircuitLUT", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TableDialog.this.createCircuit(false, true, new ExpressionModifier[]{ExpressionModifier.IDENTITY});
            }
        }.setToolTip(Lang.get("menu_table_createCircuitLUT_tt", new Object[0])).createJMenuItem());
        createSpecial.add(new ToolTipAction(Lang.get("menu_table_createNAnd", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TableDialog.this.createCircuit(new ExpressionModifier[]{new NAnd()});
            }
        }.setToolTip(Lang.get("menu_table_createNAnd_tt", new Object[0])).createJMenuItem());
        int i = 2;
        while (i < 7) {
            final int ii = i++;
            createSpecial.add(new ToolTipAction(Lang.get("menu_table_maxInputs_N", ii)){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TableDialog.this.createCircuit(new ExpressionModifier[]{new NInputs(ii)});
                }
            }.createJMenuItem());
        }
        if (Main.isExperimentalMode()) {
            createSpecial.add(new ToolTipAction(Lang.get("menu_table_createNOr", new Object[0])){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TableDialog.this.createCircuit(new ExpressionModifier[]{new NOr()});
                }
            }.setToolTip(Lang.get("menu_table_createNOr_tt", new Object[0])).createJMenuItem());
            createSpecial.add(new ToolTipAction(Lang.get("menu_table_createNAndTwo", new Object[0])){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TableDialog.this.createCircuit(new ExpressionModifier[]{new NInputs(2), new NAnd()});
                }
            }.setToolTip(Lang.get("menu_table_createNAndTwo_tt", new Object[0])).createJMenuItem());
            createSpecial.add(new ToolTipAction(Lang.get("menu_table_createNOrTwo", new Object[0])){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TableDialog.this.createCircuit(new ExpressionModifier[]{new NInputs(2), new NOr()});
                }
            }.setToolTip(Lang.get("menu_table_createNOrTwo_tt", new Object[0])).createJMenuItem());
        }
        createMenu.add(createSpecial);
        JMenu hardware = new JMenu(Lang.get("menu_table_create_hardware", new Object[0]));
        this.register(hardware, new GenerateCUPL(CuplExporter::new, "GAL16v8/CUPL"));
        this.register(hardware, new GenerateFile("jed", () -> new ExpressionToFileExporter(new Gal16v8JEDECExporter()), "GAL16v8/JEDEC", Lang.get("menu_table_create_jedec_tt", new Object[0])));
        this.register(hardware, new GenerateCUPL(Gal22v10CuplExporter::new, "GAL22v10/CUPL"));
        this.register(hardware, new GenerateFile("jed", () -> new ExpressionToFileExporter(new Gal22v10JEDECExporter()), "GAL22v10/JEDEC", Lang.get("menu_table_create_jedec_tt", new Object[0])));
        ATFDevice[] aTFDeviceArray = ATFDevice.values();
        int n = aTFDeviceArray.length;
        int n2 = 0;
        while (n2 < n) {
            ATFDevice atfDev = aTFDeviceArray[n2];
            this.register(hardware, new GenerateCUPL(atfDev::getCuplExporter, "ATF150x/" + atfDev.getMenuName() + "/CUPL"));
            this.register(hardware, new GenerateFile("tt2", () -> atfDev.createExpressionToFileExporter(this, this.getProjectName()), "ATF150x/" + atfDev.getMenuName() + "/TT2, JEDEC", Lang.get("menu_table_createTT2_tt", new Object[0])));
            ++n2;
        }
        createMenu.add(hardware);
        return createMenu;
    }

    private void register(JMenu hardware, HardwareDescriptionGenerator generator) {
        this.availGenerators.put(generator.getMenuPath(), generator);
        JMenu m = hardware;
        String path = generator.getMenuPath();
        StringTokenizer tok = new StringTokenizer(path, "/");
        while (tok.hasMoreTokens()) {
            String menuName = tok.nextToken();
            if (tok.hasMoreTokens()) {
                JMenu toUse = null;
                int i = 0;
                while (i < m.getMenuComponentCount()) {
                    JMenu menu;
                    Component menuComponent = m.getMenuComponent(i);
                    if (menuComponent instanceof JMenu && (menu = (JMenu)menuComponent).getText().equalsIgnoreCase(menuName)) {
                        toUse = menu;
                    }
                    ++i;
                }
                if (toUse == null) {
                    toUse = new JMenu(menuName);
                    m.add(toUse);
                }
                m = toUse;
                continue;
            }
            m.add(new HardwareToolTipAction(menuName, generator).createJMenuItem());
        }
    }

    private void createCircuit(ExpressionModifier ... modifier) {
        this.createCircuit(false, false, modifier);
    }

    private void createCircuit(boolean useJKff, boolean useLUTs, ExpressionModifier ... modifier) {
        try {
            ModelAnalyserInfo modelAnalyzerInfo = this.undoManager.getActual().getModelAnalyzerInfo();
            CircuitBuilder circuitBuilder = new CircuitBuilder(this.shapeFactory, this.undoManager.getActual().getVars()).setUseJK(useJKff).setUseLUTs(useLUTs).setModelAnalyzerInfo(modelAnalyzerInfo);
            new BuilderExpressionCreator(circuitBuilder, modifier).setUseJKOptimizer(useJKff).create(this.lastGeneratedExpressions);
            Circuit circuit = circuitBuilder.createCircuit();
            new Main.MainBuilder().setParent(this).setLibrary(this.library).setCircuit(circuit).setBaseFileName(this.filename).openLater();
        }
        catch (ExpressionException | FormatterException | RuntimeException e) {
            new ErrorMessage(Lang.get("msg_errorDuringCalculation", new Object[0])).addCause(e).show(this);
        }
    }

    public TruthTableTableModel getModel() {
        return this.model;
    }

    private String getProjectName() {
        if (this.filename == null) {
            return "unknown";
        }
        return this.filename.getName();
    }

    public AllSolutionsDialog getAllSolutionsDialog() {
        return this.allSolutionsDialog;
    }

    private void setLastUsedGenerator(HardwareDescriptionGenerator generator) {
        if (this.lastUsedGenratorMenuItem != null) {
            this.hardwareMenu.remove(this.lastUsedGenratorMenuItem);
        }
        this.lastUsedGenratorMenuItem = new HardwareToolTipAction(generator.getMenuPath().replace("/", " \u2192 "), generator).createJMenuItem();
        this.hardwareMenu.add(this.lastUsedGenratorMenuItem);
        PREFS.put("gen", generator.getMenuPath());
    }

    private void checkLastUsedGenerator() {
        HardwareDescriptionGenerator gen;
        String lu = PREFS.get("gen", "");
        if (lu.length() > 0 && (gen = this.availGenerators.get(lu)) != null) {
            this.setLastUsedGenerator(gen);
        }
    }

    public UndoManager<TruthTable> getUndoManager() {
        return this.undoManager;
    }

    private void calculateExpressions() {
        try {
            TruthTable table;
            LOGGER.info("start optimization");
            ExpressionListener expressionListener = new OutputExpressionListener();
            if (this.createJK.isSelected()) {
                expressionListener = new ExpressionListenerJK(expressionListener);
            }
            if ((table = this.undoManager.getActual()).getVars().size() >= 8) {
                ProgressDialog progress = new ProgressDialog(this);
                ExpressionListener finalExpressionListener = expressionListener;
                new Thread(() -> {
                    ExpressionListenerStore storage = new ExpressionListenerStore(null);
                    try {
                        new ExpressionCreator(table).setProgressListener(progress).create(storage);
                    }
                    catch (AnalyseException | ExpressionException | FormatterException e) {
                        SwingUtilities.invokeLater(() -> {
                            progress.dispose();
                            this.lastGeneratedExpressions = null;
                            new ErrorMessage(Lang.get("msg_errorDuringCalculation", new Object[0])).addCause(e).show(this);
                        });
                        return;
                    }
                    SwingUtilities.invokeLater(() -> {
                        try {
                            this.lastGeneratedExpressions = new ExpressionListenerStore(finalExpressionListener);
                            storage.replayTo(this.lastGeneratedExpressions);
                            this.lastGeneratedExpressions.close();
                            this.kvMap.setResult(table, this.lastGeneratedExpressions.getResults());
                        }
                        catch (ExpressionException | FormatterException e) {
                            this.lastGeneratedExpressions = null;
                            new ErrorMessage(Lang.get("msg_errorDuringCalculation", new Object[0])).addCause(e).show(this);
                        }
                    });
                }).start();
            } else {
                this.lastGeneratedExpressions = new ExpressionListenerStore(expressionListener);
                new ExpressionCreator(table).create(this.lastGeneratedExpressions);
                this.kvMap.setResult(table, this.lastGeneratedExpressions.getResults());
            }
            LOGGER.info("optimization finished");
        }
        catch (AnalyseException | ExpressionException | FormatterException e1) {
            this.lastGeneratedExpressions = null;
            new ErrorMessage(Lang.get("msg_errorDuringCalculation", new Object[0])).addCause(e1).show(this);
        }
    }

    public ExpressionListenerStore getLastGeneratedExpressions() {
        return this.lastGeneratedExpressions;
    }

    private class CalculationTableModelListener
    implements TableModelListener {
        private CalculationTableModelListener() {
        }

        @Override
        public void tableChanged(TableModelEvent tableModelEvent) {
            TableDialog.this.calculateExpressions();
        }
    }

    private final class CenterDefaultTableCellRenderer
    extends DefaultTableCellRenderer {
        private CenterDefaultTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            int v;
            JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            label.setHorizontalAlignment(0);
            label.setFont(TableDialog.this.font);
            if (column < ((TruthTable)TableDialog.this.undoManager.getActual()).getVars().size()) {
                label.setBackground(MYGRAY);
            } else if ((row & 4) == 0) {
                label.setBackground(Color.WHITE);
            } else {
                label.setBackground(ODDWHITE);
            }
            if (value instanceof Integer && (v = ((Integer)value).intValue()) > 1) {
                label.setText("x");
            }
            return label;
        }
    }

    private abstract class FileExportAction
    extends ToolTipAction {
        private final String suffix;

        private FileExportAction(String name, String suffix) {
            super(name);
            this.suffix = suffix;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.confirmExport()) {
                MyFileChooser fc = new MyFileChooser();
                if (TableDialog.this.filename != null) {
                    fc.setSelectedFile(SaveAsHelper.checkSuffix(TableDialog.this.filename, this.suffix));
                }
                new SaveAsHelper(TableDialog.this, fc, this.suffix).checkOverwrite(file -> {
                    try {
                        Throwable throwable = null;
                        Object var3_5 = null;
                        try (FileWriter w = new FileWriter(file);){
                            w.write(this.getString());
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (ExpressionException | FormatterException ex) {
                        throw new IOException(ex);
                    }
                });
            }
        }

        protected boolean confirmExport() {
            return true;
        }

        protected abstract String getString() throws FormatterException, ExpressionException;
    }

    private abstract class FileExportActionConfirm
    extends FileExportAction {
        private FileExportActionConfirm(String name, String suffix) {
            super(name, suffix);
        }

        @Override
        protected boolean confirmExport() {
            int res = 0;
            if (((TruthTable)TableDialog.this.undoManager.getActual()).getVars().size() > 20) {
                res = JOptionPane.showConfirmDialog(TableDialog.this, Lang.get("msg_tableHasManyRowsConfirm", new Object[0]));
            }
            return res == 0;
        }
    }

    private final class HardwareToolTipAction
    extends ToolTipAction {
        private final HardwareDescriptionGenerator generator;

        private HardwareToolTipAction(String menuName, HardwareDescriptionGenerator generator) {
            super(menuName);
            this.generator = generator;
            this.setToolTip(generator.getDescription());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                this.generator.generate(TableDialog.this, TableDialog.this.filename, (TruthTable)TableDialog.this.undoManager.getActual(), TableDialog.this.lastGeneratedExpressions);
                TableDialog.this.setLastUsedGenerator(this.generator);
            }
            catch (Exception e1) {
                new ErrorMessage(Lang.get("msg_errorDuringHardwareExport", new Object[0])).addCause(e1).show(TableDialog.this);
            }
        }
    }

    private final class OutputExpressionListener
    implements ExpressionListener {
        private final ArrayList<Expression> expressions = new ArrayList();

        private OutputExpressionListener() {
        }

        @Override
        public void resultFound(String name, Expression expression) {
            if (name.endsWith("^n+1")) {
                name = String.valueOf(name.substring(0, name.length() - 4)) + "^{n+1}";
            }
            this.expressions.add(new NamedExpression(name, expression));
        }

        @Override
        public void close() {
            SwingUtilities.invokeLater(() -> {
                switch (this.expressions.size()) {
                    case 0: {
                        TableDialog.this.statusBar.setVisible(false);
                        TableDialog.this.allSolutionsDialog.setNeeded(false, TableDialog.this.getBounds());
                        break;
                    }
                    case 1: {
                        TableDialog.this.statusBar.setVisible(true);
                        TableDialog.this.statusBar.setExpression(this.expressions.get(0));
                        TableDialog.this.allSolutionsDialog.setNeeded(false, TableDialog.this.getBounds());
                        break;
                    }
                    default: {
                        TableDialog.this.statusBar.setVisible(false);
                        TableDialog.this.allSolutionsDialog.setExpressions(this.expressions);
                        TableDialog.this.allSolutionsDialog.setNeeded(true, TableDialog.this.getBounds());
                        TableDialog.this.toFront();
                    }
                }
            });
        }
    }

    private final class SetAction
    extends AbstractAction {
        private final int value;

        private SetAction(int value) {
            this.value = value;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int r = TableDialog.this.table.getSelectedRow();
            int c = TableDialog.this.table.getSelectedColumn();
            if (r < 0 || c < 0) {
                r = 0;
                c = ((TruthTable)TableDialog.this.undoManager.getActual()).getVars().size();
            }
            TableDialog.this.model.setValueAt(this.value, r, c);
            if (++c >= TableDialog.this.table.getColumnCount()) {
                c = ((TruthTable)TableDialog.this.undoManager.getActual()).getVars().size();
                if (++r >= TableDialog.this.model.getRowCount()) {
                    r = 0;
                }
            }
            TableDialog.this.table.changeSelection(r, c, false, false);
        }
    }

    private final class SizeAction
    extends AbstractAction {
        private final int n;

        private SizeAction(int n) {
            super(Lang.get("menu_table_N_variables", n));
            this.n = n;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            TableDialog.this.undoManager.setInitial(new TruthTable(this.n).addResult());
            TableDialog.this.tableChanged();
        }
    }

    private final class SizeSequentialAction
    extends AbstractAction {
        private final int n;

        private SizeSequentialAction(int n) {
            super(Lang.get("menu_table_N_variables", n));
            this.n = n;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ArrayList<Variable> vars = new ArrayList<Variable>();
            int i = this.n - 1;
            while (i >= 0) {
                vars.add(new Variable("Q_" + i + "^n"));
                --i;
            }
            TruthTable truthTable = new TruthTable(vars);
            int i2 = this.n - 1;
            int rows = 1 << this.n;
            for (Variable v : vars) {
                BoolTableByteArray val = new BoolTableByteArray(rows);
                int n = 0;
                while (n < rows) {
                    val.set(n, n + 1 >> i2 & 1);
                    ++n;
                }
                truthTable.addResult(ModelAnalyser.addOne(v.getIdentifier()), val);
                --i2;
            }
            TableDialog.this.undoManager.setInitial(truthTable);
            TableDialog.this.tableChanged();
        }
    }

    private final class SizeSequentialBidirectionalAction
    extends AbstractAction {
        private final int n;

        private SizeSequentialBidirectionalAction(int n) {
            super(Lang.get("menu_table_N_variables", n));
            this.n = n;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ArrayList<Variable> vars = new ArrayList<Variable>();
            vars.add(new Variable("D"));
            int i = this.n - 1;
            while (i >= 0) {
                vars.add(new Variable("Q_" + i + "^n"));
                --i;
            }
            TruthTable truthTable = new TruthTable(vars);
            int i2 = this.n - 1;
            int rows = 1 << this.n + 1;
            int vi = 1;
            while (vi < vars.size()) {
                BoolTableByteArray val = new BoolTableByteArray(rows);
                int n = 0;
                while (n < rows) {
                    if (n >= rows / 2) {
                        val.set(n, n - 1 >> i2 & 1);
                    } else {
                        val.set(n, n + 1 >> i2 & 1);
                    }
                    ++n;
                }
                truthTable.addResult(ModelAnalyser.addOne(vars.get(vi).getIdentifier()), val);
                --i2;
                ++vi;
            }
            TableDialog.this.undoManager.setInitial(truthTable);
            TableDialog.this.tableChanged();
        }
    }

    private static final class StringDefaultTableCellRenderer
    extends DefaultTableCellRenderer {
        private StringDefaultTableCellRenderer() {
            this.setHorizontalAlignment(0);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            label.setBackground(MYGRAY);
            try {
                label.setText(PlainTextFormatter.format(new Parser(value.toString()).parse()));
            }
            catch (ParseException e) {
                label.setText(value.toString());
            }
            this.setBorder(BorderFactory.createRaisedBevelBorder());
            return label;
        }
    }

    private abstract class TextExportAction
    extends ToolTipAction {
        private TextExportAction(String name) {
            super(name);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                ExpressionListener laTeXExpressionListener;
                ExpressionListener expressionListener = laTeXExpressionListener = this.createExpressionListener();
                if (TableDialog.this.createJK.isSelected()) {
                    expressionListener = new ExpressionListenerJK(expressionListener);
                }
                TableDialog.this.lastGeneratedExpressions.replayTo(expressionListener);
                expressionListener.close();
                new ShowStringDialog(TableDialog.this, Lang.get("win_table_exportDialog", new Object[0]), laTeXExpressionListener.toString()).setVisible(true);
            }
            catch (ExpressionException | FormatterException e1) {
                new ErrorMessage(Lang.get("msg_errorDuringCalculation", new Object[0])).addCause(e1).show(TableDialog.this);
            }
        }

        abstract ExpressionListener createExpressionListener() throws ExpressionException;
    }
}

