/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.gui.components.terminal;

import de.neemann.digital.core.Node;
import de.neemann.digital.core.NodeException;
import de.neemann.digital.core.ObservableValue;
import de.neemann.digital.core.ObservableValues;
import de.neemann.digital.core.element.Element;
import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.ElementTypeDescription;
import de.neemann.digital.core.element.Keys;
import de.neemann.digital.core.element.PinInfo;

public class Keyboard
extends Node
implements Element {
    public static final ElementTypeDescription DESCRIPTION = new ElementTypeDescription(Keyboard.class, PinInfo.input("C").setClock(), PinInfo.input("en")).addAttribute(Keys.ROTATE).addAttribute(Keys.LABEL).addAttribute(Keys.INVERTER_CONFIG);
    private final String label;
    private final ObservableValue data = new ObservableValue("D", 16).setToHighZ().setPinDescription(DESCRIPTION);
    private final ObservableValue keyAvail = new ObservableValue("av", 1).setPinDescription(DESCRIPTION);
    private KeyboardInterface keyboardInterface;
    private ObservableValue clock;
    private ObservableValue enable;
    private boolean enableVal;
    private boolean lastClock = false;

    public Keyboard(ElementAttributes attributes) {
        this.label = attributes.getLabel();
    }

    @Override
    public void setInputs(ObservableValues inputs) throws NodeException {
        this.clock = ((ObservableValue)inputs.get(0)).addObserverToValue(this).checkBits(1, this, 0);
        this.enable = ((ObservableValue)inputs.get(1)).addObserverToValue(this).checkBits(1, this, 1);
    }

    @Override
    public ObservableValues getOutputs() {
        return new ObservableValues(this.data, this.keyAvail);
    }

    @Override
    public void readInputs() throws NodeException {
        this.enableVal = this.enable.getBool();
        boolean nowClock = this.clock.getBool();
        if (this.keyboardInterface != null && nowClock && !this.lastClock && this.enableVal) {
            this.keyboardInterface.deleteFirstChar();
        }
        this.lastClock = nowClock;
    }

    @Override
    public void writeOutputs() throws NodeException {
        if (this.keyboardInterface != null) {
            if (this.enableVal) {
                this.data.setValue(this.keyboardInterface.getChar());
            } else {
                this.data.setToHighZ();
            }
            this.keyAvail.setBool(this.keyboardInterface.getChar() != 0);
        } else {
            if (this.enableVal) {
                this.data.setValue(0L);
            } else {
                this.data.setToHighZ();
            }
            this.keyAvail.setBool(false);
        }
    }

    public void setKeyboard(KeyboardInterface keyboardInterface) {
        this.keyboardInterface = keyboardInterface;
    }

    public String getLabel() {
        return this.label;
    }

    public static interface KeyboardInterface {
        public int getChar();

        public void deleteFirstChar();
    }
}

