/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.gui.components.terminal;

import de.neemann.digital.core.Node;
import de.neemann.digital.core.NodeException;
import de.neemann.digital.core.ObservableValue;
import de.neemann.digital.core.ObservableValues;
import de.neemann.digital.core.element.Element;
import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.ElementTypeDescription;
import de.neemann.digital.core.element.Keys;
import de.neemann.digital.core.element.PinInfo;
import de.neemann.digital.gui.components.terminal.ConsoleTerminal;
import de.neemann.digital.gui.components.terminal.TerminalDialog;
import de.neemann.digital.gui.components.terminal.TerminalInterface;

public class Terminal
extends Node
implements Element {
    public static final ElementTypeDescription DESCRIPTION = new ElementTypeDescription(Terminal.class, PinInfo.input("D"), PinInfo.input("C").setClock(), PinInfo.input("en")).addAttribute(Keys.TERM_WIDTH).addAttribute(Keys.TERM_HEIGHT).addAttribute(Keys.ROTATE).addAttribute(Keys.LABEL);
    private final ElementAttributes attr;
    private final String label;
    private TerminalInterface terminal;
    private ObservableValue data;
    private ObservableValue clock;
    private boolean lastClock;
    private ObservableValue en;

    public Terminal(ElementAttributes attributes) {
        this.attr = attributes;
        this.label = attributes.getLabel();
    }

    @Override
    public void setInputs(ObservableValues inputs) throws NodeException {
        this.data = (ObservableValue)inputs.get(0);
        this.clock = ((ObservableValue)inputs.get(1)).addObserverToValue(this).checkBits(1, this);
        this.en = ((ObservableValue)inputs.get(2)).addObserverToValue(this).checkBits(1, this);
    }

    @Override
    public ObservableValues getOutputs() {
        return ObservableValues.EMPTY_LIST;
    }

    @Override
    public void readInputs() throws NodeException {
        long value;
        boolean clockVal = this.clock.getBool();
        if (!this.lastClock && clockVal && this.en.getBool() && (value = this.data.getValue()) != 0L) {
            if (this.terminal == null) {
                this.terminal = this.getModel().runningInMainFrame() ? TerminalDialog.getTerminal(this.getModel(), this.attr) : new ConsoleTerminal();
            }
            this.terminal.addChar((char)value);
        }
        this.lastClock = clockVal;
    }

    @Override
    public void writeOutputs() throws NodeException {
    }

    public TerminalInterface getTerminalInterface() {
        return this.terminal;
    }

    public void setTerminalInterface(TerminalInterface terminal) {
        this.terminal = terminal;
    }

    public String getLabel() {
        return this.label;
    }
}

