/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.gui.components.testing;

import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.Key;
import de.neemann.digital.draw.elements.VisualElement;
import de.neemann.digital.gui.Main;
import de.neemann.digital.gui.components.Editor;
import de.neemann.digital.gui.components.EditorFactory;
import de.neemann.digital.gui.components.testing.TestCaseDescriptionDialog;
import de.neemann.digital.lang.Lang;
import de.neemann.digital.testing.TestCaseDescription;
import de.neemann.gui.ToolTipAction;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class TestCaseDescriptionEditor
extends EditorFactory.LabelEditor<TestCaseDescription> {
    private final TestCaseDescription initialData;
    private TestCaseDescription data;

    public TestCaseDescriptionEditor(TestCaseDescription data, Key<TestCaseDescription> key) {
        this.data = data;
        this.initialData = data;
    }

    @Override
    public TestCaseDescription getValue() {
        return this.data;
    }

    @Override
    protected JComponent getComponent(ElementAttributes elementAttributes) {
        final JPanel panel = new JPanel(new FlowLayout());
        panel.add(new ToolTipAction(Lang.get("btn_edit", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent e) {
                TestCaseDescriptionDialog tdd = new TestCaseDescriptionDialog(SwingUtilities.getWindowAncestor(panel), TestCaseDescriptionEditor.this.data);
                TestCaseDescription d = tdd.showDialog();
                if (d != null) {
                    TestCaseDescriptionEditor.this.data = d;
                }
            }
        }.createJButton());
        panel.add(new ToolTipAction(Lang.get("btn_editDetached", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    TestCaseDescriptionEditor.this.getAttributeDialog().fireOk();
                    VisualElement visualElement = TestCaseDescriptionEditor.this.getAttributeDialog().getVisualElement();
                    Main main = TestCaseDescriptionEditor.this.getAttributeDialog().getMain();
                    if (main != null) {
                        TestCaseDescriptionDialog dialog = new TestCaseDescriptionDialog((Window)main, TestCaseDescriptionEditor.this.data, visualElement);
                        main.getWindowPosManager().register("testdata", dialog);
                        dialog.setVisible(true);
                    }
                }
                catch (Editor.EditorParseException e1) {
                    e1.printStackTrace();
                }
            }
        }.setToolTip(Lang.get("btn_editDetached_tt", new Object[0])).createJButton());
        return panel;
    }

    @Override
    public boolean invisibleModification() {
        return !this.initialData.equals(this.data);
    }

    @Override
    public void setValue(TestCaseDescription data) {
        this.data = data;
    }
}

