/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.gui.components.tree;

import de.neemann.digital.core.element.ElementTypeDescription;
import de.neemann.digital.draw.elements.VisualElement;
import de.neemann.digital.draw.library.LibraryNode;
import de.neemann.digital.draw.shapes.ShapeFactory;
import de.neemann.digital.gui.InsertAction;
import de.neemann.digital.gui.InsertHistory;
import de.neemann.digital.gui.components.CircuitComponent;
import de.neemann.digital.gui.components.tree.LibraryTreeModel;
import de.neemann.digital.lang.Lang;
import de.neemann.gui.ErrorMessage;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.Enumeration;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;

public class SelectTree
extends JTree {
    private final ShapeFactory shapeFactory;
    private Enumeration<TreePath> storedExpanded;

    public SelectTree(LibraryTreeModel model, final CircuitComponent component, final ShapeFactory shapeFactory, final InsertHistory insertHistory) {
        super(model);
        this.shapeFactory = shapeFactory;
        this.setSelectionModel(null);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                LibraryNode node;
                TreePath path = SelectTree.this.getClosestPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                if (path != null && path.getPathCount() > 0 && (node = (LibraryNode)path.getLastPathComponent()).isLeaf() && node.isUnique()) {
                    try {
                        ElementTypeDescription d = node.getDescription();
                        VisualElement element = node.setWideShapeFlagTo(new VisualElement(d.getName()).setShapeFactory(shapeFactory));
                        component.setPartToInsert(element);
                        insertHistory.add(new InsertAction(node, insertHistory, component, shapeFactory));
                    }
                    catch (IOException e) {
                        SwingUtilities.invokeLater(new ErrorMessage(Lang.get("msg_errorImportingModel_N0", node.getName())).addCause(e));
                    }
                }
            }
        });
        this.setCellRenderer(new MyCellRenderer());
        this.setToolTipText("");
        this.expandPath(new TreePath(model.getFirstLeafParent().getPath()));
    }

    public void setModel(LibraryTreeModel newModel) {
        LibraryTreeModel oldModel = (LibraryTreeModel)this.getModel();
        if (!oldModel.isFiltered() && newModel.isFiltered()) {
            this.storedExpanded = this.getExpandedDescendants(new TreePath(this.getModel().getRoot()));
        }
        oldModel.close();
        boolean restore = oldModel.isFiltered() && !newModel.isFiltered();
        super.setModel(newModel);
        if (restore && this.storedExpanded != null) {
            while (this.storedExpanded.hasMoreElements()) {
                this.expandPath(this.storedExpanded.nextElement());
            }
            this.storedExpanded = null;
        } else {
            this.expandPath(new TreePath(newModel.getFirstLeafParent().getPath()));
        }
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        Object lp;
        TreePath selPath = this.getPathForLocation(e.getX(), e.getY());
        if (selPath != null && selPath.getPathCount() > 0 && (lp = selPath.getLastPathComponent()) instanceof LibraryNode) {
            return ((LibraryNode)lp).getToolTipText();
        }
        return null;
    }

    private class MyCellRenderer
    extends DefaultTreeCellRenderer {
        private MyCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            JLabel comp = (JLabel)super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            if (leaf) {
                comp.setIcon(((LibraryNode)value).getIconOrNull(SelectTree.this.shapeFactory));
            } else {
                comp.setIcon(null);
            }
            return comp;
        }
    }
}

