/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.hdl.hgs;

import de.neemann.digital.hdl.hgs.HGSEvalException;
import de.neemann.digital.hdl.hgs.Value;
import de.neemann.digital.testing.parser.OperatorPrecedence;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;

class Tokenizer {
    private static final HashMap<String, Token> STATEMENT_MAP = new HashMap();
    private final Reader in;
    private final StringBuilder builder;
    private final String srcFile;
    private Token token;
    private boolean isToken;
    private boolean isUnreadChar = false;
    private int unreadChar;
    private int line = 1;

    static {
        STATEMENT_MAP.put("if", Token.IF);
        STATEMENT_MAP.put("else", Token.ELSE);
        STATEMENT_MAP.put("for", Token.FOR);
        STATEMENT_MAP.put("while", Token.WHILE);
        STATEMENT_MAP.put("func", Token.FUNC);
        STATEMENT_MAP.put("repeat", Token.REPEAT);
        STATEMENT_MAP.put("until", Token.UNTIL);
        STATEMENT_MAP.put("return", Token.RETURN);
        STATEMENT_MAP.put("export", Token.EXPORT);
        STATEMENT_MAP.put("true", Token.TRUE);
        STATEMENT_MAP.put("false", Token.FALSE);
    }

    Tokenizer(Reader in, String srcFile) {
        this.in = in;
        this.srcFile = srcFile;
        this.token = Token.UNKNOWN;
        this.isToken = false;
        this.builder = new StringBuilder();
    }

    public Token next() throws IOException {
        Token token = this.peek();
        this.consume();
        return token;
    }

    public void consume() {
        this.isToken = false;
    }

    public String getSrcFile() {
        return this.srcFile;
    }

    public Token peek() throws IOException {
        block29: do {
            int c;
            if (this.isToken) {
                return this.token;
            }
            while (Tokenizer.isWhiteSpace(c = this.readChar())) {
            }
            switch (c) {
                case -1: {
                    this.token = Token.EOF;
                    break;
                }
                case 40: {
                    this.token = Token.OPEN;
                    break;
                }
                case 41: {
                    this.token = Token.CLOSE;
                    break;
                }
                case 123: {
                    this.token = Token.OPENBRACE;
                    break;
                }
                case 125: {
                    this.token = Token.CLOSEDBRACE;
                    break;
                }
                case 91: {
                    this.token = Token.OPENSQUARE;
                    break;
                }
                case 93: {
                    this.token = Token.CLOSEDSQUARE;
                    break;
                }
                case 46: {
                    this.token = Token.DOT;
                    break;
                }
                case 58: {
                    this.token = Token.COLON;
                    break;
                }
                case 59: {
                    this.token = Token.SEMICOLON;
                    break;
                }
                case 38: {
                    this.token = Token.AND;
                    break;
                }
                case 124: {
                    this.token = Token.OR;
                    break;
                }
                case 94: {
                    this.token = Token.XOR;
                    break;
                }
                case 43: {
                    this.token = Token.ADD;
                    break;
                }
                case 45: {
                    this.token = Token.SUB;
                    break;
                }
                case 42: {
                    this.token = Token.MUL;
                    break;
                }
                case 37: {
                    this.token = Token.MOD;
                    break;
                }
                case 47: {
                    if (this.isNextChar('/')) {
                        this.token = null;
                        this.skipLine();
                        break;
                    }
                    this.token = Token.DIV;
                    break;
                }
                case 60: {
                    if (this.isNextChar('<')) {
                        this.token = Token.SHIFTLEFT;
                        break;
                    }
                    if (this.isNextChar('=')) {
                        this.token = Token.LESSEQUAL;
                        break;
                    }
                    this.token = Token.LESS;
                    break;
                }
                case 62: {
                    if (this.isNextChar('>')) {
                        this.token = Token.SHIFTRIGHT;
                        break;
                    }
                    if (this.isNextChar('=')) {
                        this.token = Token.GREATEREQUAL;
                        break;
                    }
                    this.token = Token.GREATER;
                    break;
                }
                case 126: {
                    this.token = Token.NOT;
                    break;
                }
                case 44: {
                    this.token = Token.COMMA;
                    break;
                }
                case 61: {
                    this.token = Token.EQUAL;
                    break;
                }
                case 33: {
                    if (this.isNextChar('=')) {
                        this.token = Token.NOTEQUAL;
                        break;
                    }
                    this.token = Token.NOT;
                    break;
                }
                case 34: {
                    this.token = Token.STRING;
                    this.readString();
                    break;
                }
                case 39: {
                    this.token = Token.IDENT;
                    this.builder.setLength(0);
                    while ((c = this.readChar()) != 39) {
                        this.builder.append((char)c);
                        if (c >= 0) continue;
                        throw new IOException("EOF detected while scanning escaped var name");
                    }
                    continue block29;
                }
                case 63: {
                    if (this.isNextChar('>')) {
                        this.token = Token.CODEEND;
                        break;
                    }
                    if (this.isNextChar('}')) {
                        this.token = Token.CODEEND;
                        break;
                    }
                    this.token = Token.UNKNOWN;
                    break;
                }
                default: {
                    if (this.isIdentChar(c)) {
                        this.readIdent(c);
                        break;
                    }
                    if (this.isNumberChar(c)) {
                        this.readNumber(c);
                        break;
                    }
                    this.token = Token.UNKNOWN;
                    this.builder.setLength(0);
                    this.builder.append((char)c);
                }
            }
        } while (this.token == null);
        this.isToken = true;
        return this.token;
    }

    private void readString() throws IOException {
        int c;
        this.builder.setLength(0);
        while ((c = this.readChar()) != 34) {
            if (c == 92) {
                c = this.readChar();
                switch (c) {
                    case 92: {
                        c = 92;
                        break;
                    }
                    case 110: {
                        c = 10;
                        break;
                    }
                    case 114: {
                        c = 13;
                        break;
                    }
                    case 116: {
                        c = 9;
                        break;
                    }
                    case 34: {
                        c = 34;
                        break;
                    }
                    default: {
                        throw new IOException("not allowed in string: \\" + (char)c);
                    }
                }
            }
            this.builder.append((char)c);
            if (c >= 0) continue;
            throw new IOException("EOF detected while scanning a string");
        }
    }

    private void readNumber(int c) throws IOException {
        this.token = Token.NUMBER;
        this.builder.setLength(0);
        this.builder.append((char)c);
        boolean wasChar = true;
        do {
            if (this.isNumberChar(c = this.readChar()) || this.isHexChar(c) || c == 120 || c == 88) {
                this.builder.append((char)c);
                continue;
            }
            if (c == 46) {
                this.builder.append((char)c);
                this.token = Token.DOUBLE;
                continue;
            }
            this.unreadChar(c);
            wasChar = false;
        } while (wasChar);
    }

    private void readIdent(int c) throws IOException {
        this.token = Token.IDENT;
        this.builder.setLength(0);
        this.builder.append((char)c);
        boolean wasChar = true;
        do {
            if (this.isIdentChar(c = this.readChar()) || this.isNumberChar(c)) {
                this.builder.append((char)c);
                continue;
            }
            this.unreadChar(c);
            wasChar = false;
        } while (wasChar);
        this.token = STATEMENT_MAP.get(this.builder.toString());
        if (this.token == null) {
            this.token = Token.IDENT;
        }
    }

    private void skipLine() throws IOException {
        int c;
        while ((c = this.readChar()) >= 0 && c != 10) {
        }
    }

    private boolean isNextChar(char should) throws IOException {
        int c = this.readChar();
        if (c == should) {
            return true;
        }
        this.unreadChar(c);
        return false;
    }

    public String getIdent() {
        return this.builder.toString();
    }

    private int readChar() throws IOException {
        if (this.isUnreadChar) {
            this.isUnreadChar = false;
            return this.unreadChar;
        }
        int c = this.in.read();
        if (c == 10) {
            ++this.line;
        }
        return c;
    }

    private void unreadChar(int c) {
        this.unreadChar = c;
        this.isUnreadChar = true;
    }

    private boolean isIdentChar(int c) {
        return c >= 97 && c <= 122 || c >= 65 && c <= 90 || c == 95;
    }

    private boolean isHexChar(int c) {
        return c >= 97 && c <= 102 || c >= 65 && c <= 70;
    }

    private boolean isNumberChar(int c) {
        return c >= 48 && c <= 57;
    }

    public static boolean isWhiteSpace(int c) {
        return c == 32 || c == 9 || c == 10 || c == 13;
    }

    public String toString() {
        if (this.token == Token.IDENT || this.token == Token.UNKNOWN) {
            return this.getIdent();
        }
        return this.token.name();
    }

    public int getLine() {
        return this.line;
    }

    public String readText() throws IOException {
        int c;
        this.isToken = false;
        StringBuilder sb = new StringBuilder();
        while ((c = this.readChar()) > 0) {
            if (c == 60 || c == 123) {
                if (this.isNextChar('?')) {
                    return sb.toString();
                }
                sb.append((char)c);
                continue;
            }
            sb.append((char)c);
        }
        return sb.toString();
    }

    static interface Binary {
        public Object op(Object var1, Object var2) throws HGSEvalException;
    }

    static enum Token {
        UNKNOWN,
        IDENT,
        OPEN,
        CLOSE,
        NUMBER,
        EOL,
        EOF,
        COMMA,
        NOT,
        OR(OperatorPrecedence.OR, Value::or),
        XOR(OperatorPrecedence.XOR, Value::xor),
        AND(OperatorPrecedence.AND, Value::and),
        EQUAL(OperatorPrecedence.EQUAL, Value::equals),
        NOTEQUAL(OperatorPrecedence.EQUAL, (a, b) -> !Value.equals(a, b)),
        ADD(OperatorPrecedence.ADD, Value::add),
        SUB(OperatorPrecedence.ADD, Value::sub),
        MUL(OperatorPrecedence.MUL, Value::mul),
        DIV(OperatorPrecedence.MUL, Value::div),
        MOD(OperatorPrecedence.MUL, (a, b) -> Value.toLong(a) % Value.toLong(b)),
        LESS(OperatorPrecedence.COMPARE, Value::less),
        LESSEQUAL(OperatorPrecedence.COMPARE, Value::lessEqual),
        GREATER(OperatorPrecedence.COMPARE, (a, b) -> Value.less(b, a)),
        GREATEREQUAL(OperatorPrecedence.COMPARE, (a, b) -> Value.lessEqual(b, a)),
        SHIFTLEFT(OperatorPrecedence.SHIFT, (a, b) -> Value.toLong(a) << (int)Value.toLong(b)),
        SHIFTRIGHT(OperatorPrecedence.SHIFT, (a, b) -> Value.toLong(a) >>> (int)Value.toLong(b)),
        END,
        IF,
        ELSE,
        FOR,
        WHILE,
        SEMICOLON,
        STRING,
        OPENBRACE,
        CLOSEDBRACE,
        CODEEND,
        OPENSQUARE,
        CLOSEDSQUARE,
        DOT,
        FUNC,
        REPEAT,
        RETURN,
        COLON,
        UNTIL,
        DOUBLE,
        EXPORT,
        TRUE,
        FALSE;

        private final OperatorPrecedence precedence;
        private final Binary binary;

        private Token() {
            this(null, null);
        }

        private Token(OperatorPrecedence precedence, Binary binary) {
            this.precedence = precedence;
            this.binary = binary;
        }

        public OperatorPrecedence getPrecedence() {
            return this.precedence;
        }

        public Binary getBinary() {
            return this.binary;
        }
    }
}

