/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.hdl.hgs;

import de.neemann.digital.hdl.hgs.HGSArray;
import de.neemann.digital.hdl.hgs.HGSEvalException;
import de.neemann.digital.hdl.hgs.HGSMap;
import de.neemann.digital.hdl.hgs.Tokenizer;
import java.util.List;
import java.util.Map;

public final class Value {
    private Value() {
    }

    public static long toLong(Object value) throws HGSEvalException {
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        throw new HGSEvalException("not a number: " + value.toString());
    }

    public static double toDouble(Object value) throws HGSEvalException {
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        throw new HGSEvalException("not a number: " + value.toString());
    }

    public static int toInt(Object value) throws HGSEvalException {
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        throw new HGSEvalException("not a number: " + value.toString());
    }

    public static boolean toBool(Object value) throws HGSEvalException {
        if (value instanceof Number) {
            return ((Number)value).longValue() != 0L;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        throw new HGSEvalException("Must be an integer or a bool, is: " + value.getClass().getSimpleName() + "=" + value);
    }

    public static String toString(Object value) throws HGSEvalException {
        if (value instanceof String) {
            return value.toString();
        }
        throw new HGSEvalException("must be a string, is a " + value.getClass().getSimpleName());
    }

    public static HGSArray toArray(Object value) throws HGSEvalException {
        if (value instanceof HGSArray) {
            return (HGSArray)value;
        }
        if (value instanceof List) {
            return new HGSArrayList((List)value);
        }
        throw new HGSEvalException("must be an array, is a " + value.getClass().getSimpleName());
    }

    public static HGSMap toMap(Object value) throws HGSEvalException {
        if (value instanceof HGSMap) {
            return (HGSMap)value;
        }
        if (value instanceof Map) {
            return new HGSMapMap((Map)value);
        }
        throw new HGSEvalException("must be a map, is a " + value.getClass().getSimpleName());
    }

    public static boolean equals(Object a, Object b) {
        if (a instanceof Double || b instanceof Double) {
            return a.equals(b);
        }
        if (a instanceof Number && b instanceof Number) {
            return ((Number)a).longValue() == ((Number)b).longValue();
        }
        if (a instanceof String || b instanceof String) {
            return a.toString().equals(b.toString());
        }
        return a.equals(b);
    }

    public static Object add(Object a, Object b) throws HGSEvalException {
        if (a instanceof Double || b instanceof Double) {
            return Value.toDouble(a) + Value.toDouble(b);
        }
        if (a instanceof Number && b instanceof Number) {
            return ((Number)a).longValue() + ((Number)b).longValue();
        }
        if (a instanceof String || b instanceof String) {
            return String.valueOf(a.toString()) + b.toString();
        }
        throw new HGSEvalException("arguments must be int or string, not " + a.getClass().getSimpleName() + "+" + b.getClass().getSimpleName());
    }

    public static Object sub(Object a, Object b) throws HGSEvalException {
        if (a instanceof Double || b instanceof Double) {
            return Value.toDouble(a) - Value.toDouble(b);
        }
        if (a instanceof Number && b instanceof Number) {
            return ((Number)a).longValue() - ((Number)b).longValue();
        }
        throw new HGSEvalException("arguments must be int or double, not " + a.getClass().getSimpleName() + "+" + b.getClass().getSimpleName());
    }

    public static Object mul(Object a, Object b) throws HGSEvalException {
        if (a instanceof Double || b instanceof Double) {
            return Value.toDouble(a) * Value.toDouble(b);
        }
        if (a instanceof Number && b instanceof Number) {
            return ((Number)a).longValue() * ((Number)b).longValue();
        }
        throw new HGSEvalException("arguments must be int or double, not " + a.getClass().getSimpleName() + "+" + b.getClass().getSimpleName());
    }

    public static Object div(Object a, Object b) throws HGSEvalException {
        if (a instanceof Double || b instanceof Double) {
            return Value.toDouble(a) / Value.toDouble(b);
        }
        if (a instanceof Number && b instanceof Number) {
            return ((Number)a).longValue() / ((Number)b).longValue();
        }
        throw new HGSEvalException("arguments must be int or double, not " + a.getClass().getSimpleName() + "+" + b.getClass().getSimpleName());
    }

    public static Object or(Object a, Object b) throws HGSEvalException {
        if (a instanceof Number && b instanceof Number) {
            return ((Number)a).longValue() | ((Number)b).longValue();
        }
        if (!Value.toBool(a) && !Value.toBool(b)) {
            return false;
        }
        return true;
    }

    public static Object xor(Object a, Object b) throws HGSEvalException {
        if (a instanceof Number && b instanceof Number) {
            return ((Number)a).longValue() ^ ((Number)b).longValue();
        }
        return Value.toBool(a) ^ Value.toBool(b);
    }

    public static Object and(Object a, Object b) throws HGSEvalException {
        if (a instanceof Number && b instanceof Number) {
            return ((Number)a).longValue() & ((Number)b).longValue();
        }
        if (Value.toBool(a) && Value.toBool(b)) {
            return true;
        }
        return false;
    }

    public static Object not(Object value) throws HGSEvalException {
        if (value instanceof Number) {
            return ((Number)value).longValue() ^ 0xFFFFFFFFFFFFFFFFL;
        }
        return !Value.toBool(value);
    }

    public static Object neg(Object value) throws HGSEvalException {
        if (value instanceof Double) {
            return -((Double)value).doubleValue();
        }
        return -Value.toLong(value);
    }

    public static boolean less(Object a, Object b) throws HGSEvalException {
        if (a instanceof Double || b instanceof Double) {
            return Value.toDouble(a) < Value.toDouble(b);
        }
        if (a instanceof Number && b instanceof Number) {
            return Value.toLong(a) < Value.toLong(b);
        }
        if (a instanceof String && b instanceof String) {
            return a.toString().compareTo(b.toString()) < 0;
        }
        throw new HGSEvalException("arguments must be int, double or string, not " + a.getClass().getSimpleName() + "+" + b.getClass().getSimpleName());
    }

    public static boolean lessEqual(Object a, Object b) throws HGSEvalException {
        if (a instanceof Double || b instanceof Double) {
            return Value.toDouble(a) <= Value.toDouble(b);
        }
        if (a instanceof Number && b instanceof Number) {
            return Value.toLong(a) <= Value.toLong(b);
        }
        if (a instanceof String && b instanceof String) {
            return a.toString().compareTo(b.toString()) <= 0;
        }
        throw new HGSEvalException("arguments must be int, double or string, not " + a.getClass().getSimpleName() + "+" + b.getClass().getSimpleName());
    }

    public static String trimRight(String str) {
        int initial;
        int pos = initial = str.length() - 1;
        while (pos >= 0 && Tokenizer.isWhiteSpace(str.charAt(pos))) {
            --pos;
        }
        if (pos == initial) {
            return str;
        }
        return str.substring(0, pos + 1);
    }

    public static String trimLeft(String str) {
        int pos = 0;
        while (pos < str.length() && Tokenizer.isWhiteSpace(str.charAt(pos))) {
            ++pos;
        }
        if (pos == 0) {
            return str;
        }
        return str.substring(pos);
    }

    private static final class HGSArrayList
    implements HGSArray {
        private final List<Object> list;

        private HGSArrayList(List<Object> list) {
            this.list = list;
        }

        @Override
        public int hgsArraySize() {
            return this.list.size();
        }

        @Override
        public void hgsArrayAdd(Object initial) {
            this.list.add(initial);
        }

        @Override
        public void hgsArraySet(int i, Object val) {
            this.list.set(i, val);
        }

        @Override
        public Object hgsArrayGet(int i) {
            return this.list.get(i);
        }
    }

    private static final class HGSMapMap
    implements HGSMap {
        private final Map<String, Object> map;

        private HGSMapMap(Map<String, Object> map) {
            this.map = map;
        }

        @Override
        public void hgsMapPut(String key, Object val) {
            this.map.put(key, val);
        }

        @Override
        public Object hgsMapGet(String key) {
            return this.map.get(key);
        }
    }
}

