/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.hdl.hgs.function;

import de.neemann.digital.hdl.hgs.Context;
import de.neemann.digital.hdl.hgs.HGSEvalException;
import de.neemann.digital.hdl.hgs.function.FirstClassFunction;
import de.neemann.digital.hdl.hgs.function.Function;

public final class FirstClassFunctionCall
extends Function {
    private final FirstClassFunction func;
    private final Context capturedContext;

    public FirstClassFunctionCall(FirstClassFunction func, Context context) {
        super(func.getArgs().size());
        this.func = func;
        this.capturedContext = context;
    }

    @Override
    protected Object f(Object ... args) throws HGSEvalException {
        Context c = new Context(this.capturedContext);
        int i = 0;
        while (i < args.length) {
            c.declareVar(this.func.getArgs().get(i), args[i]);
            ++i;
        }
        try {
            this.func.getStatement().execute(c);
            return null;
        }
        catch (ReturnException e) {
            return e.getReturnValue();
        }
    }

    public static void returnFromFunc(Object returnValue) throws HGSEvalException {
        throw new ReturnException(returnValue);
    }

    private static final class ReturnException
    extends HGSEvalException {
        private final Object returnValue;

        private ReturnException(Object returnValue) {
            super("The return statement is allowed only in a function!");
            this.returnValue = returnValue;
        }

        private Object getReturnValue() {
            return this.returnValue;
        }
    }
}

