/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.hdl.hgs.refs;

import de.neemann.digital.hdl.hgs.Context;
import de.neemann.digital.hdl.hgs.Expression;
import de.neemann.digital.hdl.hgs.HGSEvalException;
import de.neemann.digital.hdl.hgs.function.InnerFunction;
import de.neemann.digital.hdl.hgs.refs.Reference;
import java.util.ArrayList;

public class ReferenceToFunc
implements Reference {
    private final Reference parent;
    private final ArrayList<Expression> args;

    public ReferenceToFunc(Reference parent, ArrayList<Expression> args) {
        this.parent = parent;
        this.args = args;
    }

    @Override
    public void declareVar(Context context, Object initial) throws HGSEvalException {
        this.set(context, initial);
    }

    @Override
    public void set(Context context, Object value) throws HGSEvalException {
        throw new HGSEvalException("It's not possible to write to a function!");
    }

    @Override
    public Object get(Context context) throws HGSEvalException {
        Object funcObj = this.parent.get(context);
        if (funcObj instanceof InnerFunction) {
            InnerFunction func = (InnerFunction)funcObj;
            if (func.getArgCount() >= 0 && func.getArgCount() != this.args.size()) {
                throw new HGSEvalException("wrong number of arguments! found: " + this.args.size() + ", expected: " + func.getArgCount());
            }
            return func.call(context, this.args);
        }
        throw new HGSEvalException("Value '" + funcObj + "' is not a function!");
    }
}

