/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.hdl.hgs.refs;

import de.neemann.digital.hdl.hgs.Context;
import de.neemann.digital.hdl.hgs.HGSEvalException;
import de.neemann.digital.hdl.hgs.HGSMap;
import de.neemann.digital.hdl.hgs.Value;
import de.neemann.digital.hdl.hgs.refs.Reference;

public class ReferenceToStruct
implements Reference {
    private final Reference parent;
    private final String name;

    public ReferenceToStruct(Reference parent, String name) {
        this.parent = parent;
        this.name = name;
    }

    @Override
    public void declareVar(Context context, Object initial) throws HGSEvalException {
        HGSMap hgsMap = Value.toMap(this.parent.get(context));
        if (hgsMap.hgsMapGet(this.name) != null) {
            throw new HGSEvalException("Value '" + this.name + "' redeclared in struct!");
        }
        hgsMap.hgsMapPut(this.name, initial);
    }

    @Override
    public void set(Context context, Object value) throws HGSEvalException {
        HGSMap hgsMap = Value.toMap(this.parent.get(context));
        if (hgsMap.hgsMapGet(this.name) == null) {
            throw new HGSEvalException("Value '" + this.name + "' not declared in struct!");
        }
        hgsMap.hgsMapPut(this.name, value);
    }

    @Override
    public Object get(Context context) throws HGSEvalException {
        Object value = Value.toMap(this.parent.get(context)).hgsMapGet(this.name);
        if (value == null) {
            throw new HGSEvalException("Value '" + this.name + "' is not available in the struct!");
        }
        return value;
    }

    public Reference getParent() {
        return this.parent;
    }

    public String getName() {
        return this.name;
    }
}

