/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.hdl.model2;

import de.neemann.digital.core.NodeException;
import de.neemann.digital.core.ObservableValues;
import de.neemann.digital.core.basic.And;
import de.neemann.digital.core.basic.NAnd;
import de.neemann.digital.core.basic.NOr;
import de.neemann.digital.core.basic.Not;
import de.neemann.digital.core.basic.Or;
import de.neemann.digital.core.basic.XNOr;
import de.neemann.digital.core.basic.XOr;
import de.neemann.digital.core.element.ElementTypeDescription;
import de.neemann.digital.core.element.Keys;
import de.neemann.digital.core.io.Const;
import de.neemann.digital.core.io.DipSwitch;
import de.neemann.digital.core.io.Ground;
import de.neemann.digital.core.io.PinControl;
import de.neemann.digital.core.io.VDD;
import de.neemann.digital.draw.elements.Circuit;
import de.neemann.digital.draw.elements.Pin;
import de.neemann.digital.draw.elements.PinException;
import de.neemann.digital.draw.elements.VisualElement;
import de.neemann.digital.draw.library.ElementLibrary;
import de.neemann.digital.draw.library.ElementNotFoundException;
import de.neemann.digital.draw.library.ElementTypeDescriptionCustom;
import de.neemann.digital.draw.library.ResolveGenerics;
import de.neemann.digital.draw.model.InverterConfig;
import de.neemann.digital.draw.model.ModelCreator;
import de.neemann.digital.hdl.model2.HDLCircuit;
import de.neemann.digital.hdl.model2.HDLException;
import de.neemann.digital.hdl.model2.HDLNet;
import de.neemann.digital.hdl.model2.HDLNode;
import de.neemann.digital.hdl.model2.HDLNodeAssignment;
import de.neemann.digital.hdl.model2.HDLNodeBuildIn;
import de.neemann.digital.hdl.model2.HDLNodeCustom;
import de.neemann.digital.hdl.model2.HDLPort;
import de.neemann.digital.hdl.model2.clock.HDLClockIntegrator;
import de.neemann.digital.hdl.model2.expression.ExprConstant;
import de.neemann.digital.hdl.model2.expression.ExprNot;
import de.neemann.digital.hdl.model2.expression.ExprOperate;
import de.neemann.digital.hdl.model2.expression.ExprVar;
import de.neemann.digital.hdl.model2.expression.Expression;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class HDLModel
implements Iterable<HDLCircuit> {
    private final ElementLibrary elementLibrary;
    private final HashMap<Circuit, HDLCircuit> circuitMap;
    private final HashMap<String, GenericsCache> genericInstanceNumbers;
    private HDLCircuit main;
    private Renaming renaming;

    public HDLModel(ElementLibrary elementLibrary) {
        this.elementLibrary = elementLibrary;
        this.circuitMap = new HashMap();
        this.genericInstanceNumbers = new HashMap();
    }

    public HDLNode createNode(VisualElement v, HDLCircuit parent) throws HDLException {
        try {
            ElementTypeDescription td = this.elementLibrary.getElementType(v.getElementName());
            if (td instanceof ElementTypeDescriptionCustom) {
                ElementTypeDescriptionCustom tdc = (ElementTypeDescriptionCustom)td;
                Circuit circuit = tdc.getCircuit();
                if (circuit.getAttributes().get(Keys.IS_GENERIC).booleanValue()) {
                    ResolveGenerics.CircuitHolder holder = new ResolveGenerics(circuit, this.elementLibrary).resolveCircuit(v.getElementAttributes());
                    GenericsCache cache = this.genericInstanceNumbers.computeIfAbsent(v.getElementName(), t -> new GenericsCache());
                    HDLCircuit c = cache.getHDLCircuit(holder.getArgs());
                    if (c == null) {
                        String elementName = v.getElementName();
                        elementName = this.cleanName(String.valueOf(elementName.substring(0, elementName.length() - 4)) + "_gen" + cache.getNum() + ".dig");
                        c = new HDLCircuit(holder.getCircuit(), elementName, this, parent.getDepth() + 1);
                        cache.addHDLCircuit(c, holder.getArgs());
                        this.circuitMap.put(holder.getCircuit(), c);
                    }
                    return this.addInputsOutputs(new HDLNodeCustom(v.getElementAttributes(), c), v, parent).createExpressions();
                }
                HDLCircuit c = this.circuitMap.get(circuit);
                String elementName = this.cleanName(v.getElementName());
                if (c == null) {
                    c = new HDLCircuit(circuit, elementName, this, parent.getDepth() + 1);
                    this.circuitMap.put(circuit, c);
                }
                return this.addInputsOutputs(new HDLNodeCustom(v.getElementAttributes(), c), v, parent).createExpressions();
            }
            if (v.equalsDescription(Const.DESCRIPTION)) {
                HDLNodeAssignment node = this.createExpression(v, parent, td);
                node.setExpression(new ExprConstant(node.getElementAttributes().get(Keys.VALUE), node.getOutput().getBits()));
                return node;
            }
            if (v.equalsDescription(DipSwitch.DESCRIPTION)) {
                HDLNodeAssignment node;
                node.setExpression(new ExprConstant((node = this.createExpression(v, parent, td)).getElementAttributes().get(Keys.DIP_DEFAULT) != false ? 1 : 0, node.getOutput().getBits()));
                return node;
            }
            if (v.equalsDescription(Ground.DESCRIPTION)) {
                HDLNodeAssignment node = this.createExpression(v, parent, td);
                node.setExpression(new ExprConstant(0L, node.getOutput().getBits()));
                return node;
            }
            if (v.equalsDescription(VDD.DESCRIPTION)) {
                HDLNodeAssignment node = this.createExpression(v, parent, td);
                node.setExpression(new ExprConstant(-1L, node.getOutput().getBits()));
                return node;
            }
            if (v.equalsDescription(Not.DESCRIPTION)) {
                HDLNodeAssignment node = this.createExpression(v, parent, td);
                node.setExpression(new ExprNot(new ExprVar(node.getInputs().get(0).getNet())));
                return node;
            }
            if (v.equalsDescription(Or.DESCRIPTION)) {
                HDLNodeAssignment node = this.createExpression(v, parent, td);
                node.setExpression(this.createOperation(node.getInputs(), ExprOperate.Operation.OR));
                return node;
            }
            if (v.equalsDescription(And.DESCRIPTION)) {
                HDLNodeAssignment node = this.createExpression(v, parent, td);
                node.setExpression(this.createOperation(node.getInputs(), ExprOperate.Operation.AND));
                return node;
            }
            if (v.equalsDescription(XOr.DESCRIPTION)) {
                HDLNodeAssignment node = this.createExpression(v, parent, td);
                node.setExpression(this.createOperation(node.getInputs(), ExprOperate.Operation.XOR));
                return node;
            }
            if (v.equalsDescription(NOr.DESCRIPTION)) {
                HDLNodeAssignment node = this.createExpression(v, parent, td);
                node.setExpression(new ExprNot(this.createOperation(node.getInputs(), ExprOperate.Operation.OR)));
                return node;
            }
            if (v.equalsDescription(NAnd.DESCRIPTION)) {
                HDLNodeAssignment node = this.createExpression(v, parent, td);
                node.setExpression(new ExprNot(this.createOperation(node.getInputs(), ExprOperate.Operation.AND)));
                return node;
            }
            if (v.equalsDescription(XNOr.DESCRIPTION)) {
                HDLNodeAssignment node = this.createExpression(v, parent, td);
                node.setExpression(new ExprNot(this.createOperation(node.getInputs(), ExprOperate.Operation.XOR)));
                return node;
            }
            return this.addInputsOutputs(new HDLNodeBuildIn(v.getElementName(), v.getElementAttributes(), new ObservableValuesBitsProvider(td.createElement(v.getElementAttributes()).getOutputs())), v, parent).createExpressions();
        }
        catch (NodeException | PinException | ElementNotFoundException e) {
            throw new HDLException("error creating node", e);
        }
    }

    private String cleanName(String s) {
        return s.replace("-", "_");
    }

    private Expression createOperation(ArrayList<HDLPort> inputs, ExprOperate.Operation op) {
        ArrayList<Expression> list = new ArrayList<Expression>();
        for (HDLPort p : inputs) {
            list.add(new ExprVar(p.getNet()));
        }
        return new ExprOperate(op, list);
    }

    private HDLNodeAssignment createExpression(VisualElement v, HDLCircuit parent, ElementTypeDescription td) throws HDLException, PinException, NodeException {
        return this.addInputsOutputs(new HDLNodeAssignment(v.getElementName(), v.getElementAttributes(), new ObservableValuesBitsProvider(td.createElement(v.getElementAttributes()).getOutputs())), v, parent);
    }

    private <N extends HDLNode> N addInputsOutputs(N node, VisualElement v, HDLCircuit c) throws HDLException, NodeException, PinException {
        for (Pin p : v.getPins()) {
            HDLNet net = c.getNetOfPin(p);
            switch (p.getDirection()) {
                case input: {
                    InverterConfig ic = v.getElementAttributes().get(Keys.INVERTER_CONFIG);
                    if (ic.contains(p.getName())) {
                        net = c.createNot(net);
                    }
                    node.addPort(new HDLPort(p.getName(), net, HDLPort.Direction.IN, 0));
                    break;
                }
                case output: {
                    node.addPort(new HDLPort(p.getName(), net, HDLPort.Direction.OUT, node.getBits(p.getName())));
                    break;
                }
                case both: {
                    if (v.equalsDescription(PinControl.DESCRIPTION)) {
                        if (c.getDepth() != 0) {
                            throw new HDLException("PinControl component is allowed only in the top level circuit");
                        }
                        node.addPort(new HDLPort(p.getName(), net, HDLPort.Direction.INOUT, node.getBits(p.getName())));
                        break;
                    }
                    node.addPort(new HDLPort(p.getName(), net, HDLPort.Direction.OUT, node.getBits(p.getName())));
                }
            }
        }
        return node;
    }

    @Override
    public Iterator<HDLCircuit> iterator() {
        return this.circuitMap.values().iterator();
    }

    public HDLModel create(Circuit circuit, HDLClockIntegrator clockIntegrator) throws PinException, HDLException, NodeException, ElementNotFoundException {
        circuit = ModelCreator.fixGenerics(circuit, this.elementLibrary);
        this.main = new HDLCircuit(circuit, "main", this, 0, clockIntegrator);
        this.circuitMap.put(circuit, this.main);
        return this;
    }

    public void renameLabels(Renaming renaming) throws HDLException {
        this.renaming = new RenameSingleCheck(renaming);
        for (HDLCircuit c : this.circuitMap.values()) {
            c.rename(this.renaming);
        }
    }

    public Renaming getRenaming() {
        return this.renaming;
    }

    public File getRoot() {
        return this.elementLibrary.getRootFilePath();
    }

    public HDLCircuit getMain() {
        return this.main;
    }

    public static interface BitProvider {
        public int getBits(String var1);
    }

    private static final class GenericsCache {
        private int num;
        private HashMap<ResolveGenerics.Args, HDLCircuit> map = new HashMap();

        private GenericsCache() {
        }

        private int getNum() {
            return this.num++;
        }

        private HDLCircuit getHDLCircuit(ResolveGenerics.Args args) {
            return this.map.get(args);
        }

        private void addHDLCircuit(HDLCircuit c, ResolveGenerics.Args args) {
            this.map.put(args, c);
        }
    }

    private static final class ObservableValuesBitsProvider
    implements BitProvider {
        private final ObservableValues values;

        private ObservableValuesBitsProvider(ObservableValues values) {
            this.values = values;
        }

        @Override
        public int getBits(String name) {
            return this.values.get(name).getBits();
        }
    }

    static final class RenameSingleCheck
    implements Renaming {
        private final Renaming parent;
        private final HashMap<String, String> map;

        private RenameSingleCheck(Renaming parent) {
            this.parent = parent;
            this.map = new HashMap();
        }

        @Override
        public String checkName(String name) {
            String n = this.map.get(name);
            if (n == null) {
                n = this.parent.checkName(name);
                this.map.put(name, n);
            }
            return n;
        }
    }

    public static interface Renaming {
        public String checkName(String var1);
    }
}

