/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.hdl.model2;

import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.hdl.model2.HDLModel;
import de.neemann.digital.hdl.model2.HDLNet;
import de.neemann.digital.hdl.model2.HDLNode;
import de.neemann.digital.hdl.model2.HDLPort;
import de.neemann.digital.hdl.model2.expression.ExprVar;
import de.neemann.digital.hdl.model2.expression.Expression;
import de.neemann.digital.hdl.model2.expression.Visitor;
import java.util.ArrayList;
import java.util.Iterator;

public class HDLNodeBuildIn
extends HDLNode
implements Iterable<InputAssignment> {
    private ArrayList<InputAssignment> inputAssignement = new ArrayList();

    public HDLNodeBuildIn(String elementName, ElementAttributes elementAttributes, HDLModel.BitProvider bitProvider) {
        super(elementName, elementAttributes, bitProvider);
    }

    @Override
    public void replaceNetByExpression(HDLNet net, Expression expression) {
        for (InputAssignment ia : this.inputAssignement) {
            ia.replaceNetByExpression(net, expression);
        }
    }

    @Override
    public <V extends Visitor> V traverseExpressions(V visitor) {
        for (InputAssignment ia : this) {
            ia.traverseExpressions(visitor);
        }
        return visitor;
    }

    HDLNode createExpressions() {
        for (HDLPort in : this.getInputs()) {
            this.inputAssignement.add(new InputAssignment(in.getName(), new ExprVar(in.getNet())));
        }
        return this;
    }

    @Override
    public Iterator<InputAssignment> iterator() {
        if (this.getInputs().size() != this.inputAssignement.size()) {
            throw new RuntimeException("no expressions created for " + this.getElementName());
        }
        return this.inputAssignement.iterator();
    }

    @Override
    public void rename(HDLModel.Renaming renaming) {
        super.rename(renaming);
        for (InputAssignment in : this.inputAssignement) {
            in.rename(renaming);
        }
    }

    public static final class InputAssignment {
        private String name;
        private Expression expression;

        private InputAssignment(String name, Expression expression) {
            this.name = name;
            this.expression = expression;
        }

        public String getTargetName() {
            return this.name;
        }

        public Expression getExpression() {
            return this.expression;
        }

        private void replaceNetByExpression(HDLNet net, Expression expr) {
            if (Expression.isVar(this.expression, net)) {
                this.expression = expr;
            } else {
                expr.replace(net, expr);
            }
        }

        private void rename(HDLModel.Renaming renaming) {
            this.name = renaming.checkName(this.name);
        }

        private <V extends Visitor> void traverseExpressions(V visitor) {
            this.expression.traverse(visitor);
        }
    }
}

