/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.hdl.model2.optimizations;

import de.neemann.digital.hdl.model2.HDLCircuit;
import de.neemann.digital.hdl.model2.HDLNet;
import de.neemann.digital.hdl.model2.HDLNode;
import de.neemann.digital.hdl.model2.HDLNodeAssignment;
import de.neemann.digital.hdl.model2.HDLPort;
import de.neemann.digital.hdl.model2.expression.ExprVarRange;
import de.neemann.digital.hdl.model2.expression.Expression;
import de.neemann.digital.hdl.model2.expression.Visitor;
import de.neemann.digital.hdl.model2.optimizations.Optimization;
import java.util.ArrayList;

public class MergeAssignments
implements Optimization {
    private HDLCircuit circuit;
    private ArrayList<HDLNode> nodes;

    @Override
    public void optimize(HDLCircuit circuit) {
        boolean wasOptimization;
        this.circuit = circuit;
        this.nodes = circuit.getNodes();
        block0: do {
            wasOptimization = false;
            int i = 0;
            while (i < this.nodes.size()) {
                HDLNode n1 = this.nodes.get(i);
                if (n1 instanceof HDLNodeAssignment) {
                    HDLNodeAssignment host = (HDLNodeAssignment)n1;
                    for (HDLPort p : host.getInputs()) {
                        HDLNodeAssignment include;
                        HDLNode n2 = this.searchCreator(p.getNet());
                        if (n2 == null || !(n2 instanceof HDLNodeAssignment) || (include = (HDLNodeAssignment)n2).getOutputs().size() != 1 || include.getOutput().getNet().getInputs().size() != 1 || !this.allowedToReplaceNet(host.getExpression(), include.getOutput().getNet())) continue;
                        this.nodes.set(i, this.merge(host, include));
                        this.nodes.remove(n2);
                        wasOptimization = true;
                        continue block0;
                    }
                }
                ++i;
            }
        } while (wasOptimization);
    }

    private boolean allowedToReplaceNet(Expression expression, HDLNet net) {
        CheckVarRangeVisitor visitor = new CheckVarRangeVisitor(net);
        expression.traverse(visitor);
        return visitor.ok;
    }

    private HDLNodeAssignment merge(HDLNodeAssignment host, HDLNodeAssignment include) {
        Expression expression = host.getExpression();
        HDLNet obsoleteNet = include.getOutput().getNet();
        expression.replace(obsoleteNet, include.getExpression());
        HDLNodeAssignment node = new HDLNodeAssignment("merged expression", null, name -> host.getOutput().getBits());
        node.setExpression(expression);
        this.circuit.removeNet(obsoleteNet);
        node.addPort(host.getOutput());
        for (HDLPort i : host.getInputs()) {
            if (i.getNet() == obsoleteNet) continue;
            node.addPort(i);
        }
        for (HDLPort i : include.getInputs()) {
            if (!node.hasInput(i)) {
                node.addPort(i);
                continue;
            }
            i.getNet().remove(i);
        }
        return node;
    }

    private HDLNode searchCreator(HDLNet net) {
        for (HDLNode n : this.nodes) {
            for (HDLPort p : n.getOutputs()) {
                if (p.getNet() != net) continue;
                return n;
            }
        }
        return null;
    }

    private static final class CheckVarRangeVisitor
    implements Visitor {
        private final HDLNet net;
        private boolean ok;

        private CheckVarRangeVisitor(HDLNet net) {
            this.net = net;
            this.ok = true;
        }

        @Override
        public void visit(Expression expression) {
            ExprVarRange evr;
            if (expression instanceof ExprVarRange && (evr = (ExprVarRange)expression).getNet() == this.net) {
                this.ok = false;
            }
        }
    }
}

