/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.hdl.model2.optimizations;

import de.neemann.digital.hdl.model2.HDLCircuit;
import de.neemann.digital.hdl.model2.HDLException;
import de.neemann.digital.hdl.model2.HDLNet;
import de.neemann.digital.hdl.model2.HDLNode;
import de.neemann.digital.hdl.model2.HDLPort;
import de.neemann.digital.hdl.model2.expression.ExprConstant;
import de.neemann.digital.hdl.model2.expression.ExprVar;
import de.neemann.digital.hdl.model2.optimizations.Optimization;
import java.util.ArrayList;

public class MergeConstants
implements Optimization {
    private HDLCircuit circuit;

    @Override
    public void optimize(HDLCircuit circuit) throws HDLException {
        this.circuit = circuit;
        ArrayList<HDLNode> nodes = circuit.getNodes();
        int n1 = 0;
        while (n1 < nodes.size()) {
            HDLNode node1 = nodes.get(n1);
            ExprConstant con1 = ExprConstant.isConstant(node1);
            if (con1 != null) {
                int n2 = n1 + 1;
                while (n2 < nodes.size()) {
                    HDLNode node2 = nodes.get(n2);
                    ExprConstant con2 = ExprConstant.isConstant(node2);
                    if (con2 != null && con1.isEqualTo(con2)) {
                        this.merge(node1, node2);
                        nodes.remove(n2);
                        --n2;
                    }
                    ++n2;
                }
            }
            ++n1;
        }
    }

    private void merge(HDLNode node1, HDLNode node2) throws HDLException {
        HDLNet usedNet = node1.getOutput().getNet();
        HDLNet obsoleteNet = node2.getOutput().getNet();
        ArrayList<HDLPort> ins = obsoleteNet.getInputs();
        HDLPort[] hDLPortArray = ins.toArray(new HDLPort[ins.size()]);
        int n = hDLPortArray.length;
        int n2 = 0;
        while (n2 < n) {
            HDLPort p = hDLPortArray[n2];
            p.setNet(usedNet);
            ++n2;
        }
        this.circuit.replaceNetByExpression(obsoleteNet, new ExprVar(usedNet));
        this.circuit.removeNet(obsoleteNet);
    }
}

