/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.hdl.model2.optimizations;

import de.neemann.digital.hdl.model2.HDLCircuit;
import de.neemann.digital.hdl.model2.HDLNet;
import de.neemann.digital.hdl.model2.HDLNode;
import de.neemann.digital.hdl.model2.HDLPort;
import de.neemann.digital.hdl.model2.expression.ExprUsingNet;
import de.neemann.digital.hdl.model2.expression.Expression;
import de.neemann.digital.hdl.model2.expression.Visitor;
import de.neemann.digital.hdl.model2.optimizations.Optimization;
import java.util.ArrayList;
import java.util.HashSet;

public class NodeSorterExpressionBased
implements Optimization {
    @Override
    public void optimize(HDLCircuit circuit) {
        ArrayList<HDLNode> nodes = circuit.getNodes();
        ArrayList<HDLNode> nodesAvail = new ArrayList<HDLNode>(nodes);
        nodes.clear();
        HashSet<HDLNet> nets = new HashSet<HDLNet>();
        for (HDLPort p : circuit.getInputs()) {
            nets.add(p.getNet());
        }
        for (HDLNode n : nodesAvail) {
            if (!n.getInputs().isEmpty()) continue;
            nodes.add(n);
            for (HDLPort p : n.getOutputs()) {
                if (p.getNet() == null) continue;
                nets.add(p.getNet());
            }
        }
        nodesAvail.removeAll(nodes);
        while (!nodesAvail.isEmpty()) {
            ArrayList<HDLNode> layer = new ArrayList<HDLNode>();
            for (HDLNode n : nodesAvail) {
                if (!n.traverseExpressions(new DependsOnlyOn(nets)).ok()) continue;
                layer.add(n);
            }
            if (layer.isEmpty()) {
                for (HDLNode n : nodesAvail) {
                    if (!n.traverseExpressions(new DependsAtLeastOnOneOf(nets)).ok()) continue;
                    layer.add(n);
                }
            }
            if (layer.isEmpty()) break;
            nodes.addAll(layer);
            nodesAvail.removeAll(layer);
            for (HDLNode n : layer) {
                for (HDLPort p : n.getOutputs()) {
                    if (p.getNet() == null) continue;
                    nets.add(p.getNet());
                }
            }
        }
        if (!nodesAvail.isEmpty()) {
            nodes.addAll(nodesAvail);
        }
    }

    private boolean dependsOnlyOn(HDLNode n, HashSet<HDLNet> nets) {
        for (HDLPort p : n.getInputs()) {
            if (p.getNet().isClock() || nets.contains(p.getNet())) continue;
            return false;
        }
        return true;
    }

    private boolean dependsAtLeastAtOne(HDLNode n, HashSet<HDLNet> nets) {
        for (HDLPort p : n.getInputs()) {
            if (p.getNet().isClock() || !nets.contains(p.getNet())) continue;
            return true;
        }
        return false;
    }

    private static final class DependsAtLeastOnOneOf
    implements Visitor {
        private final HashSet<HDLNet> nets;
        private boolean dependsAtLeastOnOne = false;

        private DependsAtLeastOnOneOf(HashSet<HDLNet> nets) {
            this.nets = nets;
        }

        @Override
        public void visit(Expression expression) {
            HDLNet net;
            if (expression instanceof ExprUsingNet && !(net = ((ExprUsingNet)((Object)expression)).getNet()).isClock() && this.nets.contains(net)) {
                this.dependsAtLeastOnOne = true;
            }
        }

        public boolean ok() {
            return this.dependsAtLeastOnOne;
        }
    }

    private static final class DependsOnlyOn
    implements Visitor {
        private final HashSet<HDLNet> nets;
        private boolean dependsOnlyOn = true;

        private DependsOnlyOn(HashSet<HDLNet> nets) {
            this.nets = nets;
        }

        @Override
        public void visit(Expression expression) {
            HDLNet net;
            if (expression instanceof ExprUsingNet && !(net = ((ExprUsingNet)((Object)expression)).getNet()).isClock() && !this.nets.contains(net)) {
                this.dependsOnlyOn = false;
            }
        }

        public boolean ok() {
            return this.dependsOnlyOn;
        }
    }
}

