/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.hdl.model2.optimizations;

import de.neemann.digital.hdl.model2.HDLCircuit;
import de.neemann.digital.hdl.model2.HDLNet;
import de.neemann.digital.hdl.model2.HDLNodeBuildIn;
import de.neemann.digital.hdl.model2.HDLNodeCustom;
import de.neemann.digital.hdl.model2.HDLNodeSplitterManyToOne;
import de.neemann.digital.hdl.model2.HDLPort;
import de.neemann.digital.hdl.model2.expression.ExprConstant;
import de.neemann.digital.hdl.model2.optimizations.Optimization;
import java.util.Iterator;

public class RemoveConstantSignals
implements Optimization {
    @Override
    public void optimize(HDLCircuit circuit) {
        Iterator<HDLNet> it = circuit.getNets().iterator();
        while (it.hasNext()) {
            HDLNet net = it.next();
            ExprConstant constant = net.isConstant();
            if (constant == null || !this.isOnlyUsedInSupportedNodes(net)) continue;
            circuit.getNodes().remove(net.getOutput().getParent());
            it.remove();
            circuit.replaceNetByExpression(net, new ExprConstant(constant));
        }
    }

    private boolean isOnlyUsedInSupportedNodes(HDLNet net) {
        for (HDLPort p : net.getInputs()) {
            if (p.getParent() instanceof HDLNodeBuildIn || p.getParent() instanceof HDLNodeCustom || p.getParent() instanceof HDLNodeSplitterManyToOne) continue;
            return false;
        }
        return true;
    }
}

