/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.hdl.model2.optimizations;

import de.neemann.digital.core.wiring.Splitter;
import de.neemann.digital.hdl.model2.HDLCircuit;
import de.neemann.digital.hdl.model2.HDLException;
import de.neemann.digital.hdl.model2.HDLNet;
import de.neemann.digital.hdl.model2.HDLNode;
import de.neemann.digital.hdl.model2.HDLNodeAssignment;
import de.neemann.digital.hdl.model2.HDLNodeSplitterOneToMany;
import de.neemann.digital.hdl.model2.HDLPort;
import de.neemann.digital.hdl.model2.expression.ExprVarRange;
import de.neemann.digital.hdl.model2.optimizations.Optimization;
import java.util.ArrayList;
import java.util.Iterator;

public class ReplaceOneToMany
implements Optimization {
    @Override
    public void optimize(HDLCircuit circuit) throws HDLException {
        ArrayList<HDLNodeAssignment> newNodes = new ArrayList<HDLNodeAssignment>();
        Iterator<HDLNode> it = circuit.getNodes().iterator();
        while (it.hasNext()) {
            HDLNode n = it.next();
            if (!(n instanceof HDLNodeSplitterOneToMany)) continue;
            it.remove();
            this.replace((HDLNodeSplitterOneToMany)n, newNodes);
        }
        circuit.getNodes().addAll(newNodes);
    }

    private void replace(HDLNodeSplitterOneToMany n, ArrayList<HDLNodeAssignment> newNodes) throws HDLException {
        HDLPort inPort = n.getInputs().get(0);
        HDLNet inNet = inPort.getNet();
        inPort.setNet(null);
        int i = 0;
        for (Splitter.Port p : n.getOutputSplit()) {
            HDLPort outPort = n.getOutputs().get(i);
            if (outPort.getNet() != null) {
                ExprVarRange exp = new ExprVarRange(inNet, p.getPos() + p.getBits() - 1, p.getPos());
                HDLNodeAssignment node = new HDLNodeAssignment("splitter", null, null);
                node.setExpression(exp);
                node.addPort(new HDLPort("in", inNet, HDLPort.Direction.IN, inPort.getBits()));
                node.addPort(outPort);
                newNodes.add(node);
            }
            ++i;
        }
    }
}

