/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.hdl.verilog2;

import de.neemann.digital.core.Bits;
import de.neemann.digital.core.wiring.Splitter;
import de.neemann.digital.draw.library.ElementLibrary;
import de.neemann.digital.hdl.hgs.HGSEvalException;
import de.neemann.digital.hdl.model2.HDLCircuit;
import de.neemann.digital.hdl.model2.HDLException;
import de.neemann.digital.hdl.model2.HDLNet;
import de.neemann.digital.hdl.model2.HDLNode;
import de.neemann.digital.hdl.model2.HDLNodeAssignment;
import de.neemann.digital.hdl.model2.HDLNodeBuildIn;
import de.neemann.digital.hdl.model2.HDLNodeCustom;
import de.neemann.digital.hdl.model2.HDLNodeSplitterManyToOne;
import de.neemann.digital.hdl.model2.HDLNodeSplitterOneToMany;
import de.neemann.digital.hdl.model2.HDLPort;
import de.neemann.digital.hdl.model2.expression.ExprConstant;
import de.neemann.digital.hdl.model2.expression.ExprNot;
import de.neemann.digital.hdl.model2.expression.ExprOperate;
import de.neemann.digital.hdl.model2.expression.ExprVar;
import de.neemann.digital.hdl.model2.expression.ExprVarRange;
import de.neemann.digital.hdl.model2.expression.Expression;
import de.neemann.digital.hdl.printer.CodePrinter;
import de.neemann.digital.hdl.verilog2.VerilogLibrary;
import de.neemann.digital.hdl.verilog2.lib.VerilogElement;
import de.neemann.digital.hdl.vhdl2.Separator;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VerilogCreator {
    private static final Logger LOGGER = LoggerFactory.getLogger(VerilogCreator.class);
    private final CodePrinter out;
    private final VerilogLibrary library;
    private final HashSet<String> customPrinted;

    VerilogCreator(CodePrinter out, ElementLibrary lib) {
        this.out = out;
        this.library = new VerilogLibrary(lib);
        this.customPrinted = new HashSet();
    }

    public static String getRange(int bits) {
        if (bits == 1) {
            return "";
        }
        return "[" + (bits - 1) + ":0]";
    }

    public static String getType(HDLPort.Direction def, HDLPort.Direction dir, int bits) {
        String result;
        if (dir == HDLPort.Direction.INOUT) {
            result = "inout";
        } else {
            String string = result = def == HDLPort.Direction.IN ? "input" : "output";
        }
        if (bits > 1) {
            result = String.valueOf(result) + " [" + (bits - 1) + ":0]";
        }
        return result;
    }

    public static String value(ExprConstant con) {
        return VerilogCreator.value(con.getValue(), con.getBits());
    }

    public static String value(long val, int bits) {
        String s = Long.toBinaryString(val & Bits.mask(bits));
        return String.valueOf(bits) + "'b" + s;
    }

    private void printNodeBuiltIn(HDLNodeBuildIn node, File root) throws HDLException, IOException, HGSEvalException {
        VerilogElement elem = this.library.getVerilogElement(node);
        String hdlEntityName = elem.print(this.out, node, root);
        node.setHdlEntityName(hdlEntityName);
    }

    private void printNodeCustom(HDLNodeCustom node, File root) throws HDLException, IOException, HGSEvalException {
        if (!this.customPrinted.contains(node.getElementName())) {
            this.printHDLCircuit(node.getCircuit(), node.getHdlEntityName(), root);
            this.customPrinted.add(node.getElementName());
        }
    }

    public void printHDLCircuit(HDLCircuit circuit, String moduleName, File root) throws IOException, HDLException, HGSEvalException {
        if (circuit.shouldSkipHDLExport()) {
            return;
        }
        for (HDLNode node : circuit) {
            if (node instanceof HDLNodeCustom) {
                this.printNodeCustom((HDLNodeCustom)node, root);
                continue;
            }
            if (!(node instanceof HDLNodeBuildIn)) continue;
            this.printNodeBuiltIn((HDLNodeBuildIn)node, root);
        }
        LOGGER.info("export " + moduleName);
        this.out.println();
        if (circuit.hasDescription()) {
            this.out.printComment("// ", circuit.getDescription());
        }
        this.out.print("module ").print(moduleName).println(" (").inc();
        VerilogCreator.writePorts(this.out, circuit);
        this.out.dec();
        this.out.println().println(");");
        this.out.inc();
        for (HDLNet net : circuit.getNets()) {
            if (!net.needsVariable()) continue;
            String range = "";
            if (net.getBits() > 1) {
                range = String.valueOf(range) + " [" + (net.getBits() - 1) + ":0]";
            }
            this.out.print("wire").print(range).print(" ").print(net.getName()).println(";");
        }
        int num = 0;
        for (HDLNode node : circuit) {
            if (node instanceof HDLNodeAssignment) {
                this.printExpression((HDLNodeAssignment)node);
                continue;
            }
            if (node instanceof HDLNodeBuildIn) {
                this.printModuleInstantiation((HDLNodeBuildIn)node, num++, root);
                continue;
            }
            if (node instanceof HDLNodeSplitterOneToMany) {
                this.printOneToMany((HDLNodeSplitterOneToMany)node);
                continue;
            }
            if (node instanceof HDLNodeSplitterManyToOne) {
                this.printManyToOne((HDLNodeSplitterManyToOne)node);
                continue;
            }
            throw new HDLException("Not yet implemented: " + node.getClass().getSimpleName());
        }
        for (HDLPort p : circuit.getOutputs()) {
            HDLNet net = p.getNet();
            if (!net.needsVariable() && !net.isInput()) continue;
            this.out.print("assign ").print(p.getName()).print(" = ").print(p.getNet().getName()).println(";");
        }
        this.out.dec().println("endmodule");
    }

    public static void writePorts(CodePrinter out, HDLCircuit circuit) throws IOException {
        Separator sep = new Separator(out, ",\n");
        for (HDLPort i : circuit.getInputs()) {
            sep.check();
            out.print(VerilogCreator.getType(HDLPort.Direction.IN, i.getDirection(), i.getBits())).print(" ").print(i.getName());
            if (!i.hasDescription()) continue;
            sep.setLineFinalizer(ou -> {
                CodePrinter codePrinter = ou.printComment(" // ", i.getDescription());
            });
        }
        for (HDLPort o : circuit.getOutputs()) {
            sep.check();
            out.print(VerilogCreator.getType(HDLPort.Direction.OUT, o.getDirection(), o.getBits())).print(" ").print(o.getName());
            if (!o.hasDescription()) continue;
            sep.setLineFinalizer(ou -> {
                CodePrinter codePrinter = ou.printComment(" // ", o.getDescription());
            });
        }
        sep.close();
    }

    private void printManyToOne(HDLNodeSplitterManyToOne node) throws IOException, HDLException {
        String target = node.getTargetSignal();
        if (target != null) {
            for (HDLNodeSplitterManyToOne.SplitterAssignment in : node) {
                this.out.print("assign ").print(target).print("[");
                if (in.getLsb() == in.getMsb()) {
                    this.out.print(in.getLsb());
                } else {
                    this.out.print(in.getMsb()).print(":").print(in.getLsb());
                }
                this.out.print("] = ");
                this.printExpression(in.getExpression());
                this.out.println(";");
            }
        }
    }

    private void printOneToMany(HDLNodeSplitterOneToMany node) throws IOException {
        String source = node.getSourceSignal();
        Splitter.Ports is = node.getOutputSplit();
        int i = 0;
        for (HDLPort outPort : node.getOutputs()) {
            Splitter.Port sp = is.getPort(i++);
            if (outPort.getNet() == null) continue;
            this.out.print(outPort.getNet().getName()).print(" <= ").print(source).print("(");
            if (outPort.getBits() == 1) {
                this.out.print(sp.getPos());
            } else {
                this.out.print(sp.getPos() + sp.getBits() - 1).print(" downto ").print(sp.getPos());
            }
            this.out.println(");");
        }
    }

    private void printModuleInstantiation(HDLNodeBuildIn node, int num, File root) throws IOException, HDLException {
        String entityName = node.getHdlEntityName();
        String label = node.getElementAttributes().getLabel();
        if (label != null && label.length() > 0) {
            this.out.print("// ").println(label.replace('\n', ' '));
        }
        this.out.print(entityName).print(" ");
        if (!(node instanceof HDLNodeCustom)) {
            this.library.getVerilogElement(node).writeGenericMap(this.out, node, root);
        }
        String instanceName = String.valueOf(entityName.trim()) + "_i" + num;
        this.out.print(String.valueOf(instanceName) + " ").println("(");
        this.out.inc();
        Separator sep = new Separator(this.out, ",\n");
        for (HDLNodeBuildIn.InputAssignment i : node) {
            sep.check();
            this.out.print(".").print(i.getTargetName()).print("( ");
            this.printExpression(i.getExpression());
            this.out.print(" )");
        }
        for (HDLPort o : node.getOutputs()) {
            if (o.getNet() == null) continue;
            sep.check();
            this.out.print(".").print(o.getName()).print("( ").print(o.getNet().getName()).print(" )");
        }
        for (HDLPort o : node.getInOutputs()) {
            if (o.getNet() == null) continue;
            sep.check();
            this.out.print(".").print(o.getName()).print("( ").print(o.getNet().getName()).print(" )");
        }
        this.out.dec();
        this.out.println().println(");");
    }

    private void printExpression(HDLNodeAssignment node) throws IOException, HDLException {
        if (node.getTargetNet() != null) {
            this.out.print("assign ").print(node.getTargetNet().getName()).print(" = ");
            this.printExpression(node.getExpression());
            this.out.println(";");
        }
    }

    private void printExpression(Expression expression) throws IOException, HDLException {
        if (expression instanceof ExprVar) {
            this.out.print(((ExprVar)expression).getNet().getName());
        } else if (expression instanceof ExprVarRange) {
            ExprVarRange evr = (ExprVarRange)expression;
            this.out.print(evr.getNet().getName()).print("[");
            if (evr.getMsb() == evr.getLsb()) {
                this.out.print(evr.getMsb());
            } else {
                this.out.print(evr.getMsb()).print(":").print(evr.getLsb());
            }
            this.out.print("]");
        } else if (expression instanceof ExprConstant) {
            ExprConstant constant = (ExprConstant)expression;
            this.out.print(VerilogCreator.value(constant));
        } else if (expression instanceof ExprNot) {
            this.out.print("~ ");
            Expression inner = ((ExprNot)expression).getExpression();
            if (inner instanceof ExprNot) {
                this.out.print("(");
                this.printExpression(inner);
                this.out.print(")");
            } else {
                this.printExpression(inner);
            }
        } else if (expression instanceof ExprOperate) {
            String op;
            this.out.print("(");
            boolean first = true;
            ExprOperate operate = (ExprOperate)expression;
            switch (operate.getOperation()) {
                case OR: {
                    op = " | ";
                    break;
                }
                case AND: {
                    op = " & ";
                    break;
                }
                case XOR: {
                    op = " ^ ";
                    break;
                }
                default: {
                    throw new HDLException("unknown operation " + (Object)((Object)operate.getOperation()));
                }
            }
            for (Expression exp : operate.getOperands()) {
                if (first) {
                    first = false;
                } else {
                    this.out.print(op);
                }
                this.printExpression(exp);
            }
            this.out.print(")");
        } else {
            throw new HDLException("expression type " + expression.getClass().getSimpleName() + " unknown");
        }
    }
}

