/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.hdl.verilog2;

import de.neemann.digital.core.element.ElementTypeDescription;
import de.neemann.digital.draw.library.ElementLibrary;
import de.neemann.digital.draw.library.ElementNotFoundException;
import de.neemann.digital.hdl.model2.HDLException;
import de.neemann.digital.hdl.model2.HDLNode;
import de.neemann.digital.hdl.verilog2.lib.VerilogElement;
import de.neemann.digital.hdl.verilog2.lib.VerilogTemplate;
import de.neemann.digital.lang.Lang;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VerilogLibrary {
    private static final Logger LOGGER = LoggerFactory.getLogger(VerilogLibrary.class);
    private final HashMap<String, VerilogElement> map;
    private final ArrayList<HDLNode> nodeList = new ArrayList();
    private final ElementLibrary elementLibrary;

    public VerilogLibrary(ElementLibrary elementLibrary) {
        this.elementLibrary = elementLibrary;
        this.map = new HashMap();
    }

    private void put(ElementTypeDescription description, VerilogElement velem) {
        this.map.put(description.getName(), velem);
    }

    public VerilogElement getVerilogElement(HDLNode node) throws HDLException {
        String elementName = node.getElementName();
        VerilogElement e = this.map.get(elementName);
        if (e == null) {
            try {
                ClassLoader cl = null;
                try {
                    cl = this.elementLibrary.getElementType(elementName).getClassLoader();
                }
                catch (ElementNotFoundException elementNotFoundException) {
                    // empty catch block
                }
                e = new VerilogTemplate(elementName, cl);
                this.map.put(elementName, e);
            }
            catch (IOException ex) {
                ex.printStackTrace();
                LOGGER.info("could not load '" + VerilogTemplate.neededFileName(elementName) + "'");
            }
        }
        if (e == null) {
            throw new HDLException(Lang.get("err_verilogNoElement_N", elementName));
        }
        return e;
    }

    public String getName(HDLNode node) {
        if (!this.nodeList.contains(node)) {
            this.nodeList.add(node);
            node.setHdlEntityName(node.getElementName());
        }
        return node.getHdlEntityName();
    }
}

