/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.hdl.vhdl2;

import de.neemann.digital.core.NodeException;
import de.neemann.digital.core.element.Keys;
import de.neemann.digital.draw.elements.Circuit;
import de.neemann.digital.draw.elements.PinException;
import de.neemann.digital.draw.library.ElementLibrary;
import de.neemann.digital.draw.library.ElementNotFoundException;
import de.neemann.digital.hdl.hgs.HGSEvalException;
import de.neemann.digital.hdl.model2.HDLCircuit;
import de.neemann.digital.hdl.model2.HDLException;
import de.neemann.digital.hdl.model2.HDLModel;
import de.neemann.digital.hdl.model2.HDLNet;
import de.neemann.digital.hdl.model2.clock.HDLClockIntegrator;
import de.neemann.digital.hdl.printer.CodePrinter;
import de.neemann.digital.hdl.vhdl2.VHDLCreator;
import de.neemann.digital.hdl.vhdl2.VHDLRenaming;
import de.neemann.digital.hdl.vhdl2.VHDLTestBenchCreator;
import de.neemann.digital.lang.Lang;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

public class VHDLGenerator
implements Closeable {
    private final ElementLibrary library;
    private final CodePrinter out;
    private ArrayList<File> testBenches;
    private HDLModel model;
    private HDLClockIntegrator clockIntegrator;

    public VHDLGenerator(ElementLibrary library, CodePrinter out) {
        this.library = library;
        this.out = out;
    }

    public VHDLGenerator export(Circuit circuit) throws IOException {
        try {
            if (!circuit.getAttributes().get(Keys.ROMMANAGER).isEmpty()) {
                throw new HDLException(Lang.get("err_centralDefinedRomsAreNotSupported", new Object[0]));
            }
            this.model = new HDLModel(this.library).create(circuit, this.clockIntegrator);
            for (HDLCircuit hdlCircuit : this.model) {
                hdlCircuit.applyDefaultOptimizations();
            }
            this.model.renameLabels(new VHDLRenaming());
            for (HDLCircuit hdlCircuit : this.model) {
                this.checkForUniqueNetNames(hdlCircuit);
            }
            this.out.println("-- generated by Digital. Don't modify this file!");
            this.out.println("-- Any changes will be lost if this file is regenerated.");
            new VHDLCreator(this.out, this.library).printHDLCircuit(this.model.getMain(), this.model.getRoot());
            File outFile = this.out.getFile();
            if (outFile != null) {
                this.testBenches = new VHDLTestBenchCreator(circuit, this.model).write(outFile).getTestFileWritten();
            }
            return this;
        }
        catch (NodeException | PinException | ElementNotFoundException | HGSEvalException | HDLException | NullPointerException e) {
            throw new IOException(Lang.get("err_vhdlExporting", new Object[0]), e);
        }
    }

    private void checkForUniqueNetNames(HDLCircuit hdlCircuit) throws HDLException {
        ArrayList<HDLNet> nets = hdlCircuit.getNets();
        for (HDLNet n : nets) {
            if (!n.isUserNamed()) continue;
            for (HDLNet nn : nets) {
                if (!n.getName().equalsIgnoreCase(nn.getName()) || n == nn) continue;
                String newName = "s_" + n.getName();
                int i = 1;
                while (this.exits(newName, nets)) {
                    newName = "s_" + n.getName() + i++;
                }
                n.setName(newName);
            }
        }
        int i = 0;
        while (i < nets.size()) {
            HDLNet n1 = nets.get(i);
            int j = i + 1;
            while (j < nets.size()) {
                HDLNet n2 = nets.get(j);
                if (n1.getName().equalsIgnoreCase(n2.getName())) {
                    throw new HDLException(Lang.get("err_namesAreNotUnique_N", String.valueOf(n1.getName()) + "==" + n2.getName()), hdlCircuit.getOrigin());
                }
                ++j;
            }
            ++i;
        }
    }

    private boolean exits(String newName, ArrayList<HDLNet> nets) {
        for (HDLNet n : nets) {
            if (!n.getName().equalsIgnoreCase(newName)) continue;
            return true;
        }
        return false;
    }

    public void setClockIntegrator(HDLClockIntegrator clockIntegrator) {
        this.clockIntegrator = clockIntegrator;
    }

    public ArrayList<File> getTestBenches() {
        return this.testBenches;
    }

    public String toString() {
        return this.out.toString();
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }

    public HDLModel getModel() {
        return this.model;
    }
}

