/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.testing;

import de.neemann.digital.core.ObservableValue;
import de.neemann.digital.data.Value;
import de.neemann.digital.lang.Lang;

public class MatchedValue
extends Value {
    private final Value expected;
    private final long mask;

    MatchedValue(Value expected, ObservableValue found) {
        super(found);
        this.expected = expected;
        this.mask = (1L << found.getBits()) - 1L;
    }

    boolean isPassed() {
        return this.isEqualTo(this.expected, this.mask);
    }

    @Override
    public String toString() {
        if (this.isPassed()) {
            return super.toString();
        }
        return Lang.get("msg_testExp_N0_found_N1", this.expected, super.toString());
    }

    @Override
    public Value.State getState() {
        if (this.isPassed()) {
            return Value.State.PASS;
        }
        return Value.State.FAIL;
    }
}

