/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.testing;

import de.neemann.digital.core.element.PinDescription;
import de.neemann.digital.data.Value;
import de.neemann.digital.testing.parser.Context;
import de.neemann.digital.testing.parser.Parser;
import de.neemann.digital.testing.parser.ParserException;
import de.neemann.digital.testing.parser.TestRow;
import java.io.IOException;
import java.util.ArrayList;

public class Transitions {
    private final String text;
    private final ArrayList<TestRow> uniqueLines;
    private final ArrayList<Integer> inVarNum;

    public Transitions(String text, PinDescription[] inputs) throws IOException, ParserException {
        this.text = text;
        this.uniqueLines = new ArrayList();
        Parser p = new Parser(text).parse();
        this.inVarNum = new ArrayList();
        ArrayList<String> testNames = p.getNames();
        int i = 0;
        while (i < testNames.size()) {
            String in = testNames.get(i);
            boolean found = false;
            PinDescription[] pinDescriptionArray = inputs;
            int n = inputs.length;
            int n2 = 0;
            while (n2 < n) {
                PinDescription pin = pinDescriptionArray[n2];
                if (pin.getName().equals(in)) {
                    found = true;
                    break;
                }
                ++n2;
            }
            if (found) {
                this.inVarNum.add(i);
            }
            ++i;
        }
        p.getLines().emitLines(line -> {
            if (this.isNormal(line)) {
                boolean found = false;
                for (TestRow u : this.uniqueLines) {
                    if (!this.isInputEqual(line, u)) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    this.uniqueLines.add(line);
                }
            }
        }, new Context());
    }

    private boolean isInputEqual(TestRow l1, TestRow l2) {
        if (l1.getValues().length != l2.getValues().length) {
            return false;
        }
        for (int i : this.inVarNum) {
            if (l1.getValues()[i].isEqualTo(l2.getValues()[i])) continue;
            return false;
        }
        return true;
    }

    private boolean isNormal(TestRow line) {
        Value[] valueArray = line.getValues();
        int n = valueArray.length;
        int n2 = 0;
        while (n2 < n) {
            Value v = valueArray[n2];
            if (v.getType().equals((Object)Value.Type.CLOCK) || v.getType().equals((Object)Value.Type.DONTCARE)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public String getCompletedText() {
        return String.valueOf(this.text) + "\n\n\n# transitions\n" + this.getTransitionTests();
    }

    public boolean isNew() {
        return this.uniqueLines.size() > 1;
    }

    private String getTransitionTests() {
        ArrayList<Trans> trans = new ArrayList<Trans>();
        for (TestRow a : this.uniqueLines) {
            for (TestRow b : this.uniqueLines) {
                if (this.isInputEqual(a, b)) continue;
                trans.add(new Trans(a, b));
            }
        }
        StringBuilder sb = new StringBuilder();
        TestRow last = null;
        while (!trans.isEmpty()) {
            Trans found = null;
            if (last != null) {
                for (Trans t : trans) {
                    if (!this.isInputEqual(t.a, last)) continue;
                    found = t;
                    break;
                }
            }
            if (found == null) {
                Trans t;
                t = (Trans)trans.remove(0);
                this.toString(sb, t.a.getValues());
                sb.append("\n");
                this.toString(sb, t.b.getValues());
                sb.append("\n");
                last = t.b;
                continue;
            }
            this.toString(sb, found.b.getValues());
            sb.append("\n");
            last = found.b;
            trans.remove(found);
        }
        return sb.toString();
    }

    private void toString(StringBuilder sb, Value[] a) {
        boolean first = true;
        Value[] valueArray = a;
        int n = a.length;
        int n2 = 0;
        while (n2 < n) {
            Value v = valueArray[n2];
            if (first) {
                first = false;
            } else {
                sb.append(" ");
            }
            sb.append(v.toString());
            ++n2;
        }
    }

    private static final class Trans {
        private final TestRow a;
        private final TestRow b;

        private Trans(TestRow a, TestRow b) {
            this.a = a;
            this.b = b;
        }
    }
}

